/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;

public class ChartAxes
extends Object3d {
    private int m_Thickness = 5;
    private ShadedColor m_Color;

    public ChartAxes(String string, World world) {
        this(string, world, new ShadedColor(250, 190, 190));
    }

    public ChartAxes(String string, World world, ShadedColor shadedColor) {
        super(world, new Point3d(), new Angle3d());
        this.m_Color = shadedColor.makeClone();
        Polyhedron polyhedron = this.buildPoly(string);
        this.setPolyhedron(polyhedron, new Point3d(1.0, 1.0, 1.0));
    }

    private Polyhedron buildPoly(String string) {
        ArrayOf3dPoints arrayOf3dPoints = this.buildPoints();
        IndexingPolygon[] indexingPolygonArray = this.buildPolygons();
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        polyhedron.setId(string);
        return polyhedron;
    }

    private ArrayOf3dPoints buildPoints() {
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(14);
        int n = -1;
        arrayOf3dPoints.setPoint(0, n, n, n);
        arrayOf3dPoints.setPoint(1, n, n, 200.0);
        arrayOf3dPoints.setPoint(2, n, 200.0, 200.0);
        arrayOf3dPoints.setPoint(3, n, 200.0, n);
        arrayOf3dPoints.setPoint(4, 200.0, 200.0, n);
        arrayOf3dPoints.setPoint(5, 200.0, n, n);
        arrayOf3dPoints.setPoint(6, 200.0, n, 200.0);
        arrayOf3dPoints.setPoint(7, n -= this.m_Thickness, n, n);
        arrayOf3dPoints.setPoint(8, n, n, 200.0);
        arrayOf3dPoints.setPoint(9, n, 200.0, 200.0);
        arrayOf3dPoints.setPoint(10, n, 200.0, n);
        arrayOf3dPoints.setPoint(11, 200.0, 200.0, n);
        arrayOf3dPoints.setPoint(12, 200.0, n, n);
        arrayOf3dPoints.setPoint(13, 200.0, n, 200.0);
        return arrayOf3dPoints;
    }

    private IndexingPolygon[] buildPolygons() {
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[]{new RenderedPolygon("front-left", new int[]{0, 1, 2, 3}, this.m_Color), new RenderedPolygon("front-right", new int[]{0, 3, 4, 5}, this.m_Color), new RenderedPolygon("front-base", new int[]{0, 5, 6, 1}, this.m_Color), new RenderedPolygon("back-left", new int[]{7, 8, 9, 10}, this.m_Color), new RenderedPolygon("back-right", new int[]{7, 10, 11, 12}, this.m_Color), new RenderedPolygon("back-base", new int[]{7, 12, 13, 8}, this.m_Color), new RenderedPolygon("left-edge", new int[]{1, 8, 9, 2}, this.m_Color), new RenderedPolygon("left-top-edge", new int[]{2, 9, 10, 3}, this.m_Color), new RenderedPolygon("right-top-edge", new int[]{3, 10, 11, 4}, this.m_Color), new RenderedPolygon("right-edge", new int[]{4, 11, 12, 5}, this.m_Color), new RenderedPolygon("right-bottom-edge", new int[]{5, 12, 13, 6}, this.m_Color), new RenderedPolygon("left-bottom-edge", new int[]{6, 13, 8, 1}, this.m_Color)};
        return indexingPolygonArray;
    }
}

