/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart.values;

import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;
import java.util.ArrayList;
import java.util.List;

public class ColumnValues {
    private List<Polyhedron> m_Polyhedrons = new ArrayList<Polyhedron>();

    public ColumnValues(String string, World world, Point3d point3d, Angle3d angle3d, ShadedColor shadedColor, double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > 0.0) {
                Polyhedron polyhedron = ColumnValues.buildValue(dArray[i], 20, 2, n, 20, shadedColor);
                Value value = new Value(world, point3d, angle3d, polyhedron);
                value.setId(string + "." + i);
                this.m_Polyhedrons.add(polyhedron);
            }
            n += 20;
        }
    }

    public ColumnValues(String string, World world, Number[] numberArray, int n, int n2, int n3, ShadedColor shadedColor) {
        int n4 = 0;
        for (int i = 0; i < numberArray.length; ++i) {
            if (numberArray[i].doubleValue() > 0.0) {
                Polyhedron polyhedron = ColumnValues.buildValue(numberArray[i].doubleValue(), n3, n3 / 5, n4, n, shadedColor);
                Value value = new Value(world, new Point3d(0.0, 0.0, n2 - n3 / 2), new Angle3d(), polyhedron);
                value.setId(string + "." + i);
                this.m_Polyhedrons.add(polyhedron);
            }
            n4 += n;
        }
    }

    public Polyhedron getPolyhedron(int n) {
        return this.m_Polyhedrons.get(n);
    }

    public static Polyhedron buildValue(double d, int n, int n2, int n3, int n4, ShadedColor shadedColor) {
        double d2 = (double)n / 2.0;
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[8];
        dArray[2] = dArray[3] = (double)(n3 + n2);
        dArray[1] = dArray[3];
        dArray[0] = dArray[3];
        dArray[6] = dArray[7] = (double)(n3 + n4 - n2);
        dArray[5] = dArray[7];
        dArray[4] = dArray[7];
        dArray2[0] = 0.0;
        dArray2[1] = d;
        dArray2[2] = d;
        dArray2[3] = 0.0;
        dArray2[4] = 0.0;
        dArray2[5] = d;
        dArray2[6] = d;
        dArray2[7] = 0.0;
        dArray3[0] = d2;
        dArray3[1] = d2;
        dArray3[2] = -d2;
        dArray3[3] = -d2;
        dArray3[4] = d2;
        dArray3[5] = d2;
        dArray3[6] = -d2;
        dArray3[7] = -d2;
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 8);
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[]{new RenderedPolygon("p0-" + String.valueOf(shadedColor), new int[]{0, 1, 5, 4}, shadedColor), new RenderedPolygon("p1-" + String.valueOf(shadedColor), new int[]{1, 2, 6, 5}, shadedColor), new RenderedPolygon("p2-" + String.valueOf(shadedColor), new int[]{2, 3, 7, 6}, shadedColor), new RenderedPolygon("p3-" + String.valueOf(shadedColor), new int[]{3, 0, 4, 7}, shadedColor), new RenderedPolygon("p4-" + String.valueOf(shadedColor), new int[]{2, 1, 0, 3}, shadedColor), new RenderedPolygon("p5-" + String.valueOf(shadedColor), new int[]{4, 5, 6, 7}, shadedColor)};
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    private static class Value
    extends Object3d {
        public Value(World world, Point3d point3d, Angle3d angle3d, Polyhedron polyhedron) {
            super(world, point3d, angle3d);
            this.setPolyhedron(polyhedron, new Point3d(1.0, 1.0, 1.0));
        }
    }
}

