/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.basic;

import com.elixirtech.map.IShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class BasicShape
implements IShape {
    public static final String ID = "Id";
    private final String m_Name;
    private final GeneralPath m_Shape;
    private final Map<String, String> m_Attributes;

    public BasicShape(String string, Map<String, String> map, float[] fArray, float[] fArray2) {
        this.m_Name = string;
        this.m_Attributes = map;
        if (fArray.length < 3) {
            throw new IllegalArgumentException("xs.length<3");
        }
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("xs.length!=ys.length");
        }
        this.m_Shape = new GeneralPath();
        this.m_Shape.moveTo(fArray[0], fArray2[0]);
        for (int i = 1; i < fArray.length; ++i) {
            this.m_Shape.lineTo(fArray[i], fArray2[i]);
        }
        this.m_Shape.closePath();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getToolTip() {
        return this.m_Name;
    }

    @Override
    public String getAttribute(String string) {
        if (ID.equals(string)) {
            return this.m_Name;
        }
        if (this.m_Attributes == null) {
            return null;
        }
        return this.m_Attributes.get(string);
    }

    @Override
    public Shape getShape() {
        return this.m_Shape;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.m_Shape.getBounds2D();
    }

    @Override
    public boolean isHit(Point2D point2D) {
        return this.m_Shape.contains(point2D);
    }
}

