/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.coloring;

import com.elixirtech.map.coloring.PositionBasedColoringAlgorithm;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Gradient2ColoringAlgorithm
extends PositionBasedColoringAlgorithm {
    private Color m_First = new Color(0, 64, 128);
    private Color m_Second = new Color(128, 196, 1);

    @Override
    public void setConfig(String string) {
        String[] stringArray = string.split("\\|");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Two colours required");
        }
        this.m_First = StandardColor.lookup(stringArray[0].trim());
        this.m_Second = StandardColor.lookup(stringArray[1].trim());
    }

    @Override
    public Color getColor(float f) {
        return Gradient2ColoringAlgorithm.getColorBetween(this.m_First, this.m_Second, f);
    }

    public static Color getColorBetween(Color color, Color color2, float f) {
        if (f <= 0.0f) {
            return color;
        }
        if (f >= 1.0f) {
            return color2;
        }
        float[] fArray = color.getRGBColorComponents(null);
        float[] fArray2 = color2.getRGBColorComponents(null);
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray3[i] = fArray[i] + (fArray2[i] - fArray[i]) * f;
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2]);
    }

    @Override
    public void fillContinuousRange(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        Color color;
        Color color2;
        if (bl2) {
            color2 = this.m_First;
            color = this.m_Second;
        } else {
            color2 = this.m_Second;
            color = this.m_First;
        }
        if (bl) {
            graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.x, rectangle.y + rectangle.height, color));
        } else {
            graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.x + rectangle.width, rectangle.y, color));
        }
        graphics2D.fill(rectangle);
    }
}

