/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.coloring;

import com.elixirtech.map.coloring.Gradient2ColoringAlgorithm;
import com.elixirtech.map.coloring.PositionBasedColoringAlgorithm;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Gradient3ColoringAlgorithm
extends PositionBasedColoringAlgorithm {
    private Color m_First = new Color(0, 64, 128);
    private Color m_Second = new Color(128, 196, 1);
    private Color m_Third = new Color(128, 196, 1);

    @Override
    public void setConfig(String string) {
        String[] stringArray = string.split("\\|");
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("Three colours required");
        }
        this.m_First = StandardColor.lookup(stringArray[0].trim());
        this.m_Second = StandardColor.lookup(stringArray[1].trim());
        this.m_Third = StandardColor.lookup(stringArray[2].trim());
    }

    @Override
    public Color getColor(float f) {
        if ((double)f <= 0.5) {
            return Gradient2ColoringAlgorithm.getColorBetween(this.m_First, this.m_Second, f * 2.0f);
        }
        return Gradient2ColoringAlgorithm.getColorBetween(this.m_Second, this.m_Third, (f - 0.5f) * 2.0f);
    }

    @Override
    public void fillContinuousRange(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        Color color;
        Color color2;
        if (bl2) {
            color2 = this.m_First;
            color = this.m_Third;
        } else {
            color2 = this.m_Third;
            color = this.m_First;
        }
        if (bl) {
            int n = rectangle.height / 2;
            GradientPaint gradientPaint = new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.x, rectangle.y + n, this.m_Second);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, n);
            GradientPaint gradientPaint2 = new GradientPaint(rectangle.x, rectangle.y + n, this.m_Second, rectangle.x, rectangle.y + rectangle.height, color);
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fillRect(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        } else {
            int n = rectangle.width / 2;
            GradientPaint gradientPaint = new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.x + n, rectangle.y, this.m_Second);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
            GradientPaint gradientPaint3 = new GradientPaint(rectangle.x + n, rectangle.y, this.m_Second, rectangle.x + rectangle.width, rectangle.y, color);
            graphics2D.setPaint(gradientPaint3);
            graphics2D.fillRect(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height);
        }
    }
}

