/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.coloring;

import com.elixirtech.map.FillData;
import com.elixirtech.map.coloring.IColoringAlgorithm;
import com.elixirtech.map.util.Range;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class PositionBasedColoringAlgorithm
implements IColoringAlgorithm {
    @Override
    public void setData(FillData fillData) {
        Range range = fillData.getValueRange();
        if (range != null) {
            for (FillData.Item item : fillData.getItems()) {
                double d = ((Number)item.value).doubleValue();
                item.color = this.getColor((float)range.getPercent(d));
            }
        } else {
            Set<Object> set = fillData.getValueSet();
            float f = set.size();
            if (f > 1.0f) {
                HashMap<Object, Color> hashMap = new HashMap<Object, Color>();
                float f2 = 0.0f;
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashMap.put(iterator.next(), this.getColor(f2 / (f - 1.0f)));
                    f2 += 1.0f;
                }
                for (FillData.Item item : fillData.getItems()) {
                    item.color = (Color)hashMap.get(item.value);
                }
            } else {
                Color color = this.getColor(0.0f);
                for (FillData.Item item : fillData.getItems()) {
                    item.color = color;
                }
            }
        }
    }

    @Override
    public boolean supportsContinuousRange() {
        return true;
    }

    public abstract Color getColor(float var1);
}

