/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.SAXDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BeanMap {
    private static Map<String, String> m_SAX = new HashMap<String, String>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BeanMap.class);

    public static SAXDelegate getSAXDelegate(String string) {
        SAXDelegate sAXDelegate = null;
        String string2 = m_SAX.get(string) + "SAX";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(string2, true, classLoader);
            if (clazz != null) {
                sAXDelegate = (SAXDelegate)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error loading SAXDelegate for " + string), (Throwable)exception);
        }
        return sAXDelegate;
    }

    public static IBeanSAXOut getSAXOutputter(IBean iBean) {
        Class<?> clazz;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string = iBean.getClass().getName() + "SAXOut";
        try {
            clazz = Class.forName(string, true, classLoader);
            if (clazz != null) {
                return (IBeanSAXOut)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = m_SAX.get(iBean.getTagName()) + "SAXOut";
        try {
            clazz = Class.forName(string, true, classLoader);
            if (clazz != null) {
                return (IBeanSAXOut)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error loading SAXOut for " + iBean.getTagName()), (Throwable)exception);
        }
        return null;
    }

    public static void add(String string, String string2) {
        m_SAX.put(string, string2);
    }

    public static String[] beanNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(m_SAX.values());
        Collections.sort(arrayList);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    static {
        try {
            BeanMap.add("basic-mapsource", "com.elixirtech.map.model.BasicMapSource");
            BeanMap.add("ds-mapsource", "com.elixirtech.map.model.DSMapSource");
            BeanMap.add("font", "com.elixirtech.map.model.Font");
            BeanMap.add("format", "com.elixirtech.map.model.Format");
            BeanMap.add("layer", "com.elixirtech.map.model.Layer");
            BeanMap.add("legend", "com.elixirtech.map.model.Legend");
            BeanMap.add("mapfile", "com.elixirtech.map.model.MapFile");
            BeanMap.add("mapsource", "com.elixirtech.map.model.MapSource");
            BeanMap.add("metadata", "com.elixirtech.map.model.Metadata");
            BeanMap.add("param", "com.elixirtech.map.model.Parameter");
            BeanMap.add("security", "com.elixirtech.map.model.Security");
            BeanMap.add("shapefile", "com.elixirtech.map.model.Shapefile");
            BeanMap.add("title", "com.elixirtech.map.model.Title");
        }
        catch (Exception exception) {
            System.err.println("Unable to initialize BeanMap");
            exception.printStackTrace();
        }
    }
}

