/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;
import java.awt.font.TextAttribute;
import java.util.HashMap;

public class Font
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Font.class);
    protected boolean m_IsLoaded;
    protected String m_Family;
    protected boolean m_Bold;
    protected boolean m_Italic;
    protected String m_Color;
    protected int m_Size;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public Font() {
        this.m_Family = "SansSerif";
        this.m_Color = "Black";
        this.m_Size = 12;
    }

    @Override
    public String getTagName() {
        return "font";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
    }

    @Override
    public void dispose() {
    }

    public void copyAttrs(Element element) {
        if (this.m_Family != null) {
            element.setAttribute("font-family", this.m_Family);
        }
        element.setAttribute("font-bold", this.m_Bold ? "Yes" : "No");
        element.setAttribute("font-italic", this.m_Italic ? "Yes" : "No");
        if (this.m_Color != null) {
            element.setAttribute("font-color", this.m_Color);
        }
        element.setAttribute("font-size", Integer.toString(this.m_Size));
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Font font = (Font)this.getClass().newInstance();
        font.m_Family = this.m_Family;
        font.m_Bold = this.m_Bold;
        font.m_Italic = this.m_Italic;
        font.m_Color = this.m_Color;
        font.m_Size = this.m_Size;
        return font;
    }

    public Font(java.awt.Font font) {
        this.m_Family = font.getName();
        this.m_Bold = font.isBold();
        this.m_Italic = font.isItalic();
        this.m_Size = font.getSize();
        this.m_Color = "Black";
    }

    public java.awt.Font getAWTFont() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, this.m_Family);
        hashMap.put(TextAttribute.SIZE, new Float(this.m_Size));
        hashMap.put(TextAttribute.WEIGHT, this.m_Bold ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        hashMap.put(TextAttribute.POSTURE, this.m_Italic ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        return new java.awt.Font(hashMap);
    }

    public String getFamily() {
        return this.m_Family;
    }

    public void setFamily(String string) {
        this.m_Family = string;
    }

    public boolean isBold() {
        return this.m_Bold;
    }

    public void setBold(boolean bl) {
        this.m_Bold = bl;
    }

    public boolean isItalic() {
        return this.m_Italic;
    }

    public void setItalic(boolean bl) {
        this.m_Italic = bl;
    }

    public String getColor() {
        return this.m_Color;
    }

    public void setColor(String string) {
        this.m_Color = string;
    }

    public int getSize() {
        return this.m_Size;
    }

    public void setSize(int n) {
        this.m_Size = n;
    }

    public Font deepCopy() {
        Font font = new Font();
        this.copyInto(font);
        return font;
    }

    protected void copyInto(Font font) {
        font.m_Family = this.m_Family;
        font.m_Bold = this.m_Bold;
        font.m_Italic = this.m_Italic;
        font.m_Color = this.m_Color;
        font.m_Size = this.m_Size;
    }
}

