/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.map.model.MapSource;
import com.elixirtech.sax.IBean;

public class Layer
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Layer.class);
    protected boolean m_IsLoaded;
    protected MapSource m_MapSource;
    protected String m_Name;
    protected boolean m_Enabled = true;
    protected boolean m_Cache = true;
    protected String m_LineColor = "Black";
    protected String m_FillColor = "Blue";

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "layer";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        if (this.m_MapSource != null) {
            this.m_MapSource.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_MapSource != null) {
            if (this.m_MapSource != null) {
                this.m_MapSource.dispose();
            }
            this.m_MapSource = null;
        }
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        element.setAttribute("enabled", this.m_Enabled ? "Yes" : "No");
        element.setAttribute("cache", this.m_Cache ? "Yes" : "No");
        if (this.m_LineColor != null) {
            element.setAttribute("line-color", this.m_LineColor);
        }
        if (this.m_FillColor != null) {
            element.setAttribute("fill-color", this.m_FillColor);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Layer layer = (Layer)this.getClass().newInstance();
        layer.m_Name = this.m_Name;
        layer.m_Enabled = this.m_Enabled;
        layer.m_Cache = this.m_Cache;
        layer.m_LineColor = this.m_LineColor;
        layer.m_FillColor = this.m_FillColor;
        return layer;
    }

    public MapSource getMapSource() {
        return this.m_MapSource;
    }

    public void setMapSource(MapSource mapSource) {
        this.m_MapSource = mapSource;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_Enabled = bl;
    }

    public boolean isCache() {
        return this.m_Cache;
    }

    public void setCache(boolean bl) {
        this.m_Cache = bl;
    }

    public String getLineColor() {
        return this.m_LineColor;
    }

    public void setLineColor(String string) {
        this.m_LineColor = string;
    }

    public String getFillColor() {
        return this.m_FillColor;
    }

    public void setFillColor(String string) {
        this.m_FillColor = string;
    }

    public Layer deepCopy() {
        Layer layer = new Layer();
        this.copyInto(layer);
        return layer;
    }

    protected void copyInto(Layer layer) {
        layer.m_Name = this.m_Name;
        layer.m_Enabled = this.m_Enabled;
        layer.m_Cache = this.m_Cache;
        layer.m_LineColor = this.m_LineColor;
        layer.m_FillColor = this.m_FillColor;
        if (this.m_MapSource != null) {
            layer.m_MapSource = this.m_MapSource.deepCopy();
        }
    }
}

