/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.jdom.Element;
import com.elixirtech.map.model.Layer;
import com.elixirtech.map.model.Legend;
import com.elixirtech.map.model.MapSource;
import com.elixirtech.map.model.Metadata;
import com.elixirtech.map.model.Parameter;
import com.elixirtech.map.model.Security;
import com.elixirtech.map.model.Title;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MapFile
implements IBean,
ChangeNotifier,
IAdaptable,
IDirtyState,
ICachedFile {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MapFile.class);
    protected boolean m_IsLoaded;
    private long m_LastModified;
    private RMLFileObject m_FileObject;
    private boolean m_IsDirty;
    private List<IDirtyState.Listener> m_DirtyListeners = new ArrayList<IDirtyState.Listener>();
    protected Legend m_Legend;
    protected Title m_Title;
    protected Metadata m_Metadata;
    protected Security m_Security;
    protected MapSource m_MapSource;
    protected List<Layer> m_Layer = new ArrayList<Layer>();
    protected List<Parameter> m_Parameter = new ArrayList<Parameter>();
    protected String m_BackgroundColor = "LightSteelBlue";
    protected String m_ForegroundColor = "White";
    protected String m_LineColor = "Blue";
    protected String m_ColoringAlgorithm = "gradient3(Red|Green|Blue)";
    protected boolean m_StartAtZero;
    protected String m_MapKey;
    protected String m_DSKey;
    protected String m_ToolTip;
    protected String m_DataSource;
    private Set<ChangeListener> m_ChangeListeners;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public MapFile() {
        this.m_Security = new Security();
        this.m_Legend = new Legend();
        this.m_Title = new Title();
    }

    @Override
    public String getTagName() {
        return "mapfile";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        if (this.m_Legend != null) {
            this.m_Legend.loaded();
        }
        if (this.m_Title != null) {
            this.m_Title.loaded();
        }
        if (this.m_Metadata != null) {
            this.m_Metadata.loaded();
        }
        if (this.m_Security != null) {
            this.m_Security.loaded();
        }
        if (this.m_MapSource != null) {
            this.m_MapSource.loaded();
        }
        Iterator<IBean> iterator = this.m_Layer.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
        iterator = this.m_Parameter.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
    }

    @Override
    public void dispose() {
        Iterator<IBean> iterator;
        if (this.m_Legend != null) {
            if (this.m_Legend != null) {
                this.m_Legend.dispose();
            }
            this.m_Legend = null;
        }
        if (this.m_Title != null) {
            if (this.m_Title != null) {
                this.m_Title.dispose();
            }
            this.m_Title = null;
        }
        if (this.m_Metadata != null) {
            if (this.m_Metadata != null) {
                this.m_Metadata.dispose();
            }
            this.m_Metadata = null;
        }
        if (this.m_Security != null) {
            if (this.m_Security != null) {
                this.m_Security.dispose();
            }
            this.m_Security = null;
        }
        if (this.m_MapSource != null) {
            if (this.m_MapSource != null) {
                this.m_MapSource.dispose();
            }
            this.m_MapSource = null;
        }
        if (this.m_Layer != null) {
            iterator = this.m_Layer.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Layer = null;
        if (this.m_Parameter != null) {
            iterator = this.m_Parameter.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_Parameter = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_BackgroundColor != null) {
            element.setAttribute("background-color", this.m_BackgroundColor);
        }
        if (this.m_ForegroundColor != null) {
            element.setAttribute("foreground-color", this.m_ForegroundColor);
        }
        if (this.m_LineColor != null) {
            element.setAttribute("line-color", this.m_LineColor);
        }
        if (this.m_ColoringAlgorithm != null) {
            element.setAttribute("coloring-algorithm", this.m_ColoringAlgorithm);
        }
        element.setAttribute("start-at-zero", this.m_StartAtZero ? "Yes" : "No");
        if (this.m_MapKey != null) {
            element.setAttribute("map-key", this.m_MapKey);
        }
        if (this.m_DSKey != null) {
            element.setAttribute("ds-key", this.m_DSKey);
        }
        if (this.m_ToolTip != null) {
            element.setAttribute("tooltip", this.m_ToolTip);
        }
        if (this.m_DataSource != null) {
            element.setAttribute("datasource", this.m_DataSource);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        MapFile mapFile = (MapFile)this.getClass().newInstance();
        mapFile.m_BackgroundColor = this.m_BackgroundColor;
        mapFile.m_ForegroundColor = this.m_ForegroundColor;
        mapFile.m_LineColor = this.m_LineColor;
        mapFile.m_ColoringAlgorithm = this.m_ColoringAlgorithm;
        mapFile.m_StartAtZero = this.m_StartAtZero;
        mapFile.m_MapKey = this.m_MapKey;
        mapFile.m_DSKey = this.m_DSKey;
        mapFile.m_ToolTip = this.m_ToolTip;
        mapFile.m_DataSource = this.m_DataSource;
        return mapFile;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISecurity.class) {
            return clazz.cast(this.m_Security);
        }
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDirtyState.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public boolean isUpToDate() {
        return this.m_LastModified == this.m_FileObject.lastModified();
    }

    @Override
    public void setFileObject(RMLFileObject rMLFileObject) {
        this.m_FileObject = rMLFileObject;
        this.m_LastModified = this.m_FileObject.lastModified();
    }

    @Override
    public RMLFileObject getFileObject() {
        return this.m_FileObject;
    }

    @Override
    public boolean isDirty() {
        return this.m_IsDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        if (this.m_IsDirty != bl) {
            this.m_IsDirty = bl;
            for (IDirtyState.Listener listener : this.m_DirtyListeners) {
                listener.dirtyStateChanged(this);
            }
        }
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.add(listener);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.remove(listener);
    }

    public Legend getLegend() {
        return this.m_Legend;
    }

    public void setLegend(Legend legend) {
        this.m_Legend = legend;
    }

    public Title getTitle() {
        return this.m_Title;
    }

    public void setTitle(Title title) {
        this.m_Title = title;
    }

    public Metadata getMetadata() {
        return this.m_Metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.m_Metadata = metadata;
    }

    public Security getSecurity() {
        return this.m_Security;
    }

    public void setSecurity(Security security) {
        this.m_Security = security;
    }

    public MapSource getMapSource() {
        return this.m_MapSource;
    }

    public void setMapSource(MapSource mapSource) {
        this.m_MapSource = mapSource;
    }

    public void addLayer(Layer layer) {
        this.m_Layer.add(layer);
    }

    public void addLayer(int n, Layer layer) {
        this.m_Layer.add(n, layer);
    }

    public void addAllLayers(Collection<Layer> collection) {
        this.m_Layer.addAll(collection);
    }

    public int indexOfLayer(Layer layer) {
        return this.m_Layer.indexOf(layer);
    }

    public void removeLayer(Layer layer) {
        this.m_Layer.remove(layer);
    }

    public void removeAllLayers(Collection collection) {
        this.m_Layer.removeAll(collection);
    }

    public void removeAllLayers() {
        this.m_Layer.clear();
    }

    public Layer getLayer(int n) {
        return this.m_Layer.get(n);
    }

    public int getLayerCount() {
        return this.m_Layer.size();
    }

    public Iterator<Layer> getLayerIterator() {
        return this.m_Layer.iterator();
    }

    public List<Layer> getLayerList() {
        return this.m_Layer;
    }

    public void setLayerList(List<Layer> list) {
        this.m_Layer = list;
    }

    public void addParameter(Parameter parameter) {
        this.m_Parameter.add(parameter);
    }

    public void addParameter(int n, Parameter parameter) {
        this.m_Parameter.add(n, parameter);
    }

    public void addAllParameters(Collection<Parameter> collection) {
        this.m_Parameter.addAll(collection);
    }

    public int indexOfParameter(Parameter parameter) {
        return this.m_Parameter.indexOf(parameter);
    }

    public void removeParameter(Parameter parameter) {
        this.m_Parameter.remove(parameter);
    }

    public void removeAllParameters(Collection collection) {
        this.m_Parameter.removeAll(collection);
    }

    public void removeAllParameters() {
        this.m_Parameter.clear();
    }

    public Parameter getParameter(int n) {
        return this.m_Parameter.get(n);
    }

    public int getParameterCount() {
        return this.m_Parameter.size();
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameter.iterator();
    }

    public List<Parameter> getParameterList() {
        return this.m_Parameter;
    }

    public void setParameterList(List<Parameter> list) {
        this.m_Parameter = list;
    }

    public String getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    public void setBackgroundColor(String string) {
        this.m_BackgroundColor = string;
    }

    public String getForegroundColor() {
        return this.m_ForegroundColor;
    }

    public void setForegroundColor(String string) {
        this.m_ForegroundColor = string;
    }

    public String getLineColor() {
        return this.m_LineColor;
    }

    public void setLineColor(String string) {
        this.m_LineColor = string;
    }

    public String getColoringAlgorithm() {
        return this.m_ColoringAlgorithm;
    }

    public void setColoringAlgorithm(String string) {
        this.m_ColoringAlgorithm = string;
    }

    public boolean isStartAtZero() {
        return this.m_StartAtZero;
    }

    public void setStartAtZero(boolean bl) {
        this.m_StartAtZero = bl;
    }

    public String getMapKey() {
        return this.m_MapKey;
    }

    public void setMapKey(String string) {
        this.m_MapKey = string;
    }

    public String getDSKey() {
        return this.m_DSKey;
    }

    public void setDSKey(String string) {
        this.m_DSKey = string;
    }

    public String getToolTip() {
        return this.m_ToolTip;
    }

    public void setToolTip(String string) {
        this.m_ToolTip = string;
    }

    public String getDataSource() {
        return this.m_DataSource;
    }

    public void setDataSource(String string) {
        this.m_DataSource = string;
        this.notifyChanged("MapFile.DataSource");
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet<ChangeListener>();
        }
        this.m_ChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
        if (this.m_ChangeListeners.size() == 0) {
            this.m_ChangeListeners = null;
        }
    }

    public void notifyChanged(String string) {
        if (this.m_ChangeListeners != null) {
            for (ChangeListener changeListener : this.m_ChangeListeners) {
                changeListener.beanChanged(this, string);
            }
        }
    }

    public MapFile deepCopy() {
        MapFile mapFile = new MapFile();
        this.copyInto(mapFile);
        return mapFile;
    }

    protected void copyInto(MapFile mapFile) {
        mapFile.m_BackgroundColor = this.m_BackgroundColor;
        mapFile.m_ForegroundColor = this.m_ForegroundColor;
        mapFile.m_LineColor = this.m_LineColor;
        mapFile.m_ColoringAlgorithm = this.m_ColoringAlgorithm;
        mapFile.m_StartAtZero = this.m_StartAtZero;
        mapFile.m_MapKey = this.m_MapKey;
        mapFile.m_DSKey = this.m_DSKey;
        mapFile.m_ToolTip = this.m_ToolTip;
        mapFile.m_DataSource = this.m_DataSource;
        if (this.m_Legend != null) {
            mapFile.m_Legend = this.m_Legend.deepCopy();
        }
        if (this.m_Title != null) {
            mapFile.m_Title = this.m_Title.deepCopy();
        }
        if (this.m_Metadata != null) {
            mapFile.m_Metadata = this.m_Metadata.deepCopy();
        }
        if (this.m_Security != null) {
            mapFile.m_Security = this.m_Security.deepCopy();
        }
        if (this.m_MapSource != null) {
            mapFile.m_MapSource = this.m_MapSource.deepCopy();
        }
        mapFile.m_Layer = new ArrayList<Layer>();
        for (Layer iBean : this.m_Layer) {
            mapFile.addLayer(iBean.deepCopy());
        }
        mapFile.m_Parameter = new ArrayList<Parameter>();
        for (Parameter parameter : this.m_Parameter) {
            mapFile.addParameter(parameter.deepCopy());
        }
    }
}

