/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.util;

import com.elixirtech.map.util.NoneFormat;
import com.elixirtech.util.format.FormatUtil;
import com.elixirtech.util.format.IFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Range {
    private final double m_Minimum;
    private final double m_Maximum;
    private final boolean m_StartAtZero;
    private int m_Magnitude;
    private double m_StartValue;
    private double m_StopValue;
    private double m_Range;

    public Range(double d, double d2, boolean bl) {
        this.m_Minimum = d;
        this.m_Maximum = d2;
        this.m_StartAtZero = bl;
        this.calculateRange();
    }

    public double getStartValue() {
        return this.m_StartValue;
    }

    public double getStopValue() {
        return this.m_StopValue;
    }

    public double getPercent(double d) {
        return (d - this.m_StartValue) / this.m_Range;
    }

    public List<Position> calculateContinuousPositions(IFormat iFormat) {
        double d;
        Format format = FormatUtil.isNone(iFormat) ? new NoneFormat() : FormatUtil.buildFormatter(iFormat, Locale.getDefault());
        double d2 = 1.0;
        if (this.m_Magnitude > 0) {
            for (var5_4 = 0; var5_4 < this.m_Magnitude; ++var5_4) {
                d2 *= 10.0;
            }
        } else {
            for (var5_4 = 0; var5_4 > this.m_Magnitude; --var5_4) {
                d2 /= 10.0;
            }
        }
        if ((d = (this.m_StopValue - this.m_StartValue) / d2) < 4.0) {
            d2 /= 2.0;
            --this.m_Magnitude;
        }
        ArrayList<Position> arrayList = new ArrayList<Position>();
        arrayList.add(Range.newPosition(format, this.m_StartValue, 0.0));
        double d3 = this.m_StartValue;
        while (d3 < this.m_StopValue - d2) {
            double d4 = this.roundDown(d3 += d2, this.m_Magnitude);
            double d5 = (d4 - this.m_StartValue) / (this.m_StopValue - this.m_StartValue);
            arrayList.add(Range.newPosition(format, d4, d5));
        }
        arrayList.add(Range.newPosition(format, this.m_StopValue, 1.0));
        return arrayList;
    }

    private static Position newPosition(Format format, double d, double d2) {
        String string;
        try {
            string = format.format(d);
        }
        catch (Throwable throwable) {
            string = "Error";
        }
        return new Position(string, d2);
    }

    private void calculateRange() {
        this.m_Magnitude = Math.max(this.calcMagnitude(this.m_Minimum), this.calcMagnitude(this.m_Maximum));
        this.m_StartValue = this.m_Minimum > 0.0 && this.m_StartAtZero ? 0.0 : this.roundDown(this.m_Minimum, this.m_Magnitude);
        this.m_StopValue = this.roundUp(this.m_Maximum, this.m_Magnitude);
        this.m_Range = this.m_StopValue - this.m_StartValue;
    }

    private int calcMagnitude(double d) {
        if (d == 0.0) {
            return 0;
        }
        int n = 0;
        double d2 = Math.abs(d);
        if (d2 < 1.0) {
            while (d2 < 1.0) {
                d2 *= 10.0;
                --n;
            }
        } else {
            while (d2 > 10.0) {
                d2 /= 10.0;
                ++n;
            }
        }
        return n;
    }

    private double roundDown(double d, int n) {
        int n2;
        double d2 = d;
        if (n < 0) {
            int n3;
            for (n3 = 0; n3 > n; --n3) {
                d2 *= 10.0;
            }
            d2 = Math.round(d2);
            for (n3 = 0; n3 > n; --n3) {
                d2 /= 10.0;
            }
            return d2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d2 /= 10.0;
        }
        d2 = Math.round(d2);
        for (n2 = 0; n2 < n; ++n2) {
            d2 *= 10.0;
        }
        return d2;
    }

    private double roundUp(double d, int n) {
        int n2;
        double d2 = d;
        if (n < 0) {
            int n3;
            for (n3 = 0; n3 > n; --n3) {
                d2 *= 10.0;
            }
            d2 = Math.ceil(d2);
            for (n3 = 0; n3 > n; --n3) {
                d2 /= 10.0;
            }
            return d2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d2 /= 10.0;
        }
        d2 = Math.ceil(d2);
        for (n2 = 0; n2 < n; ++n2) {
            d2 *= 10.0;
        }
        return d2;
    }

    public static class Position {
        public String label;
        public double location;

        public Position() {
        }

        public Position(String string, double d) {
            this.label = string;
            this.location = d;
        }

        public String toString() {
            return this.location + " = " + this.label;
        }
    }
}

