/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.odf;

import com.elixirtech.arch.ByteUtil$;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.odf.Document;
import com.elixirtech.odf.Part;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import scala.Function1;
import scala.collection.Seq;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.Text;
import scala.xml.TopScope$;

public class Picture
extends Part {
    private final Rectangle rc;
    private final byte[] data;
    private final String sha;

    public Picture(Document document, Rectangle rc, String mimeType, byte[] data) {
        this.rc = rc;
        this.data = data;
        MessageDigest sha1md = MessageDigest.getInstance("SHA1");
        sha1md.update(data);
        this.sha = ByteUtil$.MODULE$.toHex(sha1md.digest());
        if (document.parts().find((Function1 & Serializable)_$1 -> {
            String string = _$1.name();
            String string2 = this.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).isEmpty()) {
            document.parts().$plus$eq((Object)this);
            document.manifest().add(mimeType, this.name());
        }
    }

    public String sha() {
        return this.sha;
    }

    @Override
    public Path path() {
        return Path$.MODULE$.apply("/Picture/" + this.sha());
    }

    @Override
    public void write(OutputStream os) {
        os.write(this.data);
    }

    public Node xml() {
        Null$ $md = Null$.MODULE$;
        $md = new PrefixedAttribute("svg", "height", this.pt(this.rc.height - 20), (MetaData)$md);
        $md = new PrefixedAttribute("svg", "width", this.pt(this.rc.width - 20), (MetaData)$md);
        $md = new PrefixedAttribute("svg", "y", this.pt(this.rc.y), (MetaData)$md);
        $md = new PrefixedAttribute("svg", "x", this.pt(this.rc.x), (MetaData)$md);
        $md = new PrefixedAttribute("draw", "name", this.sha(), (MetaData)$md);
        $md = new PrefixedAttribute("draw", "z-index", (Seq)new Text("0"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n       "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new PrefixedAttribute("xlink", "actuate", (Seq)new Text("onLoad"), (MetaData)$md2);
        $md2 = new PrefixedAttribute("xlink", "show", (Seq)new Text("embed"), (MetaData)$md2);
        $md2 = new PrefixedAttribute("xlink", "type", (Seq)new Text("simple"), (MetaData)$md2);
        $md2 = new PrefixedAttribute("xlink", "href", this.name(), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem("draw", "image", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n     "));
        return new Elem("draw", "frame", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public String pt(int i) {
        return (double)i / 20.0 + "pt";
    }
}

