/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc;

import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.RelationshipsPart;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter {
    public static void write(Package package_, File file) throws IOException {
        file.getParentFile().mkdirs();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ZipWriter.write(package_, bufferedOutputStream);
    }

    public static void write(Package package_, OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        ZipWriter.write(zipOutputStream, package_.getRelationships());
        for (Part part : package_.getParts()) {
            ZipWriter.write(zipOutputStream, part);
            RelationshipsPart relationshipsPart = part.getRelationships();
            if (relationshipsPart == null) continue;
            ZipWriter.write(zipOutputStream, relationshipsPart);
        }
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private static void write(ZipOutputStream zipOutputStream, Part part) throws IOException {
        ZipEntry zipEntry = new ZipEntry(part.getName().substring(1));
        zipOutputStream.putNextEntry(zipEntry);
        part.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }
}

