/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.ppt;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.ResourcePart;
import com.elixirtech.opc.ppt.ExtendedXMLPart;
import com.elixirtech.opc.ppt.IDGenerator;
import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.opc.util.XMLUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Presentation
extends ExtendedXMLPart {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml";
    private static final String PRESENTATION = "com/elixirtech/opc/ppt/parts/presentation.xml";
    private static final String PRESENTATION_RELS = "com/elixirtech/opc/ppt/parts/presentation.xml.rels";
    private final List<Part> m_SubParts = new ArrayList<Part>();
    private final IDGenerator m_IDGenerator = new IDGenerator();
    private Element m_Slides;
    private Element m_SlideSize;

    public Presentation(String string, Dimension dimension) throws IOException {
        super(string, CONTENT_TYPE);
        this.setDocument(XMLUtil.loadResource(PRESENTATION));
        this.buildExtensionPoints();
        this.setSlideSize(dimension);
        this.buildResources();
        this.buildRelationships();
    }

    public IDGenerator getIDGenerator() {
        return this.m_IDGenerator;
    }

    public List<Part> getSubParts() {
        return Collections.unmodifiableList(this.m_SubParts);
    }

    public void addSlide(Slide slide) {
        int n = this.m_Slides.getContentSize() + 256;
        Element element = Build.p("sldId", "id", String.valueOf(n));
        String string = slide.getName();
        if (string.startsWith("/ppt/")) {
            string = string.substring(5);
        }
        Relationship relationship = new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", string);
        element.setAttribute("id", this.addRelationship(relationship), Build.NS_R2);
        this.m_Slides.addContent(element);
        this.m_SubParts.add(slide);
        this.m_SubParts.addAll(slide.getSubParts());
    }

    protected void setSlideSize(Dimension dimension) {
        this.m_SlideSize.setAttribute("cx", String.valueOf(dimension.width));
        this.m_SlideSize.setAttribute("cy", String.valueOf(dimension.height));
    }

    protected void buildExtensionPoints() throws IOException {
        Element element = this.m_Document.getRootElement();
        this.m_Slides = Presentation.getElement(element, "/p:presentation/p:sldIdLst");
        this.m_SlideSize = Presentation.getElement(element, "/p:presentation/p:sldSz");
    }

    protected void buildResources() {
        this.m_SubParts.add(new ResourcePart("/ppt/slideMasters/slideMaster1.xml", "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", "com/elixirtech/opc/ppt/parts/slideMasters/slideMaster1.xml"));
        this.m_SubParts.add(new ResourcePart("/ppt/slideMasters/_rels/slideMaster1.xml.rels", "text/xml", "com/elixirtech/opc/ppt/parts/slideMasters/slideMaster1.xml.rels"));
        for (int i = 1; i <= 11; ++i) {
            String string = "slideLayout" + String.valueOf(i) + ".xml";
            this.m_SubParts.add(new ResourcePart("/ppt/slideLayouts/" + string, "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", "com/elixirtech/opc/ppt/parts/slideLayouts/" + string));
            this.m_SubParts.add(new ResourcePart("/ppt/slideLayouts/_rels/" + string + ".rels", "text/xml", "com/elixirtech/opc/ppt/parts/slideLayouts/" + string + ".rels"));
        }
        this.m_SubParts.add(new ResourcePart("/ppt/theme/theme1.xml", "application/vnd.openxmlformats-officedocument.theme+xml", "com/elixirtech/opc/ppt/parts/theme/theme1.xml"));
        this.m_SubParts.add(new ResourcePart("/docProps/app.xml", "application/vnd.openxmlformats-officedocument.extended-properties+xml", "com/elixirtech/opc/ppt/parts/docProps/app.xml"));
        this.m_SubParts.add(new ResourcePart("/docProps/core.xml", "application/vnd.openxmlformats-package.core-properties+xml", "com/elixirtech/opc/ppt/parts/docProps/core.xml"));
        this.m_SubParts.add(new ResourcePart("/docProps/thumbnail.wmf", "image/x-wmf", "com/elixirtech/opc/ppt/parts/docProps/thumbnail.wmf"));
        this.m_SubParts.add(new ResourcePart("/ppt/presProps.xml", "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml", "com/elixirtech/opc/ppt/parts/presProps.xml"));
        this.m_SubParts.add(new ResourcePart("/ppt/tableStyles.xml", "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", "com/elixirtech/opc/ppt/parts/tableStyles.xml"));
        this.m_SubParts.add(new ResourcePart("/ppt/viewProps.xml", "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml", "com/elixirtech/opc/ppt/parts/viewProps.xml"));
    }

    private void buildRelationships() throws IOException {
        this.initRelationships();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(PRESENTATION_RELS);
        this.m_Relationships.loadRelationships(inputStream);
    }
}

