/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.ppt;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.BinaryPart;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.ppt.ExtendedXMLPart;
import com.elixirtech.opc.ppt.IDGenerator;
import com.elixirtech.opc.ppt.TextInfo;
import com.elixirtech.opc.util.ColorUtil;
import com.elixirtech.opc.util.Snippet;
import com.elixirtech.opc.util.XMLUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;

public class Slide
extends ExtendedXMLPart {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
    private static final String SLIDE = "com/elixirtech/opc/ppt/parts/slides/slide.xml";
    private static final String PIC = "com/elixirtech/opc/ppt/snippets/pic.xml";
    private static final String RECT = "com/elixirtech/opc/ppt/snippets/rect.xml";
    private static final String TEXT = "com/elixirtech/opc/ppt/snippets/text.xml";
    private Element m_ShapeTree;
    private final List<Part> m_SubParts = new ArrayList<Part>();
    private final IDGenerator m_IDGenerator;
    private static Snippet SNIPPET_RECT;
    private static Snippet SNIPPET_TEXT;
    private static Snippet SNIPPET_PIC;

    public Slide(IDGenerator iDGenerator, String string) throws IOException {
        super(string, CONTENT_TYPE);
        this.m_IDGenerator = iDGenerator;
        this.setDocument(XMLUtil.loadResource(SLIDE));
        this.buildExtensionPoints();
        this.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout", "../slideLayouts/slideLayout7.xml"));
    }

    public List<Part> getSubParts() {
        return Collections.unmodifiableList(this.m_SubParts);
    }

    public void addRectangle(Rectangle rectangle, Color color, int n, Color color2, int n2) throws IOException {
        Element element;
        boolean bl = color2 != null && n2 > 0 && n != 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", this.m_IDGenerator.getUniqueId());
        hashMap.put("no", this.m_IDGenerator.getShapeNo());
        hashMap.put("x", String.valueOf((long)rectangle.x * 635L));
        hashMap.put("y", String.valueOf((long)rectangle.y * 635L));
        hashMap.put("width", String.valueOf((long)rectangle.width * 635L));
        hashMap.put("height", String.valueOf((long)rectangle.height * 635L));
        Element element2 = SNIPPET_RECT.getElement(hashMap);
        Element element3 = element2.getChild("spPr", Build.NS_P);
        if (color != null) {
            element = this.solidFill(color);
            element3.addContent(element);
        } else {
            element = Build.a("noFill");
            element3.addContent(element);
        }
        if (bl) {
            element = Build.a("ln", "w", String.valueOf((long)n2 * 635L));
            Element element4 = this.solidFill(color2);
            Element element5 = Build.a("miter", "lim", "800000");
            Element element6 = null;
            switch (n) {
                case 2: {
                    element6 = Build.a("prstDash", "val", "dash");
                    break;
                }
                case 3: {
                    element6 = Build.a("prstDash", "val", "sysDot");
                    break;
                }
                case 9: {
                    element6 = Build.a("prstDash", "val", "lgDashDot");
                    break;
                }
                case 10: {
                    element6 = Build.a("prstDash", "val", "lgDashDotDot");
                    break;
                }
            }
            Element element7 = Build.a("headEnd");
            Element element8 = Build.a("tailEnd");
            element.addContent(element4);
            if (element6 != null) {
                element.addContent(element6);
            }
            element.addContent(element5);
            element.addContent(element7);
            element.addContent(element8);
            element3.addContent(element);
        } else {
            element = Build.a("ln", "w", "9525");
            Element element9 = Build.a("noFill");
            Element element10 = Build.a("miter", "lim", "800000");
            Element element11 = Build.a("headEnd");
            Element element12 = Build.a("tailEnd");
            element.addContent(element9);
            element.addContent(element10);
            element.addContent(element11);
            element.addContent(element12);
            element3.addContent(element);
        }
        this.m_ShapeTree.addContent(element2);
    }

    public void addText(Rectangle rectangle, TextInfo textInfo, String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", this.m_IDGenerator.getUniqueId());
        hashMap.put("no", this.m_IDGenerator.getShapeNo());
        hashMap.put("x", String.valueOf((long)rectangle.x * 635L));
        hashMap.put("y", String.valueOf((long)rectangle.y * 635L));
        hashMap.put("width", String.valueOf((long)rectangle.width * 635L));
        hashMap.put("height", String.valueOf((long)rectangle.height * 635L));
        hashMap.put("rotation", String.valueOf((long)textInfo.rotation * 60000L));
        Element element = SNIPPET_TEXT.getElement(hashMap);
        Element element2 = element.getChild("txBody", Build.NS_P);
        element2.addContent(this.para(textInfo, string));
        this.m_ShapeTree.addContent(element);
    }

    public String addImage(Rectangle rectangle, BufferedImage bufferedImage) throws IOException {
        String string = "image" + this.m_IDGenerator.getShapeNo() + ".png";
        String string2 = "/ppt/media/" + string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        this.m_SubParts.add(new BinaryPart(string2, "PNG", byteArrayOutputStream.toByteArray()));
        String string3 = "../media/" + string;
        String string4 = this.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", string3));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", this.m_IDGenerator.getUniqueId());
        hashMap.put("no", this.m_IDGenerator.getShapeNo());
        hashMap.put("relId", string4);
        hashMap.put("x", String.valueOf((long)rectangle.x * 635L));
        hashMap.put("y", String.valueOf((long)rectangle.y * 635L));
        hashMap.put("width", String.valueOf((long)rectangle.width * 635L));
        hashMap.put("height", String.valueOf((long)rectangle.height * 635L));
        Element element = SNIPPET_PIC.getElement(hashMap);
        this.m_ShapeTree.addContent(element);
        return string3;
    }

    public String addImage(Rectangle rectangle, String string) throws IOException {
        String string2 = this.addRelationship(new Relationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", string));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", this.m_IDGenerator.getUniqueId());
        hashMap.put("no", this.m_IDGenerator.getShapeNo());
        hashMap.put("relId", string2);
        hashMap.put("x", String.valueOf((long)rectangle.x * 635L));
        hashMap.put("y", String.valueOf((long)rectangle.y * 635L));
        hashMap.put("width", String.valueOf((long)rectangle.width * 635L));
        hashMap.put("height", String.valueOf((long)rectangle.height * 635L));
        Element element = SNIPPET_PIC.getElement(hashMap);
        this.m_ShapeTree.addContent(element);
        return string;
    }

    public Element para(TextInfo textInfo, String string) {
        Element element = Build.a("p");
        Element element2 = Build.a("pPr");
        Element element3 = Build.a("r");
        Element element4 = Build.a("rPr");
        Element element5 = this.solidFill(textInfo.fontColor);
        Element element6 = Build.a("latin");
        Element element7 = Build.a("t");
        element2.setAttribute("algn", textInfo.alignment);
        element4.setAttribute("lang", "en-US");
        element4.setAttribute("sz", String.valueOf(textInfo.fontSize * 5));
        if (textInfo.bold) {
            element4.setAttribute("b", "1");
        }
        if (textInfo.italic) {
            element4.setAttribute("i", "1");
        }
        if (textInfo.underline) {
            element4.setAttribute("u", "sng");
        }
        element6.setAttribute("typeface", textInfo.fontName);
        element6.setAttribute("pitchFamily", "18");
        element6.setAttribute("charset", "0");
        element7.setText(string);
        element.addContent(element2);
        element.addContent(element3);
        element3.addContent(element4);
        element4.addContent(element5);
        element4.addContent(element6);
        element3.addContent(element7);
        return element;
    }

    protected Element solidFill(Color color) {
        Element element = Build.a("solidFill");
        Element element2 = Build.a("srgbClr", "val", ColorUtil.srgbClr(color));
        if (color.getAlpha() < 255) {
            Element element3 = Build.a("alpha", "val", ColorUtil.alpha(color));
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }

    protected void buildExtensionPoints() throws IOException {
        Element element = this.m_Document.getRootElement();
        this.m_ShapeTree = Slide.getElement(element, "/p:sld/p:cSld/p:spTree");
    }

    static {
        try {
            SNIPPET_RECT = new Snippet(RECT);
            SNIPPET_TEXT = new Snippet(TEXT);
            SNIPPET_PIC = new Snippet(PIC);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

