/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.xls.Cell;
import com.elixirtech.opc.xls.Location;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class Row
implements Comparable<Row> {
    private final int m_Index;
    private final Element m_Element;
    private List<Cell> m_Cells = new ArrayList<Cell>();
    private final BitSet m_BitSet = new BitSet();

    public Row(int n) {
        this.m_Index = n;
        this.m_Element = new Element("row", Build.NS_S);
        this.m_Element.setAttribute("r", String.valueOf(this.m_Index + 1));
    }

    public void setHeight(int n) {
        this.m_Element.setAttribute("ht", String.valueOf(n));
        this.m_Element.setAttribute("customHeight", "1");
    }

    @Override
    public int compareTo(Row row) {
        if (this.m_Index < row.m_Index) {
            return -1;
        }
        if (this.m_Index > row.m_Index) {
            return 1;
        }
        return 0;
    }

    public int getIndex() {
        return this.m_Index;
    }

    public void addCell(Cell cell) {
        assert (cell.getY() == this.m_Index);
        int n = cell.getX();
        if (this.m_BitSet.get(n)) {
            throw new IllegalStateException("Row " + this.m_Index + " already has a cell at column " + n);
        }
        this.m_BitSet.set(n);
        this.m_Cells.add(cell);
        Collections.sort(this.m_Cells);
        int n2 = Collections.binarySearch(this.m_Cells, cell);
        this.m_Element.addContent(n2, cell.getElement());
        this.m_Element.setAttribute("spans", this.getSpans());
    }

    public String getSpans() {
        return this.getFirstLocation().x + 1 + ":" + (this.getLastLocation().x + 1);
    }

    public boolean isEmpty() {
        return this.m_Cells.isEmpty();
    }

    public Location getFirstLocation() {
        if (this.m_Cells.isEmpty()) {
            return null;
        }
        return this.m_Cells.get(0).getLocation();
    }

    public Location getLastLocation() {
        if (this.m_Cells.isEmpty()) {
            return null;
        }
        return this.m_Cells.get(this.m_Cells.size() - 1).getLocation();
    }

    public Element getElement() {
        return this.m_Element;
    }
}

