/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.util.XMLUtil;
import com.elixirtech.opc.xls.ExtendedXMLPart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharedStrings
extends ExtendedXMLPart {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
    private static final String FILE = "com/elixirtech/opc/xls/parts/sharedStrings.xml";
    private List<String> m_Strings = new ArrayList<String>();
    private Map<String, Integer> m_LookupMap = new HashMap<String, Integer>();
    private Element m_Shared;

    public SharedStrings() throws IOException {
        super("/xl/sharedStrings.xml", CONTENT_TYPE);
        this.setDocument(XMLUtil.loadResource(FILE));
        this.buildExtensionPoints();
    }

    public int addString(String string) {
        Integer n = this.m_LookupMap.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.m_Strings.size();
        Element element = new Element("si", Build.NS_S);
        Element element2 = new Element("t", Build.NS_S);
        element2.setText(string);
        element.addContent(element2);
        this.m_Shared.addContent(element);
        String string2 = String.valueOf(n2 + 1);
        this.m_Shared.setAttribute("count", string2);
        this.m_Shared.setAttribute("uniqueCount", string2);
        this.m_Strings.add(string);
        this.m_LookupMap.put(string, n2);
        return n2;
    }

    protected void buildExtensionPoints() throws IOException {
        Element element = this.m_Document.getRootElement();
        this.m_Shared = SharedStrings.getElement(element, "/s:sst");
    }
}

