/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.util.XMLUtil;
import com.elixirtech.opc.xls.ExtendedXMLPart;
import com.elixirtech.opc.xls.style.Fill;
import com.elixirtech.opc.xls.style.FillManager;
import com.elixirtech.opc.xls.style.Font;
import com.elixirtech.opc.xls.style.FontManager;
import com.elixirtech.opc.xls.style.Format;
import com.elixirtech.opc.xls.style.FormatManager;
import com.elixirtech.opc.xls.style.XF;
import com.elixirtech.opc.xls.style.XFManager;
import java.io.IOException;

public class Styles
extends ExtendedXMLPart {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
    private static final String STYLES = "com/elixirtech/opc/xls/parts/styles.xml";
    private FormatManager m_FormatManager;
    private FillManager m_FillManager;
    private FontManager m_FontManager;
    private XFManager m_XFManager;

    public Styles() throws IOException {
        super("/xl/styles.xml", CONTENT_TYPE);
        this.setDocument(XMLUtil.loadResource(STYLES));
        this.buildExtensionPoints();
    }

    public int getFillIndex(Fill fill) {
        return this.m_FillManager.getFillIndex(fill);
    }

    public int getFontIndex(Font font) {
        return this.m_FontManager.getFontIndex(font);
    }

    public int getXFIndex(XF xF) {
        return this.m_XFManager.getXFIndex(xF);
    }

    public int getFormatIndex(Format format) {
        return this.m_FormatManager.getFormatIndex(format);
    }

    protected void buildExtensionPoints() throws IOException {
        Element element = this.m_Document.getRootElement();
        this.m_FormatManager = new FormatManager(Styles.getElement(element, "/s:styleSheet/s:numFmts"));
        this.m_FillManager = new FillManager(Styles.getElement(element, "/s:styleSheet/s:fills"));
        this.m_FontManager = new FontManager(Styles.getElement(element, "/s:styleSheet/s:fonts"));
        this.m_XFManager = new XFManager(this, Styles.getElement(element, "/s:styleSheet/s:cellXfs"));
    }
}

