/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.pdf;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.pdf.ElxPdfGraphics2D;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Glint2PDF {
    public static void main(String[] stringArray) throws Exception {
        File file;
        stringArray = new String[]{"C:\\Temp\\cl.glint", "C:\\Temp\\cl.pdf"};
        if (stringArray.length != 2) {
            System.out.println("Usage: Glint2PDF file.glint file.pdf");
            System.exit(-1);
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println("Glint file " + stringArray[0] + " not found");
            System.exit(-1);
        }
        Glint2PDF.convert(file, new File(stringArray[1]));
    }

    private Glint2PDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            Glint2PDF.convert(fileInputStream, fileOutputStream);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        EyeReader eyeReader = new EyeReader(inputStream);
        int n = eyeReader.getPageCount();
        IEye.PageSetup pageSetup = eyeReader.getPageSetup(1);
        Rectangle rectangle = new Rectangle((int)((float)pageSetup.width / 20.0f), (int)((float)pageSetup.height / 20.0f));
        Document document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
            document.addCreator("Elixir Report");
            document.open();
            for (int i = 1; i <= n; ++i) {
                pageSetup = eyeReader.getPageSetup(i);
                float f = (float)pageSetup.width / 20.0f;
                float f2 = (float)pageSetup.height / 20.0f;
                if (i > 0) {
                    document.newPage();
                }
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                pdfContentByte.saveState();
                pdfContentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                ElxPdfGraphics2D elxPdfGraphics2D = new ElxPdfGraphics2D(pdfContentByte, f, f2, new DefaultFontMapper(), false);
                GlintGraphics2D glintGraphics2D = new GlintGraphics2D(elxPdfGraphics2D);
                eyeReader.getResources(glintGraphics2D);
                eyeReader.getPage(i, glintGraphics2D);
            }
            pdfWriter.flush();
            document.close();
        }
        catch (DocumentException documentException) {
            throw new IOException("Document error: " + String.valueOf(documentException));
        }
    }
}

