/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.glint.EyeReader;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.util.CharUtil;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class ControlSourceProcessor {
    public static final DataType SCRIPT_DATA_TYPE = DataType.DOUBLE;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ControlSourceProcessor.class);

    public static Object getData(ControlSource controlSource) {
        String string = controlSource.getType();
        if ("Field".equals(string)) {
            return ControlSourceProcessor.getFieldData(controlSource);
        }
        if ("Operation".equals(string)) {
            return ControlSourceProcessor.getOperationData(controlSource);
        }
        if ("Script".equals(string)) {
            return ControlSourceProcessor.getScriptData(controlSource);
        }
        if ("URL".equals(string)) {
            return ControlSourceProcessor.getURLData(controlSource);
        }
        if ("Literal".equals(string)) {
            return ControlSourceProcessor.getLiteralData(controlSource);
        }
        return null;
    }

    protected static Object getFieldData(ControlSource controlSource) {
        RenderStack renderStack = RenderStack.current();
        LogicalRenderContext logicalRenderContext = renderStack.getContext();
        Data data = logicalRenderContext.getData();
        String string = controlSource.getDataSource();
        if (string == null) {
            return data.getObject(controlSource.getField());
        }
        IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
        try {
            Object object = iDataCacheManager.getCacheName(string);
            IDataCache iDataCache = null;
            if (iDataCacheManager.hasCache(object)) {
                iDataCache = iDataCacheManager.getCache(object);
            } else {
                DataHolder dataHolder = new DataHolder((String)object);
                iDataCache = iDataCacheManager.loadCache(string, dataHolder.getProperties());
            }
            return iDataCache.getObject(controlSource.getField());
        }
        catch (DataException dataException) {
            m_Log.error((Object)("Can't access cache named " + string));
            return null;
        }
    }

    protected static Object getOperationData(ControlSource controlSource) {
        RenderStack renderStack = RenderStack.current();
        LogicalRenderContext logicalRenderContext = renderStack.getContext();
        Data data = logicalRenderContext.getData();
        String string = controlSource.getDataSource();
        if (string == null) {
            DataType dataType;
            IFunctionFactory iFunctionFactory;
            Function function;
            DataTable dataTable = data.getDataTable();
            int n = dataTable.getColumnIndex(controlSource.getField());
            if (n < 0) {
                m_Log.warn((Object)("getObject: No object found: " + controlSource.getField()));
                return null;
            }
            String string2 = controlSource.getRange();
            GroupNode groupNode = null;
            groupNode = "Group".equals(string2) ? data.getGroup() : dataTable.getGroups();
            if (controlSource.isRunningValue()) {
                groupNode = ControlSourceProcessor.copyGroup(groupNode);
                groupNode.setStop(data.getRecordIndex());
            }
            if ((function = (iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class)).getFunction(dataType = dataTable.getSchema().getColumnType(n), controlSource.getOperation())) instanceof RangedFunction) {
                RangedFunction rangedFunction = (RangedFunction)function;
                dataTable.setRange(rangedFunction, groupNode, n);
                int n2 = data.getRecordIndex();
                GroupNode groupNode2 = new GroupNode(n2, n2);
                return dataTable.apply(function, groupNode2, n);
            }
            return dataTable.apply(function, groupNode, n);
        }
        IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
        try {
            DataType dataType;
            IFunctionFactory iFunctionFactory;
            Function function;
            Object object;
            Object object2 = iDataCacheManager.getCacheName(string);
            IDataCache iDataCache = null;
            if (iDataCacheManager.hasCache(object2)) {
                iDataCache = iDataCacheManager.getCache(object2);
            } else {
                object = new DataHolder((String)object2);
                iDataCache = iDataCacheManager.loadCache(string, ((DataHolder)object).getProperties());
            }
            object = iDataCache.getDataTable();
            int n = ((DataTable)object).getColumnIndex(controlSource.getField());
            String string3 = controlSource.getRange();
            GroupNode groupNode = null;
            groupNode = "Group".equals(string3) ? iDataCache.getGroup() : ((DataTable)object).getGroups();
            if (controlSource.isRunningValue()) {
                groupNode = ControlSourceProcessor.copyGroup(groupNode);
                groupNode.setStop(iDataCache.getRecordIndex());
            }
            if ((function = (iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class)).getFunction(dataType = ((DataTable)object).getSchema().getColumnType(n), controlSource.getOperation())) instanceof RangedFunction) {
                RangedFunction rangedFunction = (RangedFunction)function;
                ((DataTable)object).setRange(rangedFunction, groupNode, n);
                int n3 = data.getRecordIndex();
                GroupNode groupNode3 = new GroupNode(n3, n3);
                return ((DataTable)object).apply(function, groupNode3, n);
            }
            return ((DataTable)object).apply(function, groupNode, n);
        }
        catch (DataException dataException) {
            m_Log.error((Object)("Can't access cache named " + string));
            return null;
        }
    }

    private static GroupNode copyGroup(GroupNode groupNode) {
        GroupNode groupNode2 = new GroupNode(groupNode.getStart(), groupNode.getStop());
        return groupNode2;
    }

    protected static Object getScriptData(ControlSource controlSource) {
        RenderStack renderStack = RenderStack.current();
        ScriptEngine scriptEngine = renderStack.getScriptEngine();
        String string = controlSource.getText();
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        return scriptEngine.evaluate("javascript", "ControlSource", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Object getURLData(ControlSource controlSource) {
        BufferedReader bufferedReader;
        StringBuilder stringBuilder;
        String string;
        String string2 = ArgumentMap.substitute(controlSource.getURL(), new ReportSubstitution());
        InputStream inputStream = null;
        try {
            inputStream = URLLoader.getInputStream(string2);
            if (!"Text".equals(controlSource.getURLType())) {
                if ("Image".equals(controlSource.getURLType())) {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    return bufferedImage;
                }
                if (!"Glint".equals(controlSource.getURLType())) return null;
                EyeReader eyeReader = new EyeReader(inputStream);
                return eyeReader;
            }
            string = System.getProperty("line.separator");
            stringBuilder = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't process ControlSource URL: " + controlSource.getURL() + " type=" + controlSource.getURLType()));
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string3;
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string3);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected static Object getLiteralData(ControlSource controlSource) {
        String string = controlSource.getText();
        if (string.trim().startsWith("{\\rtf1")) {
            return string;
        }
        return ArgumentMap.substitute(CharUtil.decodeSlashU(string), new ReportSubstitution());
    }
}

