/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data.util;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;

public final class MathEx {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MathEx.class);

    public static Object average(Data data, String string) {
        DataTable dataTable = data.getDataTable();
        if (dataTable != null) {
            GroupNode groupNode = data.getGroup();
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(string);
            if (n >= 0) {
                return dataTable.average(groupNode, n);
            }
            m_Log.warn((Object)("Average: Field not found: " + string));
            return null;
        }
        m_Log.warn((Object)"Average only supported for DataTable");
        return null;
    }

    public static Object count(Data data) {
        DataTable dataTable = data.getDataTable();
        if (dataTable != null) {
            GroupNode groupNode = data.getGroup();
            return groupNode.getStop() - groupNode.getStart() + 1;
        }
        m_Log.warn((Object)"Count only supported for DataTable");
        return null;
    }

    public static Object max(Data data, String string) {
        DataTable dataTable = data.getDataTable();
        if (dataTable != null) {
            GroupNode groupNode = data.getGroup();
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(string);
            if (n >= 0) {
                return dataTable.max(groupNode, n);
            }
            m_Log.warn((Object)("Max: Field not found: " + string));
            return null;
        }
        m_Log.warn((Object)"Max only supported for DataTable");
        return null;
    }

    public static Object min(Data data, String string) {
        DataTable dataTable = data.getDataTable();
        if (dataTable != null) {
            GroupNode groupNode = data.getGroup();
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(string);
            if (n >= 0) {
                return dataTable.min(groupNode, n);
            }
            m_Log.warn((Object)("Min: Field not found: " + string));
            return null;
        }
        m_Log.warn((Object)"Min only supported for DataTable");
        return null;
    }

    public static Object sum(Data data, String string) {
        DataTable dataTable = data.getDataTable();
        if (dataTable != null) {
            GroupNode groupNode = data.getGroup();
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(string);
            if (n >= 0) {
                return dataTable.sum(groupNode, n);
            }
            m_Log.warn((Object)("Sum: Field not found: " + string));
            return null;
        }
        m_Log.warn((Object)"Sum only supported for DataTable");
        return null;
    }

    public static Object standardDeviation(Data data, String string) {
        DataTable dataTable = data.getDataTable();
        if (dataTable != null) {
            GroupNode groupNode = data.getGroup();
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(string);
            if (n >= 0) {
                return dataTable.standardDeviation(groupNode, n);
            }
            m_Log.warn((Object)("StandardDeviation: Field not found: " + string));
            return null;
        }
        m_Log.warn((Object)"StandardDeviation only supported for DataTable");
        return null;
    }

    public static Object var(Data data, String string) {
        Object object = MathEx.standardDeviation(data, string);
        if (object != null && object instanceof Double) {
            return new Double(Math.pow((Double)object, 2.0));
        }
        return object;
    }

    public static boolean isNaN(Number number) {
        return Double.isNaN(number.doubleValue());
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(f);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static double E() {
        return Math.E;
    }

    public static double PI() {
        return Math.PI;
    }

    public static double toDegrees(double d) {
        return d / (Math.PI * 2) * 360.0;
    }

    public static double toRadians(double d) {
        return d / 360.0 * 2.0 * Math.PI;
    }
}

