/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberEx {
    public static final String ROUND_CEILING = "r-c";
    public static final String ROUND_FLOOR = "r-f";
    public static final String ROUND_HALF_UP = "r-h-u";
    public static final String ROUND_HALF_DOWN = "r-h-d";
    public static final String ROUND_HALF_EVEN = "r-h-e";
    public static final String ROUND_UP = "r-u";
    private static NumberFormat m_LocalCurrency = NumberFormat.getCurrencyInstance();

    private static int roundType(String string) {
        if (ROUND_CEILING.equals(string)) {
            return 2;
        }
        if (ROUND_FLOOR.equals(string)) {
            return 3;
        }
        if (ROUND_HALF_UP.equals(string)) {
            return 4;
        }
        if (ROUND_HALF_DOWN.equals(string)) {
            return 5;
        }
        if (ROUND_HALF_EVEN.equals(string)) {
            return 6;
        }
        return 7;
    }

    public static String roundString(String string, int n, String string2) {
        BigDecimal bigDecimal = new BigDecimal(string);
        try {
            bigDecimal = bigDecimal.setScale(n, NumberEx.roundType(string2));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return bigDecimal.toString();
    }

    public static double round(String string, int n, String string2) {
        BigDecimal bigDecimal = new BigDecimal(string);
        try {
            bigDecimal = bigDecimal.setScale(n, NumberEx.roundType(string2));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return bigDecimal.doubleValue();
    }

    public static String currency(double d) {
        m_LocalCurrency.setMinimumFractionDigits(2);
        return m_LocalCurrency.format(d);
    }

    public static String currency(double d, int n, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
        numberFormat.setMinimumFractionDigits(n);
        return numberFormat.format(d);
    }

    public static String currency(double d, int n) {
        m_LocalCurrency.setMinimumFractionDigits(n);
        return m_LocalCurrency.format(d);
    }
}

