/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.Eye;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.PrintAttributes;
import com.elixirtech.glint.TOC;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.GlintPipeline;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Detail;
import com.elixirtech.report2.logical.model.GroupFooter;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.ReportFooter;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.physical.glint.ImageRenderer;
import com.elixirtech.report2.physical.renderer.IPhysicalRenderer;
import com.elixirtech.report2.print.PrintAttribute;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.StandardColor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class EyeRenderer
extends PhysicalRenderer
implements GraphicsCodes {
    protected Eye m_Eye;
    protected PageSequence m_CurrentPS;
    protected int m_PageCount;
    protected IGlint.StringId m_TotalId;
    protected boolean m_ShareImages;
    protected boolean m_DisableTotalId;

    public EyeRenderer(boolean bl) {
        super(GlintPipeline.FACTORY);
        this.m_ShareImages = bl;
    }

    public void disableTotalId() {
        this.m_DisableTotalId = true;
    }

    @Override
    public void disposeCache() {
        super.disposeCache();
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.initEye(pageSource.getLogicalReport(), this.m_ShareImages);
            PrintAttributes printAttributes = new PrintAttributes();
            RenderDetails renderDetails = pageSource.getRenderDetails();
            Iterator<Parameter> iterator = renderDetails.getParameterIterator();
            while (iterator.hasNext()) {
                Parameter parameter = iterator.next();
                PrintAttribute printAttribute = PrintAttribute.create(parameter.getKey(), parameter.getValue());
                if (printAttribute == null) continue;
                printAttributes.put(parameter.getKey(), parameter.getValue());
            }
            this.m_Eye.setPrintAttributes(printAttributes);
        }
        catch (IOException iOException) {
            throw new RenderException("Unable to initialize: " + String.valueOf(iOException), iOException);
        }
        if (!this.m_DisableTotalId) {
            this.m_TotalId = this.m_Eye.getResourceManager().defineString();
        }
        super.startReport(pageSource);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        if (this.m_CurrentPS != null && pageSequence.isResetPageCount() && !this.m_DisableTotalId) {
            this.writePageTotal();
            this.m_TotalId = this.m_Eye.getResourceManager().defineString();
        }
        this.m_CurrentPS = pageSequence;
        super.startPageSequence(pageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        int n = page.getPageSetup().getHorizontalPageCount();
        for (int i = 0; i < n; ++i) {
            this.renderPage(page, i, true);
        }
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        if (this.m_CurrentPS != null && !this.m_DisableTotalId) {
            this.writePageTotal();
        }
        this.m_Eye.setTick(this.getRootTOC());
        super.endReport(pageSource);
        try {
            this.m_Eye.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Error closing: " + String.valueOf(iOException), iOException);
        }
    }

    public MimeType getMimeType() {
        return MimeTypes.GLINT();
    }

    public Eye getEye() {
        return this.m_Eye;
    }

    public void renderPage(Page page, int n, boolean bl) {
        try {
            GlintRenderContext glintRenderContext = new GlintRenderContext((PhysicalRenderer)this, n + 1, page, this.m_Eye, (Map<String, Object>)this.m_Cache, bl);
            this.renderPage(glintRenderContext, page);
            glintRenderContext.dispose();
        }
        catch (IOException iOException) {
            throw new RenderException("Can't render page: " + String.valueOf(iOException), iOException);
        }
    }

    public void renderPage(Page page, int n, IGlint iGlint) {
        this.renderPage(page, n, iGlint, true);
    }

    public void renderPage(Page page, int n, IGlint iGlint, boolean bl) {
        GlintRenderContext glintRenderContext = new GlintRenderContext((PhysicalRenderer)this, n + 1, page, iGlint, (Map<String, Object>)this.m_Cache, bl);
        this.renderPage(glintRenderContext, page);
        glintRenderContext.dispose();
    }

    @Override
    public BufferedImage renderPageToImage(Page page, int n, int n2, int n3) {
        BufferedImage bufferedImage = super.renderPageToImage(page, n, n2, n3);
        for (Object v : this.m_Cache.values()) {
            if (!(v instanceof ImageRenderer.CacheItem)) continue;
            ((ImageRenderer.CacheItem)v).imageId = null;
        }
        return bufferedImage;
    }

    @Override
    public void renderPage(Page page, int n, Graphics graphics) {
        GlintGraphics2D glintGraphics2D = new GlintGraphics2D((Graphics2D)graphics);
        this.renderPage(page, n, glintGraphics2D);
    }

    public void renderPage(GlintRenderContext glintRenderContext, Page page) {
        Object object;
        Body body;
        PageHeader pageHeader;
        glintRenderContext.setTotalId(this.m_TotalId);
        this.m_PageCount = page.getPageNumber();
        int n = 0;
        IGlint iGlint = glintRenderContext.getGlint();
        PageSetup pageSetup = page.getPageSetup();
        int n2 = pageSetup.getLeft();
        int n3 = pageSetup.getTop();
        int n4 = pageSetup.getWidth() - pageSetup.getLeft() - pageSetup.getRight();
        int n5 = pageSetup.getHeight() - pageSetup.getTop() - pageSetup.getBottom();
        Page page2 = page.getWatermark();
        if (page2 != null) {
            this.renderPage(glintRenderContext, page2);
        }
        iGlint.pushClip(n2 + glintRenderContext.getHShift(), n3, n4, n5);
        if (n2 != 0 || n3 != 0) {
            iGlint.offsetOrigin(n2, n3);
        }
        if ((pageHeader = page.getPageHeader()) != null) {
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)pageHeader);
            n = pageHeader.getHeight();
            iGlint.offsetOrigin(0, n);
        }
        if ((body = page.getBody()) != null) {
            object = new GlintTranslator(glintRenderContext);
            this.renderBody(glintRenderContext, body, (GlintTranslator)object);
            ((GlintTranslator)object).revert();
        }
        iGlint.offsetOrigin(0, -n);
        object = page.getPageFooter();
        if (object != null) {
            int n6 = ((SizableElement)object).getHeight();
            int n7 = pageSetup.getHeight() - pageSetup.getTop() - pageSetup.getBottom() - n6;
            iGlint.offsetOrigin(0, n7);
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)object);
            iGlint.offsetOrigin(0, -n7);
        }
        iGlint.offsetOrigin(-n2, -n3);
        iGlint.popClip();
    }

    protected void initEye(LogicalReport logicalReport, boolean bl) throws IOException {
        this.m_Eye = new Eye(logicalReport.getCaption(), bl);
    }

    protected void renderBody(GlintRenderContext glintRenderContext, Body body, GlintTranslator glintTranslator) {
        Iterator<BodyPart> iterator = body.getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            if (bodyPart instanceof Columns) {
                this.renderColumns(glintRenderContext, (Columns)bodyPart, glintTranslator);
                continue;
            }
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)bodyPart);
            int n = bodyPart.getHeight();
            int n2 = bodyPart.getSpaceAfter();
            glintTranslator.translate(0, n + n2);
        }
    }

    protected void renderColumns(GlintRenderContext glintRenderContext, Columns columns, GlintTranslator glintTranslator) {
        int n = 0;
        GlintTranslator glintTranslator2 = new GlintTranslator(glintRenderContext);
        Iterator<Column> iterator = columns.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = iterator.next();
            this.renderColumn(glintRenderContext, column, glintTranslator2);
            n = Math.max(n, glintTranslator2.getY());
            if (!iterator.hasNext()) continue;
            int n2 = column.getWidth();
            int n3 = column.getSpaceAfter();
            glintTranslator2.revertY();
            glintTranslator2.translate(n2 + n3, 0);
        }
        glintTranslator2.revert();
        glintTranslator.translate(0, n);
    }

    protected void renderColumn(GlintRenderContext glintRenderContext, Column column, GlintTranslator glintTranslator) {
        Iterator<BodyPart> iterator = column.getBodyPartIterator();
        while (iterator.hasNext()) {
            BodyPart bodyPart = iterator.next();
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)bodyPart);
            int n = bodyPart.getHeight();
            int n2 = bodyPart.getSpaceAfter();
            glintTranslator.translate(0, n + n2);
        }
    }

    protected void renderChunk2(GlintRenderContext glintRenderContext, LogicalElementHolder logicalElementHolder) {
        if (logicalElementHolder instanceof ITOCElement && RenderUtil.isValidTOC(logicalElementHolder)) {
            this.pushTOC(glintRenderContext, (ITOCElement)((Object)logicalElementHolder));
        }
        String string = logicalElementHolder.getURL();
        boolean bl = StringUtil.notEmpty(string);
        String string2 = logicalElementHolder.getBackgroundColor();
        boolean bl2 = StringUtil.notEmpty(string2);
        if (bl2 || bl) {
            int n = logicalElementHolder.getWidth();
            int n2 = logicalElementHolder.getHeight();
            IGlint iGlint = glintRenderContext.getGlint();
            IGlint.PenId penId = iGlint.definePen(Pen.NONE);
            IGlint.ColorId colorId = null;
            colorId = bl2 ? iGlint.defineColor(Color.newInstance(StandardColor.lookup(string2))) : iGlint.defineColor(Color.NONE);
            if (bl) {
                iGlint.setURL(string, logicalElementHolder.getURLDescription());
            }
            iGlint.drawRect(penId, colorId, 0, 0, n, n2);
            if (bl) {
                iGlint.resetURL();
            }
        }
        Iterator<LogicalElement> iterator = logicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            this.render2(glintRenderContext, logicalElement);
        }
        if (RenderUtil.isValidTOC(logicalElementHolder) && this.m_TOCLevel > 0) {
            if (logicalElementHolder instanceof Detail) {
                if (((Detail)logicalElementHolder).isTableOfContents()) {
                    this.popTOC();
                }
            } else if (logicalElementHolder instanceof GroupFooter) {
                if (((GroupFooter)logicalElementHolder).isTableOfContents()) {
                    this.popTOC();
                }
            } else if (logicalElementHolder instanceof ReportFooter && ((ReportFooter)logicalElementHolder).isTableOfContents()) {
                this.popTOC();
            }
        }
    }

    protected void render2(GlintRenderContext glintRenderContext, LogicalElement logicalElement) {
        String string = logicalElement.getTagName();
        try {
            IPhysicalRenderer iPhysicalRenderer = this.m_PhysicalRendererFactory.getRenderer(string);
            if (iPhysicalRenderer != null) {
                iPhysicalRenderer.render(glintRenderContext, logicalElement);
            }
        }
        catch (RenderException renderException) {
            System.out.println(renderException.toString());
        }
    }

    public int getByteCount() {
        return this.m_Eye.getByteCount();
    }

    protected void writePageTotal() {
        if (this.m_TotalId != null) {
            this.m_Eye.getResourceManager().setString(this.m_TotalId, String.valueOf(this.m_PageCount));
        }
    }

    @Override
    protected void pushTOC(PhysicalRenderContext physicalRenderContext, ITOCElement iTOCElement) {
        if (iTOCElement.isTableOfContents()) {
            while (iTOCElement.getTOCLevel() > this.m_TOCLevel) {
                this.popTOC();
            }
            String string = iTOCElement.getTOCTitle();
            Page page = physicalRenderContext.getPage();
            Point point = physicalRenderContext.getOffset();
            this.m_CurrentTOC = new TOC(this.m_CurrentTOC, string, page.getPageNumber(), point.x, point.y);
            ++this.m_TOCLevel;
        }
    }

    protected static class GlintTranslator {
        private GlintRenderContext m_Context;
        private int m_X;
        private int m_Y;

        public GlintTranslator(GlintRenderContext glintRenderContext) {
            this.m_Context = glintRenderContext;
        }

        public void translate(int n, int n2) {
            this.m_X += n;
            this.m_Y += n2;
            if (n != 0 || n2 != 0) {
                this.m_Context.getGlint().offsetOrigin(n, n2);
            }
        }

        public void revert() {
            if (this.m_X != 0 || this.m_Y != 0) {
                this.m_Context.getGlint().offsetOrigin(-this.m_X, -this.m_Y);
            }
            this.m_X = 0;
            this.m_Y = 0;
        }

        public void revertY() {
            if (this.m_Y != 0) {
                this.m_Context.getGlint().offsetOrigin(0, -this.m_Y);
            }
            this.m_Y = 0;
        }

        public int getY() {
            return this.m_Y;
        }
    }
}

