/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.GlintResult;
import com.elixirtech.report2.engine.GlintStreamPageListener;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.ResultWrapper;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;

public class GlintModelPageListener
implements PageListener {
    private boolean m_Initialised;
    private PageSource m_PageSource;
    private Result m_Result;
    private EyeRenderer m_Renderer;
    private boolean m_Paged;
    private boolean m_FillBackground;

    public GlintModelPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageSource = pageSource;
    }

    private void init() throws RenderException {
        this.m_Initialised = true;
        RenderDetails renderDetails = this.m_PageSource.getRenderDetails();
        this.m_Paged = GlintStreamPageListener.isPaged(renderDetails);
        this.m_FillBackground = GlintStreamPageListener.isFillBackground(renderDetails);
        this.m_Renderer = new EyeRenderer(true);
        this.m_Renderer.startReport(this.m_PageSource);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        if (!this.m_Initialised) {
            this.init();
        }
        this.m_Renderer.startPageSequence(pageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (!this.m_Paged) {
            GlintStreamPageListener.adjustHeight(page);
        }
        PageSetup pageSetup = page.getPageSetup();
        int n = pageSetup.getHorizontalPageCount();
        for (int i = 0; i < n; ++i) {
            this.m_Renderer.renderPage(page, i, this.m_FillBackground);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.m_Renderer.endReport(pageSource);
        GlintResult glintResult = (GlintResult)((ResultWrapper)this.m_Result).result;
        glintResult.setResult(this.m_Renderer.getEye());
        this.m_Result = null;
        this.m_Renderer = null;
    }
}

