/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.report2.engine.AbstractPipeline;
import com.elixirtech.report2.engine.IMIMETypeConfig;
import com.elixirtech.report2.engine.ImagePageListener;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PagedLogicalRendererEngine;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.Source;
import com.elixirtech.report2.engine.TreeLogicalRendererEngine;
import com.elixirtech.report2.raw.model.RenderDetails;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class ImagePipeline
extends AbstractPipeline
implements IMIMETypeConfig {
    protected LogicalRendererEngine m_LogicalRenderer;
    protected LogicalRendererEngine m_TreeRenderer;
    protected MimeType m_MimeType;

    public ImagePipeline() {
        this.initFeature("DefaultFileExtension", ".zip");
        this.m_LogicalRenderer = new PagedLogicalRendererEngine();
        this.m_TreeRenderer = new TreeLogicalRendererEngine();
    }

    @Override
    public void setMIMEType(MimeType mimeType) {
        this.m_MimeType = mimeType;
    }

    @Override
    public LogicalRendererEngine getLogicalRendererEngine(Source source) {
        boolean bl = false;
        RenderDetails renderDetails = source.getRawReport().getRenderDetails(this.m_MimeType.value());
        if (renderDetails != null) {
            bl = renderDetails.isSet("Tree");
        }
        if (bl) {
            return this.m_TreeRenderer;
        }
        return this.m_LogicalRenderer;
    }

    @Override
    public PageListener getPageListener(Result result) {
        return new ImagePageListener(result);
    }

    @Override
    public void dispose() {
        this.m_LogicalRenderer = null;
        this.m_TreeRenderer = null;
        super.dispose();
    }

    protected String getExtension(ImageWriter imageWriter) {
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        String[] stringArray = imageWriterSpi.getFileSuffixes();
        if (stringArray.length == 0) {
            return "";
        }
        return "." + stringArray[0];
    }
}

