/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.xml.XMLWriter;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.RMLSAXOut;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.util.ByteCounterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class LogicalPageListener
implements PageListener {
    private Result m_Result;
    private LogicalReport m_Report;
    private PageSequence m_PageSequence;

    public LogicalPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_Report = pageSource.getLogicalReport();
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_PageSequence = pageSequence;
        this.m_Report.addPageSequence(this.m_PageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        this.m_PageSequence.addPage(page);
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_PageSequence = null;
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            ByteCounterOutputStream byteCounterOutputStream = new ByteCounterOutputStream(this.m_Result.getOutputStream());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteCounterOutputStream, "UTF-8");
            XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
            RMLSAXOut.process(xMLWriter, this.m_Report, true);
            xMLWriter.flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RenderException("Error writing output : " + String.valueOf(exception));
        }
        this.m_Result = null;
        this.m_Report = null;
        this.m_PageSequence = null;
    }
}

