/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.font.FontUtil;
import com.elixirtech.report2.physical.pdf.PDFGenerator;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.util.HashMap;

public class PDFFontMeasurer
implements IFontMeasurer {
    private static HashMap<String, Object> FONT_MAPPED = new HashMap();
    private BaseFont m_BaseFont;
    private Font m_GraphicFont;
    private int m_GraphicFontSize;
    private float m_Ascent;
    private float m_Descent;
    private float m_Leading;
    private float m_Height;

    public PDFFontMeasurer(Font font) {
        this.m_GraphicFont = font;
        this.m_GraphicFontSize = this.m_GraphicFont.getSize() / 20;
        java.awt.Font font2 = FontUtil.getAWTFont(this.m_GraphicFont);
        String string = font2.getFontName();
        String string2 = "Cp1252";
        boolean bl = false;
        Object object = FONT_MAPPED.get(string);
        if (object != null) {
            FontMapper fontMapper = (FontMapper)object;
            string = fontMapper.m_PDFFontName;
            string2 = fontMapper.m_Encoding;
            bl = fontMapper.m_Embedded;
            try {
                this.m_BaseFont = BaseFont.createFont(string, string2, bl);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.m_BaseFont = PDFGenerator.getDefaultFontMapper().awtToPdf(font2);
        }
        this.cacheMetrics();
    }

    @Override
    public float getWidth(String string) {
        return this.getSpacedWidth(string);
    }

    @Override
    public float getSpacedWidth(String string) {
        return this.m_BaseFont.getWidthPoint(string, (float)this.m_GraphicFontSize) * 20.0f;
    }

    @Override
    public float getCharWidth(char c) {
        return this.m_BaseFont.getWidthPoint(c, (float)this.m_GraphicFontSize) * 20.0f;
    }

    @Override
    public float getWidth(String string, int n, int n2) {
        String string2 = string.substring(n, n + n2);
        return this.getWidth(string2);
    }

    @Override
    public float getWidth(char[] cArray, int n, int n2) {
        String string = new String(cArray).substring(n, n + n2);
        return this.getWidth(string);
    }

    @Override
    public float getHeight() {
        return this.m_Height;
    }

    private void cacheMetrics() {
        this.m_Ascent = this.m_BaseFont.getFontDescriptor(9, this.m_GraphicFontSize) * 20.0f;
        this.m_Descent = -this.m_BaseFont.getFontDescriptor(10, this.m_GraphicFontSize) * 20.0f;
        this.m_Leading = this.m_BaseFont.getFontDescriptor(11, this.m_GraphicFontSize) * 20.0f;
        this.m_Height = this.m_Ascent + this.m_Descent + this.m_Leading;
    }

    @Override
    public float getAscent() {
        return this.m_Ascent;
    }

    @Override
    public float getDescent() {
        return this.m_Descent;
    }

    @Override
    public float getLeading() {
        return this.m_Leading;
    }

    public static class FontMapper {
        public String m_FontName;
        public String m_PDFFontName;
        public String m_Encoding;
        public boolean m_Embedded;
    }
}

