/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeTypes;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PSNonThreadedPrintable;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import java.io.IOException;
import java.io.OutputStream;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class PostScriptPageListener
implements PageListener {
    private Result m_Result;
    private OutputStream m_Out;
    private StreamPrintService m_SPS;
    private PSNonThreadedPrintable m_Printable;

    public PostScriptPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Out = this.m_Result.getOutputStream();
            DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(sERVICE_FORMATTED, MimeTypes.POSTSCRIPT().value());
            this.m_SPS = streamPrintServiceFactoryArray[0].getPrintService(this.m_Out);
            if (this.m_SPS == null) {
                throw new RenderException("No Postscript StreamPrintService available");
            }
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            this.m_Printable = new PSNonThreadedPrintable(pageSource, this.m_SPS, hashPrintRequestAttributeSet, false);
        }
        catch (IOException iOException) {
            throw new RenderException("Can't open stream: " + String.valueOf(iOException), iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        try {
            this.m_Printable.addPage(page);
        }
        catch (Exception exception) {
            throw new RenderException("Error detected during addPage", exception);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Printable.endReport();
            this.m_Printable.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RenderException("Print thread interrupted", interruptedException);
        }
        try {
            this.m_Out.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Can't close stream: " + String.valueOf(iOException), iOException);
        }
        this.m_Result = null;
        this.m_Out = null;
        this.m_SPS = null;
        this.m_Printable = null;
    }
}

