/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.package$;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.physical.xlsx.XLSXGenerator;
import com.elixirtech.report2.physical.xlsx.XLSXGenerator$;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class XLSXPageListener
implements PageListener {
    private final Result result;
    private final int DEFAULT_MULTIPLIER;
    private PageSource m_PageSource;
    private boolean m_bInit;
    private XLSXGenerator m_Generator;
    private final File m_TempFile;
    private final BufferedOutputStream m_Out;

    public XLSXPageListener(Result result) {
        this.result = result;
        this.DEFAULT_MULTIPLIER = 36;
        this.m_PageSource = null;
        this.m_bInit = false;
        this.m_Generator = null;
        this.m_TempFile = File.createTempFile("tmp-", ".xlsx");
        this.m_Out = new BufferedOutputStream(new FileOutputStream(this.m_TempFile));
    }

    public int DEFAULT_MULTIPLIER() {
        return this.DEFAULT_MULTIPLIER;
    }

    @Override
    public void startReport(PageSource psrc) {
        this.m_PageSource = psrc;
    }

    public void initParameters() {
        this.m_bInit = true;
        RenderDetails rd = this.m_PageSource.getRenderDetails();
        boolean snap = rd.isSet("Snap");
        String imRes = rd.getParameterValue("ImageResolution");
        boolean forceNumbersAsText = rd.isSet("ForceNumbersAsText");
        boolean lockCells = rd.isSet("LockCells");
        int multiplier = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)rd.getParameterValue("Multiplier")).flatMap((Function1 & Serializable)_$1 -> package$.MODULE$.richWrapper(_$1).toOptInt()).getOrElse(this::$anonfun$2));
        String printHeader = (String)Option$.MODULE$.apply((Object)rd.getParameterValue("PrintHeader")).getOrElse(XLSXPageListener::$anonfun$3);
        String printFooter = (String)Option$.MODULE$.apply((Object)rd.getParameterValue("PrintFooter")).getOrElse(XLSXPageListener::$anonfun$4);
        try {
            this.m_Generator = new XLSXGenerator(this.m_PageSource.getLogicalReport(), this.m_Out, multiplier);
            this.m_Generator.setSnap(snap);
            this.m_Generator.setForceNumbersAsText(forceNumbersAsText);
            this.m_Generator.setLockCells(lockCells);
            this.m_Generator.setPrintHeaderFooter(printHeader, printFooter);
            XLSXGenerator xLSXGenerator = this.m_Generator;
            Option$.MODULE$.apply((Object)imRes).flatMap((Function1 & Serializable)_$2 -> package$.MODULE$.richWrapper(_$2).toOptInt()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)dpi -> xLSXGenerator.setImageResolution(dpi));
        }
        catch (IOException ex) {
            throw new RenderException("Error opening stream: " + ex, ex);
        }
    }

    @Override
    public void startPageSequence(PageSequence ps) {
        if (!this.m_bInit) {
            this.initParameters();
            return;
        }
    }

    @Override
    public void addPage(Page p) {
        try {
            this.m_Generator.renderPage(p);
        }
        catch (Exception ex) {
            throw new RenderException("Error writing page: " + ex, ex);
        }
    }

    @Override
    public void endPageSequence(PageSequence ps) {
    }

    @Override
    public void endReport(PageSource psrc) {
        if (this.m_bInit) {
            String password;
            try {
                this.m_Generator.close();
                this.m_Out.close();
            }
            catch (Exception ex) {
                throw new RenderException("Error closing stream: " + ex, ex);
            }
            this.m_Generator = null;
            String string = password = (String)Option$.MODULE$.apply((Object)psrc.getRenderDetails().getParameterValue("Password")).map((Function1 & Serializable)_$3 -> _$3.trim()).getOrElse(XLSXPageListener::$anonfun$6);
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.encryptFile(password);
            }
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                OutputStream os = (OutputStream)arm.manage((Object)this.result.getOutputStream());
                Files.copy(this.m_TempFile.toPath(), os);
            });
        }
        this.m_TempFile.delete();
    }

    public void encryptFile(String password) {
        JobLogging$.MODULE$.info("XLSX", (Function0<String>)((Function0 & Serializable)XLSXPageListener::encryptFile$$anonfun$1));
        try {
            POIFSFileSystem fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                OPCPackage opc = (OPCPackage)arm.manage((Object)OPCPackage.open((File)this.m_TempFile, (PackageAccess)PackageAccess.READ_WRITE));
                OutputStream os = (OutputStream)arm.manage((Object)enc.getDataStream(fs));
                opc.save(os);
            });
            File temp2 = File.createTempFile("tmp-", ".xlsx");
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm2 -> {
                FileOutputStream fos = (FileOutputStream)arm2.manage((Object)new FileOutputStream(temp2));
                fs.writeFilesystem((OutputStream)fos);
            });
            this.m_TempFile.delete();
            temp2.renameTo(this.m_TempFile);
            JobLogging$.MODULE$.info("XLSX", (Function0<String>)((Function0 & Serializable)XLSXPageListener::encryptFile$$anonfun$4));
        }
        catch (Exception ex) {
            JobLogging$.MODULE$.error("XLSX", (Function0<String>)((Function0 & Serializable)() -> XLSXPageListener.encryptFile$$anonfun$5(ex)), ex);
        }
    }

    private final int $anonfun$2() {
        return this.DEFAULT_MULTIPLIER();
    }

    private static final String $anonfun$3() {
        return XLSXGenerator$.MODULE$.DefaultPrintHeader();
    }

    private static final String $anonfun$4() {
        return XLSXGenerator$.MODULE$.DefaultPrintFooter();
    }

    private static final String $anonfun$6() {
        return "";
    }

    private static final String encryptFile$$anonfun$1() {
        return "Encrypting file";
    }

    private static final String encryptFile$$anonfun$4() {
        return "Encryption complete";
    }

    private static final String encryptFile$$anonfun$5(Exception ex$1) {
        return "Encryption error: " + ex$1;
    }
}

