/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine.pl;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.GroupFooter;
import com.elixirtech.report2.logical.model.GroupHeader;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.ReportFooter;
import com.elixirtech.report2.logical.model.ReportHeader;
import com.elixirtech.util.IntRange;
import java.util.Iterator;
import java.util.Stack;

public class FilterPageListener
implements PageListener {
    protected IntRange m_IntRange;
    protected PageListener m_Next;
    protected PageSequence m_CurrentPS;
    protected int m_PageCount;
    protected Stack<BodyPart> m_SkippedTOC = new Stack();

    public FilterPageListener(PageListener pageListener, String string) {
        this.m_Next = pageListener;
        this.m_IntRange = new IntRange(string);
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageCount = 0;
        this.m_Next.startReport(pageSource);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_CurrentPS = pageSequence;
    }

    @Override
    public void addPage(Page page) throws RenderException {
        ++this.m_PageCount;
        if (this.isShowPage()) {
            if (this.m_CurrentPS != null) {
                this.m_Next.startPageSequence(this.m_CurrentPS);
                this.m_CurrentPS = null;
            }
            this.flushSkippedTOC(page);
            this.m_Next.addPage(page);
        } else {
            this.addSkippedTOC(page);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        if (this.m_CurrentPS == null) {
            this.m_Next.endPageSequence(pageSequence);
        } else {
            this.m_CurrentPS = null;
        }
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.m_Next.endReport(pageSource);
        this.m_Next = null;
        this.m_IntRange = null;
        this.m_CurrentPS = null;
        this.m_SkippedTOC = null;
    }

    protected boolean isShowPage() {
        return this.m_IntRange.contains(this.m_PageCount);
    }

    private void addSkippedTOC(Page page) {
        Iterator<BodyPart> iterator = page.getBody().getBodyPartIterator();
        while (iterator.hasNext()) {
            this.addSkippedTOC(iterator.next());
        }
    }

    private void addSkippedTOC(BodyPart bodyPart) {
        if (this.isSignificantHeader(bodyPart)) {
            this.m_SkippedTOC.push(this.buildFix(bodyPart));
        } else if (this.isSignificantFooter(bodyPart)) {
            if (this.m_SkippedTOC.size() > 0) {
                BodyPart bodyPart2 = this.m_SkippedTOC.peek();
                if (this.isHeader(bodyPart2)) {
                    this.m_SkippedTOC.pop();
                } else {
                    this.m_SkippedTOC.push(this.buildFix(bodyPart));
                }
            } else {
                this.m_SkippedTOC.push(this.buildFix(bodyPart));
            }
        }
    }

    private void flushSkippedTOC(Page page) {
        Body body = page.getBody();
        while (this.m_SkippedTOC.size() > 0) {
            body.addBodyPart(0, this.m_SkippedTOC.pop());
        }
    }

    private boolean isHeader(BodyPart bodyPart) {
        return bodyPart instanceof ReportHeader || bodyPart instanceof GroupHeader;
    }

    private boolean isSignificantHeader(BodyPart bodyPart) {
        return (bodyPart instanceof ReportHeader || bodyPart instanceof GroupHeader) && RenderUtil.isValidTOC(bodyPart) && ((ITOCElement)((Object)bodyPart)).isTableOfContents();
    }

    private boolean isSignificantFooter(BodyPart bodyPart) {
        if (RenderUtil.isValidTOC(bodyPart)) {
            if (bodyPart instanceof ReportFooter) {
                return ((ReportFooter)bodyPart).isTableOfContents();
            }
            if (bodyPart instanceof GroupFooter) {
                return ((GroupFooter)bodyPart).isTableOfContents();
            }
        }
        return false;
    }

    private BodyPart buildFix(BodyPart bodyPart) {
        if (bodyPart instanceof ReportHeader) {
            ITOCElement iTOCElement = (ITOCElement)((Object)bodyPart);
            ReportHeader reportHeader = new ReportHeader();
            reportHeader.setTableOfContents(iTOCElement.isTableOfContents());
            reportHeader.setTOCTitle(iTOCElement.getTOCTitle());
            reportHeader.setTOCLevel(iTOCElement.getTOCLevel());
            return reportHeader;
        }
        if (bodyPart instanceof GroupHeader) {
            ITOCElement iTOCElement = (ITOCElement)((Object)bodyPart);
            GroupHeader groupHeader = new GroupHeader();
            groupHeader.setTableOfContents(iTOCElement.isTableOfContents());
            groupHeader.setTOCTitle(iTOCElement.getTOCTitle());
            groupHeader.setTOCLevel(iTOCElement.getTOCLevel());
            return groupHeader;
        }
        if (bodyPart instanceof GroupFooter) {
            GroupFooter groupFooter = (GroupFooter)bodyPart;
            GroupFooter groupFooter2 = new GroupFooter();
            groupFooter2.setTableOfContents(groupFooter.isTableOfContents());
            return groupFooter2;
        }
        if (bodyPart instanceof ReportFooter) {
            ReportFooter reportFooter = (ReportFooter)bodyPart;
            ReportFooter reportFooter2 = new ReportFooter();
            reportFooter2.setTableOfContents(reportFooter.isTableOfContents());
            return reportFooter2;
        }
        return null;
    }
}

