/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.report2.html.HTMLConstants;
import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLGenerator;
import com.elixirtech.report2.html.ImageUtil;
import com.elixirtech.report2.html.Style;
import com.elixirtech.report2.raw.constants.Alignment;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;

public class HTMLImage
extends HTMLElement
implements HTMLConstants {
    private HTMLGenerator m_Generator;
    private BufferedImage m_Image;
    private String m_SizeMode;
    private int m_Alignment;
    private int m_Width;
    private int m_Height;

    public HTMLImage(HTMLGenerator hTMLGenerator) {
        super("img");
        this.m_Generator = hTMLGenerator;
    }

    public void setImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("image null");
        }
        this.m_Image = bufferedImage;
    }

    public void setSizeMode(String string) {
        this.m_SizeMode = string;
    }

    public void setAlignment(int n) {
        this.m_Alignment = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_Width = n3;
        this.m_Height = n4;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.m_Image != null) {
            try {
                this.buildImage();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error building image: " + String.valueOf(iOException), iOException);
            }
        }
        return super.getAttributes();
    }

    protected void buildImage() throws IOException {
        if (this.m_Width <= 0) {
            return;
        }
        BufferedImage bufferedImage = null;
        bufferedImage = "Clip".equals(this.m_SizeMode) ? ImageUtil.clip(this.m_Image, new Dimension(this.m_Width, this.m_Height), this.m_Alignment) : this.m_Image;
        String string = this.m_Generator.getImageId(bufferedImage);
        this.addAttribute("src", string);
        if ("Stretch".equals(this.m_SizeMode)) {
            this.addAttribute("width", Integer.toString(this.m_Width));
            this.addAttribute("height", Integer.toString(this.m_Height));
        } else if ("Clip".equals(this.m_SizeMode)) {
            Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            Point point = Alignment.getTopLeft(dimension, new Dimension(this.m_Width, this.m_Height), this.m_Alignment);
            if (point.x != 0 || point.y != 0) {
                Style style = new Style();
                style.add("position", "relative");
                style.add("left", Integer.toString(point.x) + "px");
                style.add("top", Integer.toString(point.y) + "px");
                this.addStyle(style);
            } else {
                Style style = new Style();
                style.add("position", "absolute");
                this.addStyle(style);
            }
            this.addAttribute("width", Integer.toString(bufferedImage.getWidth()));
            this.addAttribute("height", Integer.toString(bufferedImage.getHeight()));
        } else if ("Zoom".equals(this.m_SizeMode)) {
            double d = (double)this.m_Width / (double)bufferedImage.getWidth();
            double d2 = (double)this.m_Height / (double)bufferedImage.getHeight();
            double d3 = Math.min(d, d2);
            Dimension dimension = new Dimension((int)((double)bufferedImage.getWidth() * d3), (int)((double)bufferedImage.getHeight() * d3));
            Point point = Alignment.getTopLeft(dimension, new Dimension(this.m_Width, this.m_Height), this.m_Alignment);
            if (point.x != 0 || point.y != 0) {
                Style style = new Style();
                style.add("position", "relative");
                style.add("left", Integer.toString(point.x) + "px");
                style.add("top", Integer.toString(point.y) + "px");
                this.addStyle(style);
            }
            this.addAttribute("width", Integer.toString((int)((double)bufferedImage.getWidth() * d3)));
            this.addAttribute("height", Integer.toString((int)((double)bufferedImage.getHeight() * d3)));
        }
    }

    protected boolean canShare() {
        if ("Stretch".equals(this.m_SizeMode)) {
            return true;
        }
        if ("Zoom".equals(this.m_SizeMode)) {
            return true;
        }
        if ("Clip".equals(this.m_SizeMode)) {
            int n = this.m_Image.getWidth();
            int n2 = this.m_Image.getHeight();
            if (n <= this.m_Width && n2 <= this.m_Height) {
                return true;
            }
        }
        return false;
    }
}

