/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.ElixirExt;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.report2.html.TOCBuilder;
import com.elixirtech.report2.util.VariableSubstitution;
import com.elixirtech.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HTMLNavigator {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(HTMLNavigator.class);
    private File m_RootDir;
    private ClassLoader m_ClassLoader;
    private List<Integer> m_PageTotals = new ArrayList<Integer>();
    protected static final String NL = System.getProperty("line.separator");

    public void render(ZipOutputStream zipOutputStream, int n, TOCBuilder tOCBuilder) throws IOException {
        Cloneable cloneable;
        Object object;
        this.genPageList(zipOutputStream, n);
        if (tOCBuilder != null) {
            object = this.substituteTOC(tOCBuilder);
            cloneable = new ZipEntry("index" + this.getHTMLExtension());
            zipOutputStream.putNextEntry((ZipEntry)cloneable);
            this.writeIndexHtml(zipOutputStream, (String)object);
            zipOutputStream.closeEntry();
        }
        object = this.getFilesSpec();
        cloneable = ((Document)object).getRootElement();
        for (Element element : cloneable.getChildren("file")) {
            String string = element.getAttributeValue("dir");
            String string2 = element.getText();
            this.addResource(zipOutputStream, string + "/" + string2, string2);
        }
        if (tOCBuilder != null) {
            tOCBuilder.render(zipOutputStream);
        }
    }

    public boolean supportsPageTotalScripts() {
        return true;
    }

    public int getNextPageTotalId() {
        return this.m_PageTotals.size();
    }

    public void addPageTotal(int n) {
        this.m_PageTotals.add(n);
    }

    protected String getFilesSpecName() {
        return "html-files.xml";
    }

    protected Document getFilesSpec() throws IOException {
        String string = this.getFilesSpecName();
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            this.m_ClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = this.m_ClassLoader.getResourceAsStream("resources/navigation/" + string);
            return sAXBuilder.build(inputStream);
        }
        catch (Exception exception) {
            throw new IOException("Unable to read from classpath " + string + ": " + String.valueOf(exception));
        }
    }

    protected String getContentsExtension() {
        return ".html";
    }

    protected String getHTMLExtension() {
        return ".html";
    }

    protected void genPageList(ZipOutputStream zipOutputStream, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("var pages = new Array();" + NL);
        for (n2 = 1; n2 <= n; ++n2) {
            stringBuffer.append("pages[" + n2 + "] = 'page" + n2 + this.getContentsExtension() + "';" + NL);
        }
        if (this.m_PageTotals.size() > 0) {
            stringBuffer.append(NL);
            stringBuffer.append("var totals = new Array();" + NL);
            for (n2 = 0; n2 < this.m_PageTotals.size(); ++n2) {
                stringBuffer.append("totals[" + n2 + "] = " + String.valueOf(this.m_PageTotals.get(n2)) + ";" + NL);
            }
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
            ZipEntry zipEntry = new ZipEntry("pageList.js");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResource(ZipOutputStream zipOutputStream, String string, String string2) {
        InputStream inputStream = null;
        try {
            Object object;
            if (this.m_RootDir != null) {
                object = new File(this.m_RootDir, string);
                inputStream = new FileInputStream((File)object);
            } else {
                inputStream = this.m_ClassLoader.getResourceAsStream("resources/navigation/" + string);
            }
            object = new ZipEntry(string2);
            try {
                int n;
                zipOutputStream.putNextEntry((ZipEntry)object);
                while ((n = inputStream.read()) != -1) {
                    zipOutputStream.write(n);
                }
            }
            finally {
                zipOutputStream.flush();
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            try {
                ElixirExt.error("HTMLNavigator.error-zipping" + String.valueOf(iOException), iOException);
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
            FileUtil.close(inputStream);
        }
        FileUtil.close(inputStream);
    }

    protected String getIndexContents(TOCBuilder tOCBuilder) throws IOException {
        return tOCBuilder.getIndexContents();
    }

    protected String getTOCContents(TOCBuilder tOCBuilder) throws IOException {
        return tOCBuilder.getTOCContents();
    }

    private void writeIndexHtml(OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).flush();
    }

    private String substituteTOC(TOCBuilder tOCBuilder) throws IOException {
        String string = this.getStringResource("common/navigation" + this.getHTMLExtension());
        String string2 = this.getContentsExtension().substring(1);
        String string3 = this.getStringResource(string2 + "/index" + this.getHTMLExtension());
        String string4 = this.getIndexContents(tOCBuilder);
        String string5 = this.getTOCContents(tOCBuilder);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("navigation", string);
        hashMap.put("page-index", string4 == null ? "" : string4);
        hashMap.put("toc-index", string5 == null ? "" : string5);
        VariableSubstitution variableSubstitution = new VariableSubstitution(hashMap);
        return variableSubstitution.substitute(string3);
    }

    private String getStringResource(String string) {
        try {
            m_Log.info((Object)("Reading from resource resources/navigation/" + string));
            this.m_ClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = this.m_ClassLoader.getResourceAsStream("resources/navigation/" + string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            StringWriter stringWriter = new StringWriter();
            FileUtil.copyStream(inputStreamReader, stringWriter, false);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            ElixirExt.error("HTMLNavigator.error-zipping" + String.valueOf(exception), exception);
            return null;
        }
    }
}

