/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.report2.font.FontUtil;
import com.elixirtech.report2.html.HTMLConstants;
import com.elixirtech.report2.html.Style;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.Reference;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.logical.model.TOCList;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Locale;

public class StyleBuilder
implements HTMLConstants {
    private static final DecimalFormat TWO_DP = new DecimalFormat("0.00");

    public Style getStyle(Page page) {
        PageSetup pageSetup = page.getPageSetup();
        Style style = new Style();
        style.add("position", "relative");
        style.add("width", Integer.toString(pageSetup.getWidth() / 20) + "px");
        style.add("height", Integer.toString(pageSetup.getHeight() / 20) + "px");
        return style;
    }

    public Style getStreamedStyle(Page page, int n) {
        PageSetup pageSetup = page.getPageSetup();
        Style style = new Style();
        style.add("position", "relative");
        style.add("width", Integer.toString(pageSetup.getWidth() / 20) + "px");
        style.add("height", Integer.toString(n / 20) + "px");
        return style;
    }

    public Style getStyle(LogicalElementHolder logicalElementHolder) {
        Style style = new Style();
        Color color = StandardColor.lookup(logicalElementHolder.getBackgroundColor());
        if (color.getAlpha() > 0) {
            style.add("background-color", this.rgb(color));
            if (color.getAlpha() < 255) {
                style.add("opacity", TWO_DP.format((double)color.getAlpha() / 255.0));
            }
        }
        return style;
    }

    public Style getStyle(Rectangle rectangle) {
        BorderStyle borderStyle;
        Style style = new Style();
        Color color = StandardColor.lookup(rectangle.getBackgroundColor());
        if (color.getAlpha() > 0) {
            style.add("background-color", this.rgb(color));
            if (color.getAlpha() < 255) {
                style.add("opacity", TWO_DP.format((double)color.getAlpha() / 255.0));
            }
        }
        if ((borderStyle = BorderStyle.get(rectangle.getBorderStyle())) != BorderStyle.NONE) {
            String string = borderStyle.NAME.toLowerCase(Locale.getDefault());
            if ("wave".equals(string)) {
                string = "solid";
            } else if ("dotdash".equals(string)) {
                string = "solid";
            } else if ("dotdotdash".equals(string)) {
                string = "solid";
            }
            boolean bl = rectangle.isBorderLeft();
            boolean bl2 = rectangle.isBorderTop();
            boolean bl3 = rectangle.isBorderRight();
            boolean bl4 = rectangle.isBorderBottom();
            if (bl || bl3 || bl2 || bl4) {
                String string2 = Integer.toString(rectangle.getBorderWidth() / 20) + "px";
                style.add("border-color", this.color(rectangle.getBorderColor()));
                if (bl && bl3 && bl2 && bl4) {
                    style.add("border-width", string2);
                    style.add("border-style", string);
                } else {
                    if (bl) {
                        style.add("border-left-style", string);
                        style.add("border-left-width", string2);
                    } else {
                        style.add("border-left-style", "none");
                        style.add("border-left-width", "0");
                    }
                    if (bl2) {
                        style.add("border-top-style", string);
                        style.add("border-top-width", string2);
                    } else {
                        style.add("border-top-style", "none");
                        style.add("border-top-width", "0");
                    }
                    if (bl3) {
                        style.add("border-right-style", string);
                        style.add("border-right-width", string2);
                    } else {
                        style.add("border-right-style", "none");
                        style.add("border-right-width", "0");
                    }
                    if (bl4) {
                        style.add("border-bottom-style", string);
                        style.add("border-bottom-width", string2);
                    } else {
                        style.add("border-bottom-style", "none");
                        style.add("border-bottom-width", "0");
                    }
                }
            }
        }
        return style;
    }

    public Style getStyle(Text text) {
        Style style = new Style();
        style.add("color", this.color(text.getFontColor()));
        Font font = FontUtil.getFont(text);
        style.add("font-family", font.getName());
        style.add("font-size", font.getSize() / 20 + "px");
        style.add("font-weight", font.isBold() ? "bold" : "normal");
        style.add("font-style", font.isItalic() ? "italic" : "normal");
        style.add("text-align", text.getTextAlign().toLowerCase(Locale.ENGLISH));
        if (text.isFontUnderline()) {
            style.add("text-decoration", "underline");
        }
        return style;
    }

    public Style getCellStyle(Grid grid) {
        Style style = this.getStyle(grid);
        style.remove("text-align");
        style.add("text-align", "center");
        if (grid.isBoxBorderBottom() && grid.isBoxBorderSide() && grid.isBoxBorderTop()) {
            style.add("border-color", this.color(grid.getBoxBorderColor()));
            style.add("border-width", "1px");
            style.add("border", "solid");
        } else if (grid.isBoxBorderBottom() || grid.isBoxBorderSide() || grid.isBoxBorderTop()) {
            style.add("border-color", this.color(grid.getBoxBorderColor()));
            style.add("border-width", "1px");
            style.add("border-bottom", grid.isBoxBorderBottom() ? "solid" : "none");
            style.add("border-top", grid.isBoxBorderTop() ? "solid" : "none");
            if (grid.isBoxBorderSide()) {
                style.add("border-left", "solid");
                style.add("border-right", "solid");
            } else {
                style.add("border-left", "none");
                style.add("border-right", "none");
            }
        }
        return style;
    }

    public Style getStyle(Image image) {
        Style style = new Style();
        return style;
    }

    public Style getStyle(Glint glint) {
        Style style = new Style();
        return style;
    }

    public Style getStyle(SVG sVG) {
        Style style = new Style();
        return style;
    }

    public Style getStyle(Reference reference) {
        Style style = new Style();
        return style;
    }

    public Style getStyle(Line line) {
        return null;
    }

    private String color(String string) {
        Color color = StandardColor.lookup(string);
        if (color.getAlpha() == 0) {
            return "transparent";
        }
        return this.rgb(color);
    }

    private String rgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public void addPositionInfo(LogicalElement logicalElement, Style style, int n, int n2) {
        style.add("position", "absolute");
        style.add("left", Integer.toString(n + logicalElement.getLeft() / 20) + "px");
        style.add("top", Integer.toString(n2 + logicalElement.getTop() / 20) + "px");
        style.add("width", Integer.toString(logicalElement.getWidth() / 20) + "px");
        style.add("height", Integer.toString(logicalElement.getHeight() / 20) + "px");
    }

    public void addPositionInfo(Style style, int n, int n2, int n3, int n4) {
        style.add("position", "absolute");
        style.add("left", Integer.toString(n / 20) + "px");
        style.add("top", Integer.toString(n2 / 20) + "px");
        style.add("width", Integer.toString(n3 / 20) + "px");
        style.add("height", Integer.toString(n4 / 20) + "px");
    }

    public void addRectPositionInfo(Rectangle rectangle, Style style, int n, int n2) {
        int n3 = rectangle.getBorderWidth();
        BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
        if (borderStyle == BorderStyle.NONE) {
            this.addPositionInfo(rectangle, style, n, n2);
        } else {
            style.add("position", "absolute");
            style.add("left", Integer.toString(n + rectangle.getLeft() / 20) + "px");
            style.add("top", Integer.toString(n2 + rectangle.getTop() / 20) + "px");
            int n4 = rectangle.getWidth();
            if (rectangle.isBorderLeft()) {
                n4 -= n3;
            }
            if (rectangle.isBorderRight()) {
                n4 -= n3;
            }
            style.add("width", Integer.toString((int)Math.ceil((float)n4 / 20.0f)) + "px");
            int n5 = rectangle.getHeight();
            if (rectangle.isBorderTop()) {
                n5 -= n3;
            }
            if (rectangle.isBorderBottom()) {
                n5 -= n3;
            }
            style.add("height", Integer.toString((int)Math.ceil((float)n5 / 20.0f)) + "px");
        }
    }

    public void addPositionInfo(LogicalElementHolder logicalElementHolder, Style style, int n, int n2) {
        if (logicalElementHolder instanceof TOCList) {
            int n3 = logicalElementHolder.getLogicalElementCount();
            style.add("position", "absolute");
            style.add("left", Integer.toString(n) + "px");
            style.add("top", Integer.toString(n2) + "px");
            style.add("width", "100%");
            style.add("height", 12 * n3 + "px");
        } else {
            style.add("position", "absolute");
            style.add("left", Integer.toString(n) + "px");
            style.add("top", Integer.toString(n2) + "px");
            style.add("width", Integer.toString(logicalElementHolder.getWidth() / 20) + "px");
            style.add("height", Integer.toString(logicalElementHolder.getHeight() / 20) + "px");
        }
    }
}

