/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.RenderContext;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.pl.AuditPageListener;
import com.elixirtech.report2.engine.pl.BlankRemovalPageListener;
import com.elixirtech.report2.engine.pl.PageCountListener;
import com.elixirtech.report2.engine.pl.PageNumberListener;
import com.elixirtech.report2.js.IProperties;
import com.elixirtech.report2.logical.DuplicateDetector;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.StreamedSectionRenderer;
import com.elixirtech.report2.logical.layout.LayoutSequencer;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ClipUtil;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.IBody;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.renderer.FieldCache;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.script.ScriptEngine;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class LogicalRenderContext
extends RenderContext
implements PageSource {
    protected Result m_Result;
    protected StreamedSectionRenderer m_SectionRenderer;
    protected Stack<StreamedSectionRenderer> m_Scope = new Stack();
    protected LogicalReport m_LogicalReport;
    protected PageListener m_PageListener;
    protected PageSequence m_CurrentPageSequence;
    protected Page m_CurrentPage;
    protected IBody m_CurrentBody;
    protected Columns m_CurrentColumns;
    protected ILogicalElementHolder m_CurrentHolder;
    protected Map<RawModelElement, LogicalModelElement> m_RawToLogical = new HashMap<RawModelElement, LogicalModelElement>();
    protected Locale m_Locale;
    protected IProperties m_Properties = new PropertiesImpl();
    protected DuplicateDetector m_DuplicateDetector = new DuplicateDetector();
    protected FieldCache m_FieldCache = new FieldCache();
    protected int m_TOCLevel;
    protected boolean m_AutoWrap = true;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LogicalRenderContext.class);

    public LogicalRenderContext(PageListener pageListener, Result result) {
        super(null);
        this.m_Result = result;
        RawReport rawReport = this.getRawReport();
        pageListener = rawReport.isKeepPageCount() ? new PageCountListener(pageListener) : new PageNumberListener(pageListener);
        if (this.m_Result != null) {
            pageListener = new AuditPageListener(pageListener, this.m_Result);
            pageListener = new BlankRemovalPageListener(pageListener);
        }
        this.m_PageListener = this.wrapPageListener(pageListener);
    }

    public boolean isAutoWrap() {
        return this.m_AutoWrap;
    }

    public PageListener wrapPageListener(PageListener pageListener) {
        return pageListener;
    }

    public void setRenderStack(RenderStack renderStack) {
    }

    @Override
    public Result getResult() {
        return this.m_Result;
    }

    public RawReport getRawReport() {
        return RenderContainer.get(RawReport.class);
    }

    public RawElement getRawElementByName(String string) {
        return this.m_SectionRenderer.getRawElementByName(string);
    }

    public void setLogicalReport(LogicalReport logicalReport) {
        this.m_LogicalReport = logicalReport;
    }

    @Override
    public LogicalReport getLogicalReport() {
        return this.m_LogicalReport;
    }

    @Override
    public RenderDetails getRenderDetails() {
        return RenderContainer.get(RenderDetails.class);
    }

    public String getLocaleString() {
        return this.m_Locale.toString();
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public IProperties getProperties() {
        return this.m_Properties;
    }

    public DuplicateDetector getDuplicateDetector() {
        return this.m_DuplicateDetector;
    }

    public FieldCache getFieldCache() {
        return this.m_FieldCache;
    }

    public Data getData() {
        return this.m_SectionRenderer.getData();
    }

    public IFontMeasurer getFontMeasurer(Font font) {
        IFontMeasurerFactory iFontMeasurerFactory = RenderContainer.get(IFontMeasurerFactory.class);
        return iFontMeasurerFactory.getInstance(font);
    }

    public MimeType getMimeType() {
        return RenderContainer.current().getMimeType();
    }

    public DataTable getDataTable(String string, Properties properties) {
        try {
            DataSourceManager dataSourceManager = RenderContainer.get(DataSourceManager.class);
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
            List<Parameter> list = iDataSource.getParameters();
            for (Parameter parameter : list) {
                String string2 = parameter.getName();
                if (properties.contains(string2)) {
                    defaultPushContext.setParameter(string2, properties.getProperty(string2));
                    continue;
                }
                if (!properties.contains(string + "." + string2)) continue;
                defaultPushContext.setParameter(string2, properties.getProperty(string + "." + string2));
            }
            return DataTable.build(defaultPushContext, iDataSource);
        }
        catch (Exception exception) {
            m_Log.error((Object)("getDataTable(" + string + ") : " + String.valueOf(exception)));
            return null;
        }
    }

    public IDataCacheManager getDataCacheManager() {
        return RenderContainer.get(IDataCacheManager.class);
    }

    public void pushScope(StreamedSectionRenderer streamedSectionRenderer) {
        this.m_Scope.push(streamedSectionRenderer);
        this.m_SectionRenderer = streamedSectionRenderer;
        MimeType mimeType = streamedSectionRenderer.getRenderer().getMimeType();
        RawReport rawReport = this.getRawReport();
        if (MimeTypes.CSV().equals((Object)mimeType) && rawReport.isDisableCSVAutoWrap()) {
            this.m_AutoWrap = false;
        } else if (this.isExcel(mimeType) && rawReport.isDisableExcelAutoWrap()) {
            this.m_AutoWrap = false;
        }
        ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
        scriptEngine.define("javascript", "Renderer", this.m_SectionRenderer.getRenderer());
    }

    public boolean isExcel(MimeType mimeType) {
        return mimeType.equals((Object)MimeTypes.EXCEL()) || mimeType.equals((Object)MimeTypes.XLSX());
    }

    public void popScope() {
        this.m_Scope.pop();
        this.m_SectionRenderer = this.m_Scope.size() > 0 ? this.m_Scope.peek() : null;
    }

    public void renderChildren(IRawElementHolder iRawElementHolder, ILogicalElementHolder iLogicalElementHolder) {
        ILogicalElementHolder iLogicalElementHolder2 = this.m_CurrentHolder;
        this.m_CurrentHolder = iLogicalElementHolder;
        this.m_SectionRenderer.renderChildren(iRawElementHolder);
        this.m_CurrentHolder = iLogicalElementHolder2;
    }

    public void renderChild(RawModelElement rawModelElement, ILogicalElementHolder iLogicalElementHolder) {
        ILogicalElementHolder iLogicalElementHolder2 = this.m_CurrentHolder;
        this.m_CurrentHolder = iLogicalElementHolder;
        this.m_SectionRenderer.renderElement(rawModelElement, null);
        this.m_CurrentHolder = iLogicalElementHolder2;
    }

    public void renderChild(RawModelElement rawModelElement) {
        this.m_SectionRenderer.renderElement(rawModelElement, null);
    }

    public LogicalModelElement getLogicalForRaw(RawModelElement rawModelElement) {
        return this.m_RawToLogical.get(rawModelElement);
    }

    public LogicalElement addElement(LogicalElement logicalElement) {
        RawModelElement rawModelElement = logicalElement.getRaw();
        this.m_RawToLogical.put(rawModelElement, logicalElement);
        this.m_CurrentHolder.addLogicalElement(logicalElement);
        return logicalElement;
    }

    public void prepareBodyPart(BodyPart bodyPart) {
        this.layout(bodyPart);
        RenderUtil.growShrinkBodyPart(bodyPart);
    }

    public BodyPart addBodyPart(BodyPart bodyPart) {
        this.doAddBodyPart(bodyPart);
        this.m_RawToLogical.clear();
        this.m_RawToLogical.put(bodyPart.getRaw(), bodyPart);
        return bodyPart;
    }

    public void addWatermark(Page page) {
        this.m_CurrentPage.setWatermark(page);
    }

    public int getBodyWidth() {
        Section section = this.m_SectionRenderer.getSection();
        RenderStack renderStack = RenderStack.current();
        PageSetup pageSetup = renderStack.getPageSetup(section.getPageSetup());
        return pageSetup.getBodyWidth();
    }

    public PageSetup getPageSetup() {
        Section section = this.m_SectionRenderer.getSection();
        RenderStack renderStack = RenderStack.current();
        return renderStack.getPageSetup(section.getPageSetup());
    }

    public int getColumnWidth() {
        Section section = this.m_SectionRenderer.getSection();
        RenderStack renderStack = RenderStack.current();
        PageSetup pageSetup = renderStack.getPageSetup(section.getPageSetup());
        return pageSetup.getColumnWidth();
    }

    public boolean alreadyOnThisPage(GroupHeader groupHeader) {
        if (this.m_CurrentBody != null) {
            Iterator<BodyPart> iterator = this.m_CurrentBody.getBodyPartIterator();
            while (iterator.hasNext()) {
                BodyPart bodyPart = iterator.next();
                if (bodyPart.getRaw() != groupHeader) continue;
                return true;
            }
        }
        return false;
    }

    protected final void doAddBodyPart(BodyPart bodyPart) {
        this.lazyBodyCreate();
        this.m_CurrentBody.addBodyPart(bodyPart);
        this.notifyLayout(bodyPart);
    }

    protected void lazyBodyCreate() {
        if (this.m_CurrentBody == null) {
            if (this.m_CurrentColumns == null) {
                this.m_CurrentBody = new Body();
                this.m_CurrentPage.setBody((Body)this.m_CurrentBody);
            } else {
                this.startColumns();
                this.addColumn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLayout(BodyPart bodyPart) {
        Script script;
        Chunk chunk = (Chunk)bodyPart.getRaw();
        if (chunk != null && Script.notEmpty(script = chunk.getOnLayout())) {
            ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
            scriptEngine.pushJSScope(chunk);
            try {
                scriptEngine.define("javascript", "result", bodyPart);
                scriptEngine.define("javascript", "page", this.m_CurrentPage);
                scriptEngine.evaluate(script);
            }
            finally {
                scriptEngine.popJSScope();
            }
        }
    }

    public void startReport() {
        this.m_PageListener.startReport(this);
    }

    public PageSequence addPageSequence(boolean bl) {
        if (this.m_CurrentPage != null) {
            this.m_PageListener.addPage(this.m_CurrentPage);
            this.m_CurrentPage = null;
        }
        if (this.m_CurrentPageSequence != null) {
            this.m_PageListener.endPageSequence(this.m_CurrentPageSequence);
        }
        this.m_CurrentHolder = null;
        this.m_CurrentPageSequence = new PageSequence();
        this.m_CurrentPageSequence.setKeepBlankPages(this.m_SectionRenderer.getSection().isKeepBlankPages());
        this.m_CurrentPageSequence.setResetPageCount(bl);
        this.m_PageListener.startPageSequence(this.m_CurrentPageSequence);
        return this.m_CurrentPageSequence;
    }

    public Page addPage() {
        if (this.m_CurrentPage != null) {
            this.m_PageListener.addPage(this.m_CurrentPage);
        }
        this.m_CurrentPage = new Page();
        this.m_CurrentBody = null;
        this.m_CurrentColumns = null;
        RenderStack renderStack = RenderStack.current();
        PageSetup pageSetup = renderStack.getPageSetup(this.m_CurrentPageSequence.getMasterName());
        this.m_CurrentPage.setPageSetup(pageSetup);
        return this.m_CurrentPage;
    }

    public void endReport() {
        if (this.m_CurrentPage != null) {
            this.m_PageListener.addPage(this.m_CurrentPage);
            this.m_CurrentPage = null;
        }
        if (this.m_CurrentPageSequence != null) {
            this.m_PageListener.endPageSequence(this.m_CurrentPageSequence);
            this.m_CurrentPageSequence = null;
        }
        this.m_PageListener.endReport(this);
        this.m_FieldCache.dispose();
        this.m_FieldCache = null;
    }

    public Columns startColumns() {
        Columns columns = new Columns();
        this.doAddBodyPart(columns);
        this.m_CurrentColumns = columns;
        this.m_CurrentBody = null;
        return this.m_CurrentColumns;
    }

    public Column addColumn() {
        Section section = this.m_SectionRenderer.getSection();
        RenderStack renderStack = RenderStack.current();
        PageSetup pageSetup = renderStack.getPageSetup(section.getPageSetup());
        Column column = new Column();
        column.setWidth(pageSetup.getColumnWidth());
        column.setSpaceAfter(pageSetup.getColumnSpacing());
        this.m_CurrentColumns.addColumn(column);
        this.m_CurrentBody = column;
        return column;
    }

    public void endColumns() {
        this.m_CurrentColumns = null;
        this.m_CurrentBody = this.m_CurrentPage.getBody();
    }

    public void setPageHeader(PageHeader pageHeader) {
        this.layout(pageHeader);
        ClipUtil.clipHolder(pageHeader);
        this.m_CurrentPage.setPageHeader(pageHeader);
        this.m_RawToLogical.clear();
    }

    public void setPageFooter(PageFooter pageFooter) {
        this.layout(pageFooter);
        ClipUtil.clipHolder(pageFooter);
        this.m_CurrentPage.setPageFooter(pageFooter);
        this.m_RawToLogical.clear();
    }

    public int getTOCLevel() {
        return this.m_TOCLevel;
    }

    public void incTOCLevel() {
        ++this.m_TOCLevel;
    }

    public void decTOCLevel() {
        --this.m_TOCLevel;
    }

    protected void pageBreak(boolean bl) {
    }

    protected void ensureHeightAvailable(int n) {
    }

    protected void layout(LogicalElementHolder logicalElementHolder) {
        LayoutSequencer.layout(logicalElementHolder, this.m_RawToLogical);
    }

    private static class PropertiesImpl
    implements IProperties {
        @Override
        public String get(String string) {
            return RenderStack.current().getProperty(string);
        }

        @Override
        @Deprecated
        public String getProperty(String string) {
            return RenderStack.current().getProperty(string);
        }

        @Deprecated
        public void setProperty(String string, String string2) {
            m_Log.error((Object)"PropertiesImpl.setProperty not implemented");
        }
    }
}

