/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IDisposable;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.TerminateException;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.js.Format;
import com.elixirtech.report2.logical.AcrossThenDownStreamedSectionRenderer;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.StreamedSectionRenderer;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.raw.RMLUtil;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.ISequenceStep;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionInvocation;
import com.elixirtech.report2.util.ParameterManager;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LogicalRenderer
implements IDisposable {
    protected RawReport m_RawReport;
    protected DataSourceManager m_DataSourceManager;
    protected IDataCacheManager m_DataCacheManager;
    protected PageSetup m_PageSetup;
    protected JavaScriptEngine m_JSEngine = JavaScriptEngine.getInstance();
    protected ParameterManager m_ParameterManager;
    protected LogicalReport m_LogicalReport;
    protected LogicalRenderContext m_Context;
    protected boolean m_PrintIfNoDetails;
    protected static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LogicalRenderer.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public LogicalRenderer() {
        this.m_DataSourceManager = RenderContainer.get(DataSourceManager.class);
        this.m_DataCacheManager = RenderContainer.get(IDataCacheManager.class);
        this.m_Context = RenderContainer.get(LogicalRenderContext.class);
        this.initJavaScript();
    }

    protected void initJavaScript() {
        this.m_JSEngine.declareBean("Format", new Format());
        this.m_JSEngine.declareBean("Properties", this.m_Context.getProperties());
        this.m_JSEngine.declareBean("Parameters", this.m_Context.getProperties());
        this.m_JSEngine.declareBean("DataSourceManager", this.m_DataSourceManager, DataSourceManager.class);
        this.m_JSEngine.declareBean("DataCacheManager", this.m_DataCacheManager, IDataCacheManager.class);
    }

    protected boolean isRenderAnnotations() {
        com.elixirtech.report2.raw.model.Parameter parameter = this.m_RawReport.getParameter("render.annotations");
        boolean bl = parameter != null && "Yes".equals(parameter.getValue());
        m_Log.debug((Object)("isRenderAnnotations: " + bl));
        return bl;
    }

    public LogicalReport process(RawReport rawReport) throws RenderException {
        this.m_RawReport = rawReport;
        this.initResult();
        int n = 0;
        this.m_Context.startReport();
        Script script = this.m_RawReport.getFunctionDefinitions();
        if (Script.notEmpty(script)) {
            this.exec(script);
        }
        this.m_JSEngine.pushScope(this.m_JSEngine.toScriptable(this.m_RawReport));
        try {
            Object object;
            Script script2 = this.m_RawReport.getOnRenderBegin();
            if (Script.notEmpty(script2)) {
                this.exec(script2);
            }
            Iterator<ISequenceStep> iterator = this.m_RawReport.getSequenceStepIterator();
            while (iterator.hasNext()) {
                SectionInvocation sectionInvocation;
                object = iterator.next();
                if (!(object instanceof SectionInvocation) || !(sectionInvocation = (SectionInvocation)object).isEnabled()) continue;
                Section section = this.getSection(sectionInvocation);
                if (section != null) {
                    StreamedSectionRenderer streamedSectionRenderer = this.getSectionRenderer(section);
                    String string = sectionInvocation.getDataSourceName();
                    DataHolder dataHolder = new DataHolder(this.m_RawReport.getDataSource(string));
                    n += streamedSectionRenderer.process(this.m_RawReport, section, dataHolder);
                    streamedSectionRenderer.dispose();
                    continue;
                }
                m_Log.error((Object)("No section \"" + sectionInvocation.getSectionName() + "\" found"));
            }
            object = this.m_RawReport.getOnRenderEnd();
            if (Script.notEmpty((Script)object)) {
                this.m_JSEngine.declareBean("result", this.m_LogicalReport);
                this.exec((Script)object);
            }
        }
        catch (RenderException renderException) {
            throw renderException;
        }
        catch (TerminateException terminateException) {
            throw terminateException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RenderException("LogicalRenderer: " + String.valueOf(throwable), throwable);
        }
        finally {
            this.m_JSEngine.popScope();
        }
        this.m_LogicalReport.setRecordCount(n);
        this.m_Context.endReport();
        RenderContainer.release();
        return this.m_LogicalReport;
    }

    public int getStatus() {
        return 0;
    }

    protected void initResult() {
        this.m_LogicalReport = new LogicalReport();
        this.m_LogicalReport.setPhase("Logical");
        this.m_LogicalReport.setCaption(this.m_RawReport.getName());
        this.m_LogicalReport.setName(this.m_RawReport.getName());
        this.m_LogicalReport.setLocale(this.m_RawReport.getLocale());
        Map<String, RenderDetails> map = this.m_RawReport.getPageSetupIterator();
        while (map.hasNext()) {
            this.m_LogicalReport.addPageSetup(map.next());
        }
        map = new HashMap();
        for (com.elixirtech.report2.raw.model.Parameter parameter : this.m_RawReport.getParameterList()) {
            map.put(parameter.getKey(), (RenderDetails)((Object)parameter));
        }
        this.m_LogicalReport.setParameterMap((Map<String, com.elixirtech.report2.raw.model.Parameter>)map);
        map = this.m_RawReport.getRenderDetailsMap();
        this.m_LogicalReport.setRenderDetailsMap(map);
        this.m_Context.setLogicalReport(this.m_LogicalReport);
    }

    public StreamedSectionRenderer getSectionRenderer(Section section) {
        PageSetup pageSetup = section.getRawReport().getPageSetup(section.getPageSetup());
        StreamedSectionRenderer streamedSectionRenderer = pageSetup.getColumnCount() > 1 && "Across Then Down".equals(pageSetup.getColumnLayout()) ? new AcrossThenDownStreamedSectionRenderer(this.m_LogicalReport) : new StreamedSectionRenderer(this.m_LogicalReport);
        return streamedSectionRenderer;
    }

    protected IDataSource getDataSource(String string, Properties properties) throws DataException {
        DataSource dataSource = this.m_RawReport.getDataSource(string);
        if (dataSource != null) {
            return this.m_DataSourceManager.getDataSource(this.m_DataSourceManager, dataSource.getDataSourceName());
        }
        return null;
    }

    protected Section getSection(SectionInvocation sectionInvocation) throws IOException {
        RawReport rawReport = this.m_RawReport;
        String string = sectionInvocation.getReportName();
        if (StringUtil.notEmpty(string)) {
            RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
            RMLFileObject rMLFileObject = rMLRepository.getFileJ(string);
            if (rMLFileObject != null) {
                rawReport = RMLUtil.readRML(rMLFileObject);
            } else {
                m_Log.error((Object)("Can't load report " + string));
                return null;
            }
        }
        return rawReport.getSection(sectionInvocation.getSectionName());
    }

    public RawReport getRawReport() {
        return this.m_RawReport;
    }

    public LogicalReport getLogicalReport() {
        return this.m_LogicalReport;
    }

    public ParameterManager getParameterManager() {
        return this.m_ParameterManager;
    }

    @Override
    public void dispose() {
        this.m_RawReport = null;
        this.m_PageSetup = null;
        this.m_JSEngine = null;
        this.m_ParameterManager = null;
        this.m_LogicalReport = null;
        this.m_Context = null;
    }

    public DataTable getDataTable(String string, Properties properties) {
        try {
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            IDataSource iDataSource = this.m_DataSourceManager.getDataSource(this.m_DataSourceManager, string);
            List<Parameter> list = iDataSource.getParameters();
            for (Parameter parameter : list) {
                String string2 = parameter.getName();
                if (properties.contains(string2)) {
                    defaultPushContext.setParameter(string2, properties.getProperty(string2));
                    continue;
                }
                if (!properties.contains(string + "." + string2)) continue;
                defaultPushContext.setParameter(string2, properties.getProperty(string + "." + string2));
            }
            return DataTable.build(defaultPushContext, iDataSource);
        }
        catch (Exception exception) {
            m_Log.error((Object)("getDataTable(" + string + ") : " + String.valueOf(exception)));
            return null;
        }
    }

    public DataSourceManager getDataSourceManager() {
        return this.m_DataSourceManager;
    }

    public IDataCacheManager getDataCacheManager() {
        return this.m_DataCacheManager;
    }

    public Locale getLocale() {
        return this.m_RawReport.getLocale();
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    protected void readParameters() {
        this.m_ParameterManager = new ParameterManager();
        this.m_ParameterManager.addParameters(this.m_RawReport.getParameterIterator());
    }

    protected void exec(Script script) {
        String string = script.getLanguage();
        String string2 = script.getText();
        this.eval("report script", string, string2);
    }

    public Object eval(String string, String string2, String string3) {
        if ("javascript".equals(string2)) {
            try {
                return this.m_JSEngine.evaluate(string, string3);
            }
            catch (ScriptException scriptException) {
                m_JSLog.error((Object)("JavaScript eval: " + String.valueOf(scriptException)));
            }
        } else {
            m_Log.warn((Object)("eval() Unsupported language: " + string2 + " (src=" + string + ")"));
        }
        return null;
    }
}

