/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.MimeType;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.DataCacheManager;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.LogicalRenderer;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.SectionedRenderContext;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;

public class SectionedRenderContainer
extends RenderContainer {
    public SectionedRenderContainer(LogicalRendererEngine.Request request) {
        super(request.getMimeType());
        this.m_Container.register(RawReport.class, request.getRawReport());
        this.m_Container.register(PageListener.class, request.getPageListener());
        this.m_Container.register(DataSourceManager.class, request.getDataSourceManager());
        MimeType mimeType = request.getMimeType();
        RenderDetails renderDetails = request.getRawReport().getRenderDetails(mimeType.value());
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType(mimeType.value());
        }
        this.m_Container.register(RenderDetails.class, renderDetails);
        this.m_Container.register(Result.class, request.getResult());
        IFontMeasurerFactory iFontMeasurerFactory = request.getPipeline().getFontMeasurerFactory();
        this.m_Container.register(IFontMeasurerFactory.class, iFontMeasurerFactory);
        this.m_Container.register(IDataCacheManager.class, DataCacheManager.class);
        this.m_Container.register(JavaScriptEngine.class, JavaScriptEngine.class);
        this.initSpecialized();
        RawReport rawReport = request.getRawReport();
        new RenderStack(rawReport, SectionedRenderContainer.get(LogicalRenderContext.class));
    }

    public void push() {
    }

    public void pop() {
    }

    @Override
    public void dispose() {
        RenderStack.current().dispose();
        super.dispose();
    }

    protected void initSpecialized() {
        this.m_Container.register(LogicalRenderer.class, LogicalRenderer.class);
        this.m_Container.register(LogicalRenderContext.class, SectionedRenderContext.class);
    }
}

