/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.job.JobLogging;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.js.BasicScope;
import com.elixirtech.report2.IRenderFactory;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.data.RecordSource;
import com.elixirtech.report2.engine.SectionEngine;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.DataSink;
import com.elixirtech.report2.logical.IPaginator;
import com.elixirtech.report2.logical.IRenderer;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.LogicalRenderer;
import com.elixirtech.report2.logical.PagedSectionRenderer;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Empty;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.renderer.DetailRenderer;
import com.elixirtech.report2.logical.renderer.GroupFooterRenderer;
import com.elixirtech.report2.logical.renderer.GroupHeaderRenderer;
import com.elixirtech.report2.logical.renderer.IChunkRenderer;
import com.elixirtech.report2.logical.renderer.ILogicalRenderer;
import com.elixirtech.report2.logical.renderer.SectionFooterRenderer;
import com.elixirtech.report2.logical.renderer.SectionHeaderRenderer;
import com.elixirtech.report2.raw.RMLUtil;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.Detail;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.GroupFooter;
import com.elixirtech.report2.raw.model.GroupHeader;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.PageFooter;
import com.elixirtech.report2.raw.model.PageHeader;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionFooter;
import com.elixirtech.report2.raw.model.SectionHeader;
import com.elixirtech.report2.raw.model.SectionInvocation;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.repository.RMLFileObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StreamedSectionRenderer {
    protected IRenderFactory m_RenderFactory;
    protected LogicalRenderer m_LogicalRenderer;
    protected LogicalRenderContext m_LogicalRenderContext;
    protected IResourceProvider m_Report;
    protected Section m_Section;
    protected ScriptEngine m_ScriptEngine;
    protected RecordSource m_RecordSource;
    protected DataSink m_DataSink;
    protected Map<String, RawModelElement> m_RawNameMap;
    protected LogicalReport m_LogicalReport;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StreamedSectionRenderer.class);
    private static Map<String, IChunkRenderer> m_ChunkRenderers = new HashMap<String, IChunkRenderer>();
    static final boolean PRE_TEST_FIXED_SIZE;

    public StreamedSectionRenderer(LogicalReport logicalReport) {
        this.m_LogicalReport = logicalReport;
        this.m_LogicalRenderer = RenderContainer.get(LogicalRenderer.class);
        this.m_LogicalRenderContext = RenderStack.current().getContext();
        this.m_ScriptEngine = RenderStack.current().getScriptEngine();
        this.m_RenderFactory = (IRenderFactory)Elixir.get(IRenderFactory.class);
    }

    public LogicalRenderContext getRenderContext() {
        return this.m_LogicalRenderContext;
    }

    public IRenderer getRenderer() {
        return new RendererWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(IResourceProvider iResourceProvider, Section section, DataHolder dataHolder) throws RenderException, DataException {
        this.m_Report = iResourceProvider;
        this.m_Section = section;
        RenderStack renderStack = RenderStack.current();
        IResourceProvider iResourceProvider2 = this.m_Section.getRawReport();
        if (iResourceProvider2 != this.m_Report) {
            renderStack.push(iResourceProvider2, this.m_LogicalRenderContext);
        }
        if (!this.setupPaginator()) {
            return 0;
        }
        try {
            if (dataHolder.getDataSource() == null) {
                dataHolder.setDataSource(this.m_Section.getDataSource());
            }
            String string = dataHolder.getDataSourceName();
            boolean bl = dataHolder.isTabulate();
            IDataSource iDataSource = dataHolder.getIDataSource();
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            defaultPushContext.setParameters(dataHolder.getProperties());
            this.m_DataSink = new DataSink(this, section, string, defaultPushContext);
            this.m_RecordSource = new RecordSource(defaultPushContext, iDataSource);
            if (bl) {
                this.m_RecordSource.tabulate();
            }
            try {
                Script script = section.getRenderIf();
                Script script2 = section.getOnRenderBegin();
                Script script3 = section.getOnRenderEnd();
                boolean bl2 = Script.notEmpty(script) || Script.notEmpty(script2) || Script.notEmpty(script3);
                IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
                BasicScope basicScope = new BasicScope();
                basicScope.put("Section", section);
                basicScope.put("Renderer", new RendererWrapper());
                basicScope.put("Data", this.m_DataSink);
                basicScope.put("DataSource", this.m_RecordSource.getSource());
                basicScope.put("DataCacheManager", iDataCacheManager, IDataCacheManager.class);
                this.m_ScriptEngine.pushJSScope((Object)basicScope);
                if (bl2) {
                    this.m_ScriptEngine.pushJSScope(section);
                }
                try {
                    boolean bl3 = true;
                    this.buildGroups(defaultPushContext);
                    if (script != null) {
                        boolean bl4 = bl3 = !Boolean.FALSE.equals(this.m_ScriptEngine.evaluate(script));
                    }
                    if (bl3) {
                        if (script2 != null) {
                            this.m_ScriptEngine.evaluate(script2);
                        }
                        this.renderDetails(defaultPushContext);
                        if (script3 != null) {
                            this.m_ScriptEngine.evaluate(script3);
                        }
                    } else {
                        m_Log.info((Object)("Section " + this.m_Section.getName() + " turned off by RenderIf script"));
                    }
                }
                finally {
                    if (bl2) {
                        this.m_ScriptEngine.popJSScope();
                    }
                    this.m_ScriptEngine.popJSScope();
                }
            }
            finally {
                this.m_RecordSource.dispose();
                this.m_RecordSource = null;
            }
        }
        finally {
            if (iResourceProvider2 != this.m_Report) {
                renderStack.pop();
            }
        }
        return this.m_DataSink.getRecordIndex() + 1;
    }

    protected boolean setupPaginator() {
        return true;
    }

    public Section getSection() {
        return this.m_Section;
    }

    public IResourceProvider getResourceProvider() {
        return this.m_Report;
    }

    public LogicalReport getLogicalReport() {
        return this.m_LogicalReport;
    }

    public IPaginator getPaginator() {
        return null;
    }

    public RawElement getRawElementByName(String string) {
        if (this.m_RawNameMap == null) {
            this.buildRawNameMap();
        }
        return (RawElement)this.m_RawNameMap.get(string);
    }

    public void dispose() {
    }

    protected void buildGroups(PushContext pushContext) throws DataException {
        Iterator<Group> iterator = this.m_Section.getGroupIterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Group group = iterator.next();
                String string = group.getSortOrder();
                String string2 = group.getGroupOn();
                if ("None".equals(string) && "None".equals(string2)) continue;
                String string3 = group.getGroupData();
                this.m_RecordSource.setSortField(group.getField(), string, string2, string3);
            }
            m_Log.debug((Object)"Sorting and grouping");
            this.m_RecordSource.sortAndGroup(pushContext);
        }
    }

    public Data getData() {
        return this.m_DataSink;
    }

    protected void renderDetails(PushContext pushContext) throws RenderException {
        this.m_LogicalRenderContext.pushScope(this);
        try {
            this.m_RecordSource.pushTo(pushContext, this.m_DataSink);
        }
        catch (Exception exception) {
            m_Log.error((Object)("renderDetails Data processing exception: " + String.valueOf(exception)), (Throwable)exception);
        }
        finally {
            this.m_LogicalRenderContext.popScope();
        }
    }

    public boolean renderSectionHeader() throws RenderException {
        SectionHeader sectionHeader;
        this.m_ScriptEngine.pushJSScope((Object)this.m_DataSink.getRecordScope());
        this.startOfPageSequence();
        this.startOfPage();
        if (this.m_Section.isShowSectionHeader() && (sectionHeader = this.m_Section.getSectionHeader()) != null && sectionHeader.isVisible()) {
            return this.renderChunk(sectionHeader, sectionHeader);
        }
        return false;
    }

    protected boolean renderPageHeader() throws RenderException {
        PageHeader pageHeader = this.m_Section.getPageHeader();
        if (pageHeader != null && pageHeader.isVisible()) {
            return this.renderElement(pageHeader, null);
        }
        return false;
    }

    public void renderGroupHeader(Group group, boolean bl) throws RenderException {
        GroupHeader groupHeader;
        if (group.isGroupHeaderVisible() && (groupHeader = group.getGroupHeader()) != null && groupHeader.isVisible()) {
            groupHeader.setHeaderNo(groupHeader.getHeaderNo() + 1);
            groupHeader.setRepeatNo(bl ? groupHeader.getRepeatNo() + 1 : 1);
            if (bl) {
                this.renderChunk(groupHeader, null);
            } else {
                this.renderChunk(groupHeader, groupHeader);
            }
        }
    }

    public void renderGroupFooter(Group group) throws RenderException {
        GroupHeader groupHeader = group.getGroupHeader();
        boolean bl = group.isGroupHeaderVisible() && groupHeader != null && groupHeader.isVisible();
        GroupFooter groupFooter = group.getGroupFooter();
        if (group.isGroupFooterVisible() && groupFooter != null && groupFooter.isVisible()) {
            groupFooter.setTableOfContents(bl && groupHeader != null && groupHeader.isTableOfContents());
            groupFooter.setFooterNo(groupFooter.getFooterNo() + 1);
            this.renderChunk(groupFooter, groupFooter);
        }
    }

    public boolean renderDetail(Section section) throws RenderException {
        Detail detail = section.getDetail();
        if (detail != null && detail.isVisible()) {
            return this.renderChunk(detail, detail);
        }
        return false;
    }

    protected boolean renderPageFooter() throws RenderException {
        PageFooter pageFooter = this.m_Section.getPageFooter();
        if (pageFooter != null && pageFooter.isVisible()) {
            return this.renderElement(pageFooter, null);
        }
        return false;
    }

    public boolean renderSectionFooter() throws RenderException {
        SectionFooter sectionFooter;
        SectionHeader sectionHeader = this.m_Section.getSectionHeader();
        boolean bl = false;
        if (this.m_Section.isShowSectionFooter() && (sectionFooter = this.m_Section.getSectionFooter()) != null && sectionFooter.isVisible()) {
            if (sectionHeader != null) {
                sectionFooter.setTableOfContents(sectionHeader.isTableOfContents());
            }
            bl = this.renderChunk(sectionFooter, sectionFooter);
        }
        this.m_ScriptEngine.popJSScope();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderChunk(Chunk chunk, RawElementHolder rawElementHolder) throws RenderException {
        boolean bl;
        Script script = chunk.getRenderIf();
        Script script2 = chunk.getOnRenderBegin();
        Script script3 = chunk.getOnRenderEnd();
        boolean bl2 = bl = Script.notEmpty(script) || Script.notEmpty(script2) || Script.notEmpty(script3);
        if (bl) {
            this.m_ScriptEngine.pushJSScope(chunk);
        }
        try {
            if (script != null && Boolean.FALSE.equals(this.m_ScriptEngine.evaluate(script))) {
                boolean bl3 = false;
                return bl3;
            }
            if (StreamedSectionRenderer.forceBefore(rawElementHolder)) {
                this.m_LogicalRenderContext.pageBreak(false);
            }
            IChunkRenderer iChunkRenderer = this.getChunkRenderer(chunk.getTagName());
            BodyPart bodyPart = null;
            if (iChunkRenderer != null) {
                if (PRE_TEST_FIXED_SIZE && !chunk.isGrowable() && !chunk.isShrinkable()) {
                    int n = chunk.getHeight();
                    this.m_LogicalRenderContext.ensureHeightAvailable(n);
                }
                try {
                    if (script2 != null) {
                        this.m_ScriptEngine.evaluate(script2);
                    }
                    if ((bodyPart = iChunkRenderer.render(this.m_LogicalRenderContext, chunk)) != null) {
                        this.m_LogicalRenderContext.prepareBodyPart(bodyPart);
                        if (script3 != null) {
                            this.m_ScriptEngine.define("javascript", "result", bodyPart);
                            this.m_ScriptEngine.evaluate(script3);
                            this.m_ScriptEngine.undefine("javascript", "result");
                        }
                    }
                    if (bl) {
                        this.m_ScriptEngine.popJSScope();
                        bl = false;
                    }
                    if (bodyPart != null) {
                        this.m_LogicalRenderContext.addBodyPart(bodyPart);
                    }
                }
                catch (RenderException renderException) {
                    m_Log.error((Object)("Render chunk: " + String.valueOf(renderException)));
                    JobLogging.exception(renderException);
                }
                catch (Exception exception) {
                    m_Log.error((Object)("Render failure: " + String.valueOf(exception)), (Throwable)exception);
                    JobLogging.exception(exception);
                }
            } else {
                m_Log.warn((Object)("No renderer for: " + chunk.getTagName()));
            }
            if (StreamedSectionRenderer.forceAfter(rawElementHolder)) {
                this.m_LogicalRenderContext.pageBreak(false);
            }
        }
        finally {
            if (bl) {
                this.m_ScriptEngine.popJSScope();
            }
        }
        return true;
    }

    protected IChunkRenderer getChunkRenderer(String string) {
        return m_ChunkRenderers.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderElement(RawModelElement rawModelElement, RawElementHolder rawElementHolder) throws RenderException {
        boolean bl;
        Script script = rawModelElement.getRenderIf();
        Script script2 = rawModelElement.getOnRenderBegin();
        Script script3 = rawModelElement.getOnRenderEnd();
        boolean bl2 = bl = Script.notEmpty(script) || Script.notEmpty(script2) || Script.notEmpty(script3);
        if (bl) {
            this.m_ScriptEngine.pushJSScope(rawModelElement);
        }
        try {
            ILogicalRenderer iLogicalRenderer;
            if (script != null && Boolean.FALSE.equals(this.m_ScriptEngine.evaluate(script))) {
                if (!(rawModelElement instanceof Chunk)) {
                    Empty empty = new Empty();
                    empty.setRaw(rawModelElement);
                    empty.setLeft(rawModelElement.getLeft());
                    empty.setTop(rawModelElement.getTop());
                    empty.setWidth(rawModelElement.getWidth());
                    this.m_LogicalRenderContext.addElement(empty);
                }
                boolean bl3 = false;
                return bl3;
            }
            if (StreamedSectionRenderer.forceBefore(rawElementHolder)) {
                this.m_LogicalRenderContext.pageBreak(false);
            }
            if (script2 != null) {
                this.m_ScriptEngine.evaluate(script2);
            }
            if ((iLogicalRenderer = this.m_RenderFactory.getLogicalRenderer(rawModelElement.getTagName())) != null) {
                try {
                    iLogicalRenderer.render(this.m_LogicalRenderContext, rawModelElement);
                }
                catch (RenderException renderException) {
                    m_Log.error((Object)("Render element: " + String.valueOf(renderException)));
                }
                catch (Exception exception) {
                    m_Log.error((Object)("Render failure: " + String.valueOf(exception)), (Throwable)exception);
                }
            } else {
                m_Log.warn((Object)("No renderer for: " + rawModelElement.getTagName()));
            }
            if (StreamedSectionRenderer.forceAfter(rawElementHolder)) {
                this.m_LogicalRenderContext.pageBreak(false);
            }
            if (script3 != null) {
                LogicalModelElement logicalModelElement = this.m_LogicalRenderContext.getLogicalForRaw(rawModelElement);
                if (logicalModelElement != null) {
                    this.m_ScriptEngine.define("javascript", "result", logicalModelElement);
                }
                this.m_ScriptEngine.evaluate(script3);
            }
        }
        finally {
            if (bl) {
                this.m_ScriptEngine.popJSScope();
            }
        }
        return true;
    }

    public void renderChildren(IRawElementHolder iRawElementHolder) throws RenderException {
        Iterator<RawModelElement> iterator = iRawElementHolder.getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = iterator.next();
            this.renderElement(rawModelElement, null);
        }
    }

    public void startOfPageSequence() throws RenderException {
        PageSequence pageSequence = this.m_LogicalRenderContext.addPageSequence(this.m_Section.isResetPageCount());
        pageSequence.setMasterName(this.m_Section.getPageSetup());
    }

    public void startOfPageSequence(boolean bl) throws RenderException {
        PageSequence pageSequence = this.m_LogicalRenderContext.addPageSequence(bl);
        pageSequence.setMasterName(this.m_Section.getPageSetup());
    }

    protected void startOfPage() throws RenderException {
        block10: {
            String string;
            this.m_LogicalRenderContext.addPage();
            SectionInvocation sectionInvocation = this.m_Section.getWatermark();
            if (sectionInvocation != null && StringUtil.notEmpty(string = sectionInvocation.getSectionName())) {
                try {
                    Object object;
                    Object object2;
                    Section section = null;
                    String string2 = sectionInvocation.getReportName();
                    if (StringUtil.isEmpty(string2)) {
                        section = this.m_Report.getSection(string);
                    } else {
                        object2 = RenderStack.current().getFile(string2);
                        object = RMLUtil.readRML((RMLFileObject)object2);
                        if (object != null) {
                            section = ((RawReport)object).getSection(string);
                        }
                    }
                    if (section != null) {
                        object2 = sectionInvocation.getDataSourceName();
                        object = new DataHolder((String)object2);
                        SectionEngine sectionEngine = new SectionEngine();
                        try {
                            PageSequence pageSequence;
                            LogicalReport logicalReport = null;
                            logicalReport = this instanceof PagedSectionRenderer ? sectionEngine.renderPaged(this.m_Report, section, (DataHolder)object) : sectionEngine.render(this.m_Report, section, (DataHolder)object);
                            if (logicalReport != null && logicalReport.getPageSequenceCount() > 0 && (pageSequence = logicalReport.getPageSequence(0)).getPageCount() > 0) {
                                Page page = pageSequence.getPage(0);
                                this.m_LogicalRenderContext.addWatermark(page);
                            }
                            break block10;
                        }
                        catch (Exception exception) {
                            m_Log.error((Object)("Exception rendering watermark: " + String.valueOf(exception)), (Throwable)exception);
                        }
                        break block10;
                    }
                    m_Log.error((Object)("Watermark section \"" + String.valueOf(sectionInvocation) + "\" not found"));
                }
                catch (IOException iOException) {
                    m_Log.error((Object)("Watermark section \"" + String.valueOf(sectionInvocation) + "\" not found : " + String.valueOf(iOException)), (Throwable)iOException);
                }
            }
        }
    }

    public void pageBreak(boolean bl) throws RenderException {
    }

    public void ensureHeightAvailable(int n) {
    }

    public int getRepeatGroupHeadersHeight() {
        return 0;
    }

    protected void renderRepeatGroupHeaders() {
    }

    protected void buildRawNameMap() {
        this.m_RawNameMap = new HashMap<String, RawModelElement>();
        this.addToRawMap(this.m_Section.getPageHeader());
        this.addToRawMap(this.m_Section.getSectionHeader());
        this.addToRawMap(this.m_Section.getSectionFooter());
        this.addToRawMap(this.m_Section.getPageFooter());
        Iterator<Group> iterator = this.m_Section.getGroupIterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            this.addToRawMap(group.getGroupHeader());
            this.addToRawMap(group.getGroupFooter());
        }
        this.addToRawMap(this.m_Section.getDetail());
    }

    protected void addToRawMap(BasicRawElementHolder basicRawElementHolder) {
        Iterator<RawModelElement> iterator = basicRawElementHolder.getRawElementIterator();
        while (iterator.hasNext()) {
            String string;
            RawModelElement rawModelElement = iterator.next();
            if (rawModelElement instanceof RawElement && !this.m_RawNameMap.containsKey(string = ((RawElement)rawModelElement).getName())) {
                this.m_RawNameMap.put(string, rawModelElement);
            }
            if (!(rawModelElement instanceof BasicRawElementHolder)) continue;
            this.addToRawMap((BasicRawElementHolder)rawModelElement);
        }
    }

    protected static boolean forceBefore(RawElementHolder rawElementHolder) {
        if (rawElementHolder == null) {
            return false;
        }
        String string = rawElementHolder.getForceNewPage();
        boolean bl = false;
        if (string != null) {
            bl = string.equals("Before") || string.equals("Before and After");
        }
        return bl;
    }

    protected static boolean forceAfter(RawElementHolder rawElementHolder) {
        if (rawElementHolder == null) {
            return false;
        }
        String string = rawElementHolder.getForceNewPage();
        boolean bl = false;
        if (string != null) {
            bl = string.equals("After") || string.equals("Before and After");
        }
        return bl;
    }

    static {
        m_ChunkRenderers.put("detail", new DetailRenderer());
        m_ChunkRenderers.put("section-header", new SectionHeaderRenderer());
        m_ChunkRenderers.put("section-footer", new SectionFooterRenderer());
        m_ChunkRenderers.put("group-header", new GroupHeaderRenderer());
        m_ChunkRenderers.put("group-footer", new GroupFooterRenderer());
        PRE_TEST_FIXED_SIZE = System.getProperty("elx.report.pretest-fixed-size") != null;
    }

    public class RendererWrapper
    implements IRenderer {
        @Override
        public void pageBreak() throws RenderException {
            StreamedSectionRenderer.this.m_LogicalRenderContext.pageBreak(false);
        }

        @Override
        public void pageBreak(boolean bl) throws RenderException {
            StreamedSectionRenderer.this.m_LogicalRenderContext.pageBreak(bl);
        }

        @Override
        public RawReport getRawReport() {
            return StreamedSectionRenderer.this.m_LogicalRenderer.getRawReport();
        }

        @Override
        public LogicalReport getLogicalReport() {
            return StreamedSectionRenderer.this.m_LogicalRenderer.getLogicalReport();
        }

        @Override
        public RawElement getRawElementByName(String string) {
            return StreamedSectionRenderer.this.getRawElementByName(string);
        }

        @Override
        public LogicalElement getLogicalElementByName(String string) {
            RawElement rawElement = StreamedSectionRenderer.this.getRawElementByName(string);
            if (rawElement != null) {
                return (LogicalElement)StreamedSectionRenderer.this.m_LogicalRenderContext.getLogicalForRaw(rawElement);
            }
            return null;
        }

        @Override
        public void exec(String string, String string2, String string3) {
            StreamedSectionRenderer.this.m_LogicalRenderer.eval(string, string2, string3);
        }

        @Override
        public Object eval(String string, String string2, String string3) {
            return StreamedSectionRenderer.this.m_LogicalRenderer.eval(string, string2, string3);
        }

        @Override
        public MimeType getMimeType() {
            return StreamedSectionRenderer.this.m_LogicalRenderContext.getMimeType();
        }
    }
}

