/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.TreePageListener;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Detail;
import com.elixirtech.report2.logical.model.GroupFooter;
import com.elixirtech.report2.logical.model.GroupHeader;
import com.elixirtech.report2.logical.model.IBody;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.Reference;
import com.elixirtech.report2.logical.model.ReportFooter;
import com.elixirtech.report2.logical.model.ReportHeader;
import com.elixirtech.report2.logical.model.TOCList;
import com.elixirtech.report2.raw.model.PageSetup;
import java.util.Stack;

public class TreeLogicalRenderContext
extends LogicalRenderContext {
    private Stack<Memento> m_Stack = new Stack();
    protected int m_PageCount = 0;
    protected boolean m_UseSamePageSequence = false;

    public TreeLogicalRenderContext(PageListener pageListener, Result result) {
        super(pageListener, result);
    }

    @Override
    public PageListener wrapPageListener(PageListener pageListener) {
        return new TreePageListener(pageListener);
    }

    @Override
    public BodyPart addBodyPart(BodyPart bodyPart) throws RenderException {
        if (this.isTOC(bodyPart)) {
            if (bodyPart instanceof ReportHeader) {
                TOCList tOCList = this.getTOCList();
                this.m_CurrentHolder = tOCList;
                Reference reference = new Reference();
                reference.setTitle(((ReportHeader)bodyPart).getTOCTitle());
                String string = this.nextPageId();
                reference.setRefId(string);
                bodyPart.setId(string);
                tOCList.addLogicalElement(reference);
                this.doPush(bodyPart);
            } else if (bodyPart instanceof GroupHeader) {
                TOCList tOCList = this.getTOCList();
                this.m_CurrentHolder = tOCList;
                Reference reference = new Reference();
                reference.setTitle(((GroupHeader)bodyPart).getTOCTitle());
                String string = this.nextPageId();
                reference.setRefId(string);
                bodyPart.setId(string);
                tOCList.addLogicalElement(reference);
                this.doPush(bodyPart);
            } else if (bodyPart instanceof Detail) {
                TOCList tOCList = this.getTOCList();
                this.m_CurrentHolder = tOCList;
                Reference reference = new Reference();
                reference.setTitle(((Detail)bodyPart).getTOCTitle());
                String string = this.nextPageId();
                reference.setRefId(string);
                bodyPart.setId(string);
                tOCList.addLogicalElement(reference);
                this.doAddBodyPart(bodyPart);
            } else if (bodyPart instanceof GroupFooter) {
                this.doPop(bodyPart);
            } else if (bodyPart instanceof ReportFooter) {
                this.doPop(bodyPart);
            }
            this.resetTOC(bodyPart);
        } else {
            this.doAddBodyPart(bodyPart);
        }
        this.m_RawToLogical.clear();
        return bodyPart;
    }

    private void doPush(BodyPart bodyPart) {
        this.doAddBodyPart(bodyPart);
        this.pushPage();
    }

    private void doPop(BodyPart bodyPart) {
        this.popPage();
        this.doAddBodyPart(bodyPart);
    }

    @Override
    public PageSequence addPageSequence(boolean bl) throws RenderException {
        if (this.m_CurrentPageSequence == null) {
            return super.addPageSequence(bl);
        }
        this.m_UseSamePageSequence = true;
        return this.m_CurrentPageSequence;
    }

    @Override
    public Page addPage() throws RenderException {
        if (this.m_UseSamePageSequence) {
            this.m_UseSamePageSequence = false;
            return this.m_CurrentPage;
        }
        ++this.m_PageCount;
        this.m_CurrentPage = new Page();
        this.m_CurrentBody = null;
        this.m_CurrentColumns = null;
        this.m_PageListener.addPage(this.m_CurrentPage);
        RenderStack renderStack = RenderStack.current();
        PageSetup pageSetup = renderStack.getPageSetup(this.m_CurrentPageSequence.getMasterName());
        this.m_CurrentPage.setPageSetup(pageSetup);
        return this.m_CurrentPage;
    }

    @Override
    public void endReport() {
        this.m_CurrentPage = null;
        super.endReport();
    }

    protected String nextPageId() {
        return "tree:page:" + this.m_PageCount;
    }

    protected void pushPage() throws RenderException {
        this.m_Stack.push(new Memento());
        this.addPage();
    }

    protected void popPage() {
        Memento memento = this.m_Stack.pop();
        memento.restore();
    }

    protected TOCList getTOCList() {
        BodyPart bodyPart;
        int n;
        if (this.m_CurrentBody != null && (n = this.m_CurrentBody.getBodyPartCount()) > 0 && (bodyPart = this.m_CurrentBody.getBodyPart(n - 1)) instanceof TOCList) {
            return (TOCList)bodyPart;
        }
        TOCList tOCList = new TOCList();
        this.doAddBodyPart(tOCList);
        return tOCList;
    }

    private boolean isTOC(BodyPart bodyPart) {
        if (bodyPart instanceof ReportHeader) {
            return ((ReportHeader)bodyPart).isTableOfContents();
        }
        if (bodyPart instanceof GroupHeader) {
            return ((GroupHeader)bodyPart).isTableOfContents();
        }
        if (bodyPart instanceof Detail) {
            return ((Detail)bodyPart).isTableOfContents();
        }
        if (bodyPart instanceof GroupFooter) {
            return ((GroupFooter)bodyPart).isTableOfContents();
        }
        if (bodyPart instanceof ReportFooter) {
            return ((ReportFooter)bodyPart).isTableOfContents();
        }
        return false;
    }

    private void resetTOC(BodyPart bodyPart) {
        if (bodyPart instanceof ITOCElement) {
            ((ITOCElement)((Object)bodyPart)).setTableOfContents(false);
        } else if (bodyPart instanceof GroupFooter) {
            ((GroupFooter)bodyPart).setTableOfContents(false);
        } else if (bodyPart instanceof ReportFooter) {
            ((ReportFooter)bodyPart).setTableOfContents(false);
        }
    }

    private class Memento {
        public PageSequence pageSequence;
        public Page page;
        public IBody body;
        public Columns columns;
        public ILogicalElementHolder holder;

        public Memento() {
            this.store();
        }

        public void store() {
            this.pageSequence = TreeLogicalRenderContext.this.m_CurrentPageSequence;
            this.page = TreeLogicalRenderContext.this.m_CurrentPage;
            this.body = TreeLogicalRenderContext.this.m_CurrentBody;
            this.columns = TreeLogicalRenderContext.this.m_CurrentColumns;
            this.holder = TreeLogicalRenderContext.this.m_CurrentHolder;
            TreeLogicalRenderContext.this.m_CurrentHolder = null;
        }

        public void restore() {
            TreeLogicalRenderContext.this.m_CurrentPageSequence = this.pageSequence;
            TreeLogicalRenderContext.this.m_CurrentPage = this.page;
            TreeLogicalRenderContext.this.m_CurrentBody = this.body;
            TreeLogicalRenderContext.this.m_CurrentColumns = this.columns;
            TreeLogicalRenderContext.this.m_CurrentHolder = this.holder;
        }
    }
}

