/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.callback;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.callback.Callback;
import com.elixirtech.report2.logical.callback.CallbackContext;
import com.elixirtech.report2.logical.callback.html2.HTMLCallback2;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;

public class HTMLCallback
implements Callback {
    public static final String START = "${";
    public static final String END = "}";
    private static final String DESIGNER_SAMPLE = "<html><body>HTML</body></html>";
    private static final String BASE = "com/elixirtech/icons/standardIcons/";
    private JLabel m_Loading;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(HTMLCallback.class);

    @Override
    public void render(CallbackElement callbackElement, CallbackContext callbackContext) {
        if (HTMLCallback2.isEnabledJ()) {
            HTMLCallback2 hTMLCallback2 = new HTMLCallback2();
            hTMLCallback2.render(callbackElement, callbackContext);
        } else {
            this.render1(callbackElement, callbackContext);
        }
    }

    public void render1(CallbackElement callbackElement, CallbackContext callbackContext) {
        Dimension dimension = callbackContext.getSize();
        int n = dimension.width / 20;
        int n2 = dimension.height / 20;
        final RenderStack renderStack = RenderStack.current();
        final RenderContainer renderContainer = RenderContainer.current();
        try {
            Object object;
            Serializable serializable;
            int n3 = callbackElement.getImageResolution();
            if (n3 < 72) {
                n3 = 72;
            }
            double d = (double)n3 / 72.0;
            BufferedImage bufferedImage = new BufferedImage((int)((double)n * d), (int)((double)n2 * d), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.scale(d, d);
            graphics2D.setClip(0, 0, n, n2);
            Graphics2D graphics2D2 = graphics2D;
            String string = callbackElement.getBackgroundColor();
            int n4 = Color.white.getRGB();
            if (StringUtil.notEmpty(string)) {
                serializable = StandardColor.lookup(string, (Color)null);
                if (serializable != null) {
                    graphics2D.setColor((Color)serializable);
                    graphics2D.fillRect(0, 0, n + 1, n2 + 1);
                    n4 = ((Color)serializable).getRGB();
                }
            } else {
                serializable = new Color(0, 0, 0, 1);
                graphics2D.setColor((Color)serializable);
                graphics2D.fillRect(0, 0, n + 1, n2 + 1);
                graphics2D.setColor(Color.BLACK);
                n4 = ((Color)serializable).getRGB();
            }
            serializable = callbackElement.getControlSource();
            String string2 = ((ControlSource)serializable).getType();
            String string3 = null;
            String string4 = null;
            if ("URL".equals(string2)) {
                string3 = ArgumentMap.substitute(((ControlSource)serializable).getURL(), new ReportSubstitution());
            } else {
                string4 = String.valueOf(ControlSourceProcessor.getData((ControlSource)serializable));
                string4 = callbackContext.substitute(string4, START, END);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                if (string3 != null) {
                    this.renderURL(graphics2D2, n, n2, string3);
                } else {
                    this.renderText(graphics2D2, n, n2, string4);
                }
            } else {
                object = string3;
                String string5 = string4;
                SwingUtilities.invokeAndWait(new Runnable(){
                    final /* synthetic */ String val$localURL;
                    final /* synthetic */ Graphics2D val$g2;
                    final /* synthetic */ int val$w;
                    final /* synthetic */ int val$h;
                    final /* synthetic */ String val$localText;
                    {
                        this.val$localURL = string;
                        this.val$g2 = graphics2D;
                        this.val$w = n;
                        this.val$h = n2;
                        this.val$localText = string2;
                    }

                    @Override
                    public void run() {
                        boolean bl = false;
                        if (RenderStack.current() == null) {
                            RenderStack.install(renderStack);
                            RenderContainer.install(renderContainer);
                            bl = true;
                        }
                        try {
                            if (this.val$localURL != null) {
                                HTMLCallback.this.renderURL(this.val$g2, this.val$w, this.val$h, this.val$localURL);
                            } else {
                                HTMLCallback.this.renderText(this.val$g2, this.val$w, this.val$h, this.val$localText);
                            }
                        }
                        finally {
                            if (bl) {
                                RenderStack.release();
                                RenderContainer.release();
                            }
                        }
                    }
                });
            }
            graphics2D.dispose();
            if (callbackElement.isShrinkable()) {
                int n5;
                m_Log.debug((Object)"Checking for shrinkable HTML");
                object = new int[bufferedImage.getWidth()];
                for (n5 = bufferedImage.getHeight(); n5 > 0 && this.isEmpty(n4, bufferedImage, (int[])object, n5 - 1); --n5) {
                }
                if (n5 < bufferedImage.getHeight()) {
                    m_Log.info((Object)("Shrinking HTML Image from " + bufferedImage.getHeight() + " to " + n5));
                    bufferedImage = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), n5);
                    callbackContext.setHeight((int)((double)(n5 * 20) / d));
                }
            }
            callbackContext.setImage(bufferedImage);
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }

    private void renderURL(Graphics2D graphics2D, int n, int n2, String string) {
        try {
            JEditorPane jEditorPane = new JEditorPane();
            MyHTMLEditorKit myHTMLEditorKit = new MyHTMLEditorKit();
            jEditorPane.setEditorKit(myHTMLEditorKit);
            jEditorPane.setPage(string);
            jEditorPane.setBounds(0, 0, n, n2);
            View view = jEditorPane.getUI().getRootView(jEditorPane);
            view.paint(graphics2D, new Rectangle(0, 0, n, n2));
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }

    private void renderText(Graphics2D graphics2D, int n, int n2, String string) {
        try {
            JEditorPane jEditorPane = new JEditorPane();
            MyHTMLEditorKit myHTMLEditorKit = new MyHTMLEditorKit();
            jEditorPane.setEditorKit(myHTMLEditorKit);
            StringReader stringReader = new StringReader(string);
            Document document = myHTMLEditorKit.createDefaultDocument();
            myHTMLEditorKit.read(stringReader, document, 0);
            jEditorPane.setDocument(document);
            jEditorPane.setBounds(0, 0, n, n2);
            View view = jEditorPane.getUI().getRootView(jEditorPane);
            view.paint(graphics2D, new Rectangle(0, 0, n, n2));
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }

    private boolean isEmpty(int n, BufferedImage bufferedImage, int[] nArray, int n2) {
        bufferedImage.getRGB(0, n2, nArray.length, 1, nArray, 0, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }

    @Override
    public void renderDesign(CallbackElement callbackElement, Graphics2D graphics2D, Rectangle rectangle) {
        Object object;
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Object object2 = callbackElement.getCachedRender();
        if (object2 == null) {
            this.drawLoading(graphics2D, rectangle);
            callbackElement.setCachedRender(Boolean.FALSE);
            new CacheLoader(callbackElement, rectangle, null);
        } else if (object2 instanceof CachedRender && (((BufferedImage)(object = ((CachedRender)object2).image)).getWidth() != rectangle.width / 20 || ((BufferedImage)object).getHeight() != rectangle.height / 20)) {
            this.drawLoading(graphics2D, rectangle);
            callbackElement.setCachedRender(Boolean.FALSE);
            new CacheLoader(callbackElement, rectangle, ((CachedRender)object2).pane);
        }
        if (object2 instanceof CachedRender) {
            object = graphics2D.getClip();
            graphics2D.clip(rectangle);
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.scale(20.0, 20.0);
            graphics2D.drawImage((Image)((CachedRender)object2).image, 0, 0, null);
            graphics2D.scale(0.05, 0.05);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            graphics2D.setClip((Shape)object);
        }
    }

    protected void drawLoading(Graphics2D graphics2D, Rectangle rectangle) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.scale(20.0, 20.0);
        this.getLoading().paint(graphics2D);
        graphics2D.scale(0.05, 0.05);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setClip(shape);
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    private JLabel getLoading() {
        if (this.m_Loading == null) {
            ImageIcon imageIcon = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL uRL = classLoader.getResource("com/elixirtech/icons/standardIcons/new.png");
                BufferedImage bufferedImage = ImageIO.read(uRL);
                if (bufferedImage != null) {
                    imageIcon = new ImageIcon(bufferedImage);
                }
            }
            catch (Exception exception) {
                this.m_Loading = null;
            }
            this.m_Loading = new JLabel("HTML Loading...", imageIcon, 2);
            this.m_Loading.setSize(this.m_Loading.getPreferredSize());
        }
        return this.m_Loading;
    }

    private static class MyHTMLEditorKit
    extends HTMLEditorKit {
        private BasicHTMLViewFactory m_BasicViewFactory = new BasicHTMLViewFactory();

        private MyHTMLEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            HTMLDocument hTMLDocument = (HTMLDocument)super.createDefaultDocument();
            hTMLDocument.setAsynchronousLoadPriority(-1);
            hTMLDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            return hTMLDocument;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.m_BasicViewFactory;
        }
    }

    private static class CacheLoader
    extends Thread {
        private CallbackElement m_Element;
        private JEditorPane m_Pane;
        private Rectangle m_Rectangle;
        private ControlSource m_ControlSource;
        private String m_CsrcType;

        public CacheLoader(CallbackElement callbackElement, Rectangle rectangle, JEditorPane jEditorPane) {
            this.m_Element = callbackElement;
            this.m_Pane = jEditorPane;
            this.m_Rectangle = new Rectangle(0, 0, rectangle.width / 20, rectangle.height / 20);
            this.m_ControlSource = this.m_Element.getControlSource();
            this.m_CsrcType = this.m_ControlSource.getType();
            if ("URL".equals(this.m_CsrcType) && jEditorPane == null) {
                this.start();
            } else {
                this.run();
            }
        }

        @Override
        public void run() {
            try {
                Object object;
                Object object2;
                Object object3;
                JEditorPane jEditorPane = null;
                if (this.m_Pane != null) {
                    jEditorPane = this.m_Pane;
                } else {
                    jEditorPane = new JEditorPane();
                    object3 = new MyHTMLEditorKit();
                    jEditorPane.setEditorKit((EditorKit)object3);
                    if ("Literal".equals(this.m_CsrcType)) {
                        object2 = new StringReader(this.m_ControlSource.getText());
                        object = ((HTMLEditorKit)object3).createDefaultDocument();
                        ((HTMLEditorKit)object3).read((Reader)object2, (Document)object, 0);
                        jEditorPane.setDocument((Document)object);
                    } else if ("URL".equals(this.m_CsrcType)) {
                        object2 = ArgumentMap.getDefaultString(this.m_ControlSource.getURL());
                        jEditorPane.setPage((String)object2);
                    } else {
                        object2 = new StringReader(HTMLCallback.DESIGNER_SAMPLE);
                        object = ((HTMLEditorKit)object3).createDefaultDocument();
                        ((HTMLEditorKit)object3).read((Reader)object2, (Document)object, 0);
                        jEditorPane.setDocument((Document)object);
                    }
                }
                jEditorPane.setBounds(0, 0, this.m_Rectangle.width, this.m_Rectangle.height);
                object3 = jEditorPane.getUI().getRootView(jEditorPane);
                object2 = new BufferedImage(this.m_Rectangle.width, this.m_Rectangle.height, 2);
                object = ((BufferedImage)object2).createGraphics();
                ((Graphics)object).clipRect(0, 0, this.m_Rectangle.width, this.m_Rectangle.height);
                ((View)object3).paint((Graphics)object, new Rectangle(0, 0, this.m_Rectangle.width, this.m_Rectangle.height));
                ((Graphics)object).dispose();
                this.m_Element.setCachedRender(new CachedRender((BufferedImage)object2, jEditorPane));
                this.m_Element.getChunk().repaint();
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Can't render HTML: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }

    private static class CachedRender {
        public BufferedImage image;
        public JEditorPane pane;

        public CachedRender(BufferedImage bufferedImage, JEditorPane jEditorPane) {
            this.image = bufferedImage;
            this.pane = jEditorPane;
        }
    }

    private static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private BasicHTMLViewFactory() {
        }

        @Override
        public View create(Element element) {
            View view = super.create(element);
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }
    }
}

