/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.callback;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.callback.Callback;
import com.elixirtech.report2.logical.callback.CallbackContext;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.rtf.RtfGraphicsWalker;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RTFCallback2
implements Callback {
    public static final String START_RTF = "$\\{";
    public static final String END_RTF = "\\}";
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RTFCallback2.class);

    @Override
    public void render(CallbackElement callbackElement, CallbackContext callbackContext) {
        Dimension dimension = callbackContext.getSize();
        int n = dimension.width / 20;
        int n2 = dimension.height / 20;
        if (n <= 0 || n2 <= 0) {
            return;
        }
        try {
            Object object;
            ControlSource controlSource = callbackElement.getControlSource();
            Object object2 = ControlSourceProcessor.getData(controlSource);
            String string = String.valueOf(object2);
            string = callbackContext.substitute(string, START_RTF, END_RTF);
            RtfGroup rtfGroup = null;
            if (callbackElement.isGrowable() || callbackElement.isShrinkable()) {
                rtfGroup = this.getRoot(string);
                object = new BufferedImage(1, 1, 2);
                Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                float f = this.getHeight(graphics2D, rtfGroup, n);
                graphics2D.dispose();
                ((Image)object).flush();
                if (f > (float)n2 && callbackElement.isGrowable()) {
                    n2 = (int)Math.ceil(f);
                    callbackContext.setHeight(n2 * 20);
                } else if (f < (float)n2 && callbackElement.isShrinkable()) {
                    n2 = (int)Math.ceil(f);
                    callbackContext.setHeight(n2 * 20);
                }
            }
            if (callbackContext.showAsImage()) {
                int n3;
                if (rtfGroup == null) {
                    rtfGroup = this.getRoot(string);
                }
                if ((n3 = callbackElement.getImageResolution()) < 72) {
                    n3 = 72;
                }
                int n4 = n * n3 / 72;
                int n5 = n2 * n3 / 72;
                BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics2D.clipRect(0, 0, n4, n5);
                graphics2D.scale((double)n3 / 72.0, (double)n3 / 72.0);
                Rectangle rectangle = new Rectangle(0, 0, n, n2);
                RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle, graphics2D);
                rtfGroup.walk(rtfGraphicsWalker);
                graphics2D.dispose();
                bufferedImage.flush();
                callbackContext.setImage(bufferedImage);
            } else {
                object = callbackContext.getGlint();
                object.drawRTF(0, 0, n * 20, n2 * 20, string);
                object.flush();
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)exception.toString());
            exception.printStackTrace();
        }
    }

    private RtfGroup getRoot(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        RtfReader rtfReader = new RtfReader(byteArrayInputStream);
        return rtfReader.getTreeRoot();
    }

    private float getHeight(Graphics2D graphics2D, RtfGroup rtfGroup, int n) {
        Rectangle rectangle = new Rectangle(0, 0, n, Integer.MAX_VALUE);
        RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle, graphics2D, true);
        rtfGroup.walk(rtfGraphicsWalker);
        return rtfGraphicsWalker.getBottom();
    }

    @Override
    public void renderDesign(CallbackElement callbackElement, Graphics2D graphics2D, Rectangle rectangle) {
        Object object;
        Object object2;
        Object object3;
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        ControlSource controlSource = callbackElement.getControlSource();
        try {
            object3 = callbackElement.getCachedRender();
            if (object3 instanceof RtfGroup) {
                Shape shape = graphics2D.getClip();
                graphics2D.clip(rectangle);
                graphics2D.scale(20.0, 20.0);
                Rectangle rectangle2 = new Rectangle(rectangle.x / 20, rectangle.y / 20, rectangle.width / 20, rectangle.height / 20);
                RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle2, graphics2D);
                ((RtfGroup)object3).walk(rtfGraphicsWalker);
                graphics2D.scale(0.05, 0.05);
                graphics2D.setClip(shape);
                return;
            }
            if (object3 == null) {
                Object object4;
                Object object5;
                object2 = controlSource.getType().intern();
                object = null;
                if ("URL" == object2) {
                    object = URLLoader.getInputStream(controlSource.getURL());
                } else {
                    object5 = controlSource.getText();
                    object4 = ((String)object5).getBytes("UTF-8");
                    object = new ByteArrayInputStream((byte[])object4);
                }
                if (object != null) {
                    object5 = new RtfReader((InputStream)object);
                    object4 = ((RtfReader)object5).getTreeRoot();
                    ((InputStream)object).close();
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(rectangle);
                    graphics2D.scale(20.0, 20.0);
                    Rectangle rectangle3 = new Rectangle(rectangle.x / 20, rectangle.y / 20, rectangle.width / 20, rectangle.height / 20);
                    RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle3, graphics2D);
                    ((RtfGroup)object4).walk(rtfGraphicsWalker);
                    callbackElement.setCachedRender(object4);
                    graphics2D.scale(0.05, 0.05);
                    graphics2D.setClip(shape);
                    return;
                }
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Can't renderDesign: " + String.valueOf(exception)), (Throwable)exception);
            callbackElement.setCachedRender(exception);
        }
        object3 = controlSource.getDisplayNameValue();
        graphics2D.setColor(Color.black);
        object2 = graphics2D.getClip();
        graphics2D.clip(rectangle);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.scale(20.0, 20.0);
        object = new Font("SansSerif", 0, 12);
        graphics2D.setFont((Font)object);
        int n = 0;
        int n2 = 0;
        graphics2D.drawString("RTF: " + (String)object3, n, n2 += graphics2D.getFontMetrics().getAscent());
        graphics2D.scale(0.05, 0.05);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setClip((Shape)object2);
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

