/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.report2.logical.model.ByteArray;
import com.elixirtech.report2.logical.model.LogicalModelElementSAXOut;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import org.xml.sax.helpers.AttributesImpl;

public class ByteArraySAXOut
extends LogicalModelElementSAXOut {
    @Override
    public String getTagName() {
        return "bytes";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        ByteArray byteArray = (ByteArray)iBean;
        try {
            byteArray.setText(ByteUtil.encodeBase64(byteArray.getRawBytes()));
        }
        catch (Exception exception) {
            iSAXOut.getLog().error((Object)"ByteArray pre-output unable to encode bytes");
            byteArray.setText("");
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(byteArray, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, byteArray);
        this.outputChildren(iSAXOut, byteArray);
        iSAXOut.characters(byteArray.getText());
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        ByteArray byteArray = (ByteArray)iBean;
        try {
            byteArray.setText(ByteUtil.encodeBase64(byteArray.getRawBytes()));
        }
        catch (Exception exception) {
            iSAXOut.getLog().error((Object)"ByteArray pre-output unable to encode bytes");
            byteArray.setText("");
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(byteArray, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, byteArray);
        this.outputChildren(iSAXOut, byteArray);
        iSAXOut.characters(byteArray.getText());
        iSAXOut.endElement(string);
    }

    public void buildAttributes(ByteArray byteArray, AttributesImpl attributesImpl) {
        attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "space", "xml:space", "CDATA", "preserve");
        super.buildAttributes(byteArray, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, ByteArray byteArray) {
        super.outputChild(iSAXOut, byteArray);
    }

    public void outputChildren(ISAXOut iSAXOut, ByteArray byteArray) {
        super.outputChildren(iSAXOut, byteArray);
    }
}

