/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LogicalReport
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LogicalReport.class);
    protected boolean m_IsLoaded;
    private Map m_RenderDetails;
    protected Map<String, PageSetup> m_PageSetup = new HashMap<String, PageSetup>();
    protected Map<String, Parameter> m_Parameter = new HashMap<String, Parameter>();
    protected List<PageSequence> m_PageSequence = new ArrayList<PageSequence>();
    protected String m_Phase;
    protected String m_Caption;
    protected String m_ModelName;
    protected String m_Name;
    protected Locale m_Locale;
    protected String m_RecordSource;
    protected String m_PageHeaderFlags;
    protected String m_PageFooterFlags;
    protected int m_Width;
    protected int m_RecordCount;
    protected String m_XmlBase;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "report";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        for (IBean iBean : this.m_PageSetup.values()) {
            iBean.loaded();
        }
        for (IBean iBean : this.m_Parameter.values()) {
            iBean.loaded();
        }
        Iterator<IBean> iterator = this.m_PageSequence.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_PageSetup != null) {
            for (IBean iBean : this.m_PageSetup.values()) {
                iBean.dispose();
            }
        }
        this.m_PageSetup = null;
        if (this.m_Parameter != null) {
            for (IBean iBean : this.m_Parameter.values()) {
                iBean.dispose();
            }
        }
        this.m_Parameter = null;
        if (this.m_PageSequence != null) {
            Iterator<IBean> iterator = this.m_PageSequence.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_PageSequence = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Phase != null) {
            element.setAttribute("Phase", this.m_Phase);
        }
        if (this.m_Caption != null) {
            element.setAttribute("Caption", this.m_Caption);
        }
        if (this.m_ModelName != null) {
            element.setAttribute("Model_Name", this.m_ModelName);
        }
        if (this.m_Name != null) {
            element.setAttribute("Name", this.m_Name);
        }
        if (this.m_Locale != null) {
            element.setAttribute("Locale", this.m_Locale.toString());
        }
        if (this.m_RecordSource != null) {
            element.setAttribute("Record_Source", this.m_RecordSource);
        }
        if (this.m_PageHeaderFlags != null) {
            element.setAttribute("Page_Header", this.m_PageHeaderFlags);
        }
        if (this.m_PageFooterFlags != null) {
            element.setAttribute("Page_Footer", this.m_PageFooterFlags);
        }
        element.setAttribute("Width", Integer.toString(this.m_Width));
        element.setAttribute("RecordCount", Integer.toString(this.m_RecordCount));
        if (this.m_XmlBase != null) {
            element.setAttribute("base", this.m_XmlBase, Namespace.XML_NAMESPACE);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        LogicalReport logicalReport = (LogicalReport)this.getClass().newInstance();
        logicalReport.m_Phase = this.m_Phase;
        logicalReport.m_Caption = this.m_Caption;
        logicalReport.m_ModelName = this.m_ModelName;
        logicalReport.m_Name = this.m_Name;
        logicalReport.m_Locale = this.m_Locale;
        logicalReport.m_RecordSource = this.m_RecordSource;
        logicalReport.m_PageHeaderFlags = this.m_PageHeaderFlags;
        logicalReport.m_PageFooterFlags = this.m_PageFooterFlags;
        logicalReport.m_Width = this.m_Width;
        logicalReport.m_RecordCount = this.m_RecordCount;
        logicalReport.m_XmlBase = this.m_XmlBase;
        return logicalReport;
    }

    public void setRenderDetailsMap(Map map) {
        this.m_RenderDetails = map;
    }

    public RenderDetails getRenderDetails(String string) {
        return (RenderDetails)this.m_RenderDetails.get(string);
    }

    public void addPageSetup(PageSetup pageSetup) {
        String string = pageSetup.getName();
        this.m_PageSetup.put(string, pageSetup);
    }

    public void removePageSetup(PageSetup pageSetup) {
        String string = pageSetup.getName();
        this.m_PageSetup.remove(string);
    }

    public PageSetup getPageSetup(String string) {
        return this.m_PageSetup.get(string);
    }

    public Iterator<PageSetup> getPageSetupIterator() {
        return this.m_PageSetup.values().iterator();
    }

    public int getPageSetupCount() {
        return this.m_PageSetup.size();
    }

    public Map<String, PageSetup> getPageSetupMap() {
        return this.m_PageSetup;
    }

    public void setPageSetupMap(Map<String, PageSetup> map) {
        this.m_PageSetup = map;
    }

    public void addParameter(Parameter parameter) {
        String string = parameter.getKey();
        this.m_Parameter.put(string, parameter);
    }

    public void removeParameter(Parameter parameter) {
        String string = parameter.getKey();
        this.m_Parameter.remove(string);
    }

    public Parameter getParameter(String string) {
        return this.m_Parameter.get(string);
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameter.values().iterator();
    }

    public int getParameterCount() {
        return this.m_Parameter.size();
    }

    public Map<String, Parameter> getParameterMap() {
        return this.m_Parameter;
    }

    public void setParameterMap(Map<String, Parameter> map) {
        this.m_Parameter = map;
    }

    public void addPageSequence(PageSequence pageSequence) {
        this.m_PageSequence.add(pageSequence);
    }

    public void addPageSequence(int n, PageSequence pageSequence) {
        this.m_PageSequence.add(n, pageSequence);
    }

    public void addAllPageSequences(Collection<PageSequence> collection) {
        this.m_PageSequence.addAll(collection);
    }

    public int indexOfPageSequence(PageSequence pageSequence) {
        return this.m_PageSequence.indexOf(pageSequence);
    }

    public void removePageSequence(PageSequence pageSequence) {
        this.m_PageSequence.remove(pageSequence);
    }

    public void removeAllPageSequences(Collection collection) {
        this.m_PageSequence.removeAll(collection);
    }

    public void removeAllPageSequences() {
        this.m_PageSequence.clear();
    }

    public PageSequence getPageSequence(int n) {
        return this.m_PageSequence.get(n);
    }

    public int getPageSequenceCount() {
        return this.m_PageSequence.size();
    }

    public Iterator<PageSequence> getPageSequenceIterator() {
        return this.m_PageSequence.iterator();
    }

    public List<PageSequence> getPageSequenceList() {
        return this.m_PageSequence;
    }

    public void setPageSequenceList(List<PageSequence> list) {
        this.m_PageSequence = list;
    }

    public String getPhase() {
        return this.m_Phase;
    }

    public void setPhase(String string) {
        this.m_Phase = string;
    }

    public String getCaption() {
        return this.m_Caption;
    }

    public void setCaption(String string) {
        this.m_Caption = string;
    }

    public String getModelName() {
        return this.m_ModelName;
    }

    public void setModelName(String string) {
        this.m_ModelName = string;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public void setLocale(Locale locale) {
        this.m_Locale = locale;
    }

    public String getRecordSource() {
        return this.m_RecordSource;
    }

    public void setRecordSource(String string) {
        this.m_RecordSource = string;
    }

    public String getPageHeaderFlags() {
        return this.m_PageHeaderFlags;
    }

    public void setPageHeaderFlags(String string) {
        this.m_PageHeaderFlags = string;
    }

    public String getPageFooterFlags() {
        return this.m_PageFooterFlags;
    }

    public void setPageFooterFlags(String string) {
        this.m_PageFooterFlags = string;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public void setWidth(int n) {
        this.m_Width = n;
    }

    public int getRecordCount() {
        return this.m_RecordCount;
    }

    public void setRecordCount(int n) {
        this.m_RecordCount = n;
    }

    public String getXmlBase() {
        return this.m_XmlBase;
    }

    public void setXmlBase(String string) {
        this.m_XmlBase = string;
    }

    public LogicalReport deepCopy() {
        LogicalReport logicalReport = new LogicalReport();
        this.copyInto(logicalReport);
        return logicalReport;
    }

    protected void copyInto(LogicalReport logicalReport) {
        logicalReport.m_Phase = this.m_Phase;
        logicalReport.m_Caption = this.m_Caption;
        logicalReport.m_ModelName = this.m_ModelName;
        logicalReport.m_Name = this.m_Name;
        logicalReport.m_Locale = this.m_Locale;
        logicalReport.m_RecordSource = this.m_RecordSource;
        logicalReport.m_PageHeaderFlags = this.m_PageHeaderFlags;
        logicalReport.m_PageFooterFlags = this.m_PageFooterFlags;
        logicalReport.m_Width = this.m_Width;
        logicalReport.m_RecordCount = this.m_RecordCount;
        logicalReport.m_XmlBase = this.m_XmlBase;
        logicalReport.m_PageSetup = new HashMap<String, PageSetup>();
        for (Map.Entry<String, PageSetup> object : this.m_PageSetup.entrySet()) {
            logicalReport.addPageSetup(object.getValue().deepCopy());
        }
        logicalReport.m_Parameter = new HashMap<String, Parameter>();
        for (Map.Entry<String, IBean> entry : this.m_Parameter.entrySet()) {
            logicalReport.addParameter(((Parameter)entry.getValue()).deepCopy());
        }
        logicalReport.m_PageSequence = new ArrayList<PageSequence>();
        for (PageSequence pageSequence : this.m_PageSequence) {
            logicalReport.addPageSequence(pageSequence.deepCopy());
        }
    }
}

