/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.jdom.Element;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PageSequence
extends LogicalModelElement
implements IBean {
    protected List<Page> m_Page = new ArrayList<Page>();
    protected String m_MasterName;
    protected boolean m_ResetPageCount;
    protected boolean m_KeepBlankPages;
    protected transient int m_CachedPageCount;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "page-sequence";
    }

    @Override
    public void loaded() {
        super.loaded();
        Iterator<Page> iterator = this.m_Page.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Page != null) {
            Iterator<Page> iterator = this.m_Page.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Page = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_MasterName != null) {
            element.setAttribute("Master_Name", this.m_MasterName);
        }
        element.setAttribute("ResetPageCount", this.m_ResetPageCount ? "Yes" : "No");
        element.setAttribute("KeepBlankPages", this.m_KeepBlankPages ? "Yes" : "No");
        element.setAttribute("", Integer.toString(this.m_CachedPageCount));
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        PageSequence pageSequence = (PageSequence)super.shallowCopy();
        pageSequence.m_MasterName = this.m_MasterName;
        pageSequence.m_ResetPageCount = this.m_ResetPageCount;
        pageSequence.m_KeepBlankPages = this.m_KeepBlankPages;
        pageSequence.m_CachedPageCount = this.m_CachedPageCount;
        return pageSequence;
    }

    public void addPage(Page page) {
        this.m_Page.add(page);
    }

    public void addPage(int n, Page page) {
        this.m_Page.add(n, page);
    }

    public void addAllPages(Collection<Page> collection) {
        this.m_Page.addAll(collection);
    }

    public int indexOfPage(Page page) {
        return this.m_Page.indexOf(page);
    }

    public void removePage(Page page) {
        this.m_Page.remove(page);
    }

    public void removeAllPages(Collection collection) {
        this.m_Page.removeAll(collection);
    }

    public void removeAllPages() {
        this.m_Page.clear();
    }

    public Page getPage(int n) {
        return this.m_Page.get(n);
    }

    public int getPageCount() {
        return this.m_Page.size();
    }

    public Iterator<Page> getPageIterator() {
        return this.m_Page.iterator();
    }

    public List<Page> getPageList() {
        return this.m_Page;
    }

    public void setPageList(List<Page> list) {
        this.m_Page = list;
    }

    public String getMasterName() {
        return this.m_MasterName;
    }

    public void setMasterName(String string) {
        this.m_MasterName = string;
    }

    public boolean isResetPageCount() {
        return this.m_ResetPageCount;
    }

    public void setResetPageCount(boolean bl) {
        this.m_ResetPageCount = bl;
    }

    public boolean isKeepBlankPages() {
        return this.m_KeepBlankPages;
    }

    public void setKeepBlankPages(boolean bl) {
        this.m_KeepBlankPages = bl;
    }

    public int getCachedPageCount() {
        return this.m_CachedPageCount;
    }

    public void setCachedPageCount(int n) {
        this.m_CachedPageCount = n;
    }

    @Override
    public PageSequence deepCopy() {
        PageSequence pageSequence = new PageSequence();
        this.copyInto(pageSequence);
        return pageSequence;
    }

    protected void copyInto(PageSequence pageSequence) {
        super.copyInto(pageSequence);
        pageSequence.m_MasterName = this.m_MasterName;
        pageSequence.m_ResetPageCount = this.m_ResetPageCount;
        pageSequence.m_KeepBlankPages = this.m_KeepBlankPages;
        pageSequence.m_CachedPageCount = this.m_CachedPageCount;
        pageSequence.m_Page = new ArrayList<Page>();
        for (Page page : this.m_Page) {
            pageSequence.addPage(page.deepCopy());
        }
    }
}

