/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.report2.logical.model.LogicalElementSAXOut;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import org.xml.sax.helpers.AttributesImpl;

public class RectangleSAXOut
extends LogicalElementSAXOut {
    @Override
    public String getTagName() {
        return "rect";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        Rectangle rectangle = (Rectangle)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(rectangle, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, rectangle);
        this.outputChildren(iSAXOut, rectangle);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        Rectangle rectangle = (Rectangle)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(rectangle, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, rectangle);
        this.outputChildren(iSAXOut, rectangle);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(Rectangle rectangle, AttributesImpl attributesImpl) {
        String string;
        String string2 = rectangle.getBackgroundColor();
        if (string2 != null) {
            string = "Back_Color";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = rectangle.getBorderStyle()) != null) {
            string = "Border_Style";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "Border_Width";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getBorderWidth()));
        string2 = rectangle.getBorderColor();
        if (string2 != null) {
            string = "Border_Color";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "Left_Border";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isBorderLeft() ? "Yes" : "No");
        string2 = "Top_Border";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isBorderTop() ? "Yes" : "No");
        string2 = "Right_Border";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isBorderRight() ? "Yes" : "No");
        string2 = "Bottom_Border";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isBorderBottom() ? "Yes" : "No");
        string2 = "Border_Radius";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getBorderRadius()));
        string2 = "padding-left";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getPaddingLeft()));
        string2 = "padding-right";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getPaddingRight()));
        string2 = "padding-top";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getPaddingTop()));
        string2 = "padding-bottom";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getPaddingBottom()));
        string2 = "curved-clip";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isCurvedClip() ? "Yes" : "No");
        string2 = "padded-clip";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isPaddedClip() ? "Yes" : "No");
        string2 = "no-clip";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isNoClip() ? "Yes" : "No");
        string2 = "Table_of_Contents";
        attributesImpl.addAttribute("", string2, string2, "CDATA", rectangle.isTableOfContents() ? "Yes" : "No");
        string2 = rectangle.getTOCTitle();
        if (string2 != null) {
            string = "TOC_Title";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "TOC_Level";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(rectangle.getTOCLevel()));
        super.buildAttributes(rectangle, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, Rectangle rectangle) {
        super.outputChild(iSAXOut, rectangle);
    }

    public void outputChildren(ISAXOut iSAXOut, Rectangle rectangle) {
        super.outputChildren(iSAXOut, rectangle);
        iSAXOut.output(rectangle.getLogicalElementIterator());
    }
}

