/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.ILogicalRenderer;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.ISplittableElement;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.util.ElementUtil;
import com.elixirtech.report2.util.LogicalElementUtil;
import com.elixirtech.report2.util.MetricConvertor;
import java.util.Iterator;

public abstract class BasicLogicalRenderer
implements ILogicalRenderer {
    @Override
    public abstract void render(LogicalRenderContext var1, RawModelElement var2) throws RenderException;

    protected abstract ElxLoggerJ getLog();

    protected void insetBorder(RawElement rawElement, LogicalElement logicalElement) {
        java.awt.Rectangle rectangle = ElementUtil.getRect(rawElement);
        int n = RenderUtil.getBorderWidth(rawElement);
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        if (n > 0) {
            if (rawElement.isBorderLeft()) {
                rectangle.x += n;
            }
            if (rawElement.isBorderTop()) {
                rectangle.y += n;
            }
            if (rawElement.isBorderRight()) {
                n2 -= n;
            }
            if (rawElement.isBorderBottom()) {
                n3 -= n;
            }
        }
        int n4 = rawElement.getPaddingLeft();
        int n5 = rawElement.getPaddingRight();
        int n6 = rawElement.getPaddingTop();
        int n7 = rawElement.getPaddingBottom();
        rectangle.x += n4;
        rectangle.y += n6;
        rectangle.width = (n2 -= n5) - rectangle.x;
        rectangle.height = (n3 -= n7) - rectangle.y;
        LogicalElementUtil.setRect(logicalElement, rectangle);
    }

    protected java.awt.Rectangle getInsetBorder(RawElement rawElement) {
        java.awt.Rectangle rectangle = ElementUtil.getRect(rawElement);
        int n = RenderUtil.getBorderWidth(rawElement);
        if (n > 0) {
            rectangle.x += n;
            rectangle.y += n;
            rectangle.width -= 2 * n;
            rectangle.height -= 2 * n;
        }
        int n2 = rawElement.getPaddingLeft();
        int n3 = rawElement.getPaddingRight();
        int n4 = rawElement.getPaddingTop();
        int n5 = rawElement.getPaddingBottom();
        rectangle.x += n2;
        rectangle.y += n4;
        rectangle.width -= n2 + n3;
        rectangle.height -= n4 + n5;
        return rectangle;
    }

    protected void convertToPoints(java.awt.Rectangle rectangle) {
        rectangle.x = MetricConvertor.twipToPoint(rectangle.x);
        rectangle.y = MetricConvertor.twipToPoint(rectangle.y);
        rectangle.width = MetricConvertor.twipToPoint(rectangle.width);
        rectangle.height = MetricConvertor.twipToPoint(rectangle.height);
    }

    protected static Rectangle buildRect(RawElement rawElement) {
        Rectangle rectangle = new Rectangle();
        BasicLogicalRenderer.copyRectAttrs(rawElement, rectangle);
        BasicLogicalRenderer.copyPaddingAttrs(rawElement, rectangle);
        BasicLogicalRenderer.copyBackgroundAttrs(rawElement, rectangle);
        BasicLogicalRenderer.copyBorderAttrs(rawElement, rectangle);
        boolean bl = true;
        if (rawElement instanceof ISplittableElement) {
            bl = ((ISplittableElement)((Object)rawElement)).isKeepTogether();
        }
        rectangle.setKeepTogether(bl);
        rectangle.setId(rawElement.getName());
        rectangle.setRaw(rawElement);
        return rectangle;
    }

    public static void copyRectAttrs(RawElement rawElement, LogicalElement logicalElement) {
        logicalElement.setLeft(rawElement.getLeft());
        logicalElement.setTop(rawElement.getTop());
        logicalElement.setWidth(rawElement.getWidth());
        logicalElement.setHeight(rawElement.getHeight());
    }

    public static void copyPaddingAttrs(RawElement rawElement, Rectangle rectangle) {
        rectangle.setPaddingLeft(rawElement.getPaddingLeft());
        rectangle.setPaddingTop(rawElement.getPaddingTop());
        rectangle.setPaddingRight(rawElement.getPaddingRight());
        rectangle.setPaddingBottom(rawElement.getPaddingBottom());
    }

    public static void copyBackgroundAttrs(RawElement rawElement, Rectangle rectangle) {
        rectangle.setBackgroundColor(rawElement.getBackgroundColor());
    }

    public static void copyBorderAttrs(RawElement rawElement, Rectangle rectangle) {
        String string = rawElement.getBorderStyle();
        if (string != null && !string.equals(BorderStyle.NONE.NAME)) {
            rectangle.setBorderStyle(string);
            rectangle.setBorderWidth(rawElement.getBorderWidth());
            rectangle.setBorderColor(rawElement.getBorderColor());
        }
        rectangle.setBorderLeft(rawElement.isBorderLeft());
        rectangle.setBorderTop(rawElement.isBorderTop());
        rectangle.setBorderRight(rawElement.isBorderRight());
        rectangle.setBorderBottom(rawElement.isBorderBottom());
        rectangle.setBorderRadius(rawElement.getBorderRadius());
    }

    public static void buildProperties(DataHolder dataHolder) {
        DataSource dataSource = dataHolder.getDataSource();
        if (dataSource != null) {
            ReportSubstitution reportSubstitution = new ReportSubstitution();
            Iterator<Parameter> iterator = dataSource.getParameterIterator();
            while (iterator.hasNext()) {
                Parameter parameter = iterator.next();
                String string = parameter.getKey();
                if (dataHolder.containsKey(string)) continue;
                Object object = parameter.getValue();
                if (((String)object).startsWith("=")) {
                    object = "${" + (String)object + "}";
                }
                Object object2 = object = ArgumentMap.substitute((String)object, reportSubstitution);
                dataHolder.put(string, String.valueOf(object2));
            }
        }
    }
}

