/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataTable;
import com.elixirtech.glint.GlintOutput;
import com.elixirtech.glint.IGlint;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.IRmlCallbackFactory;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.callback.Callback;
import com.elixirtech.report2.logical.callback.CallbackContext;
import com.elixirtech.report2.logical.model.ByteArray;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.report2.util.ContextSubstitution;
import com.elixirtech.repository.RMLFileObject;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.util.Properties;

public class CallbackRenderer
extends BasicLogicalRenderer {
    static int m_ImageId = 1;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CallbackRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        CallbackElement callbackElement = (CallbackElement)rawModelElement;
        if (callbackElement.isVisible()) {
            Rectangle rectangle = CallbackRenderer.buildRect(callbackElement);
            rectangle.setCurvedClip(true);
            String string = callbackElement.getType();
            IRmlCallbackFactory iRmlCallbackFactory = (IRmlCallbackFactory)Elixir.get(IRmlCallbackFactory.class);
            Callback callback = iRmlCallbackFactory.getCallback(string);
            if (callback != null) {
                MyCallbackContext myCallbackContext = new MyCallbackContext(logicalRenderContext, callbackElement, rectangle);
                callback.render(callbackElement, myCallbackContext);
            } else {
                m_Log.error((Object)("No Callback found for type: " + string));
            }
            RenderUtil.growShrinkRectangle(rectangle);
            logicalRenderContext.addElement(rectangle);
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    static Object evaluateControlSource(LogicalRenderContext logicalRenderContext, String string) {
        if (StringUtil.notEmpty(string)) {
            if (string.startsWith("=")) {
                ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
                return scriptEngine.evaluate(string);
            }
            return logicalRenderContext.getData().getObject(string);
        }
        return null;
    }

    private class MyCallbackContext
    implements CallbackContext {
        LogicalRenderContext m_Context;
        CallbackElement m_Raw;
        ILogicalElementHolder m_Parent;
        java.awt.Rectangle m_Rectangle;

        public MyCallbackContext(LogicalRenderContext logicalRenderContext, CallbackElement callbackElement, ILogicalElementHolder iLogicalElementHolder) {
            this.m_Context = logicalRenderContext;
            this.m_Raw = callbackElement;
            this.m_Parent = iLogicalElementHolder;
            this.m_Rectangle = CallbackRenderer.this.getInsetBorder(callbackElement);
        }

        @Override
        public String getControlSource() {
            return this.m_Raw.getControlSource().toString();
        }

        @Override
        public CallbackElement getRaw() {
            return this.m_Raw;
        }

        @Override
        public boolean showAsImage() {
            boolean bl = this.requiresImage();
            return this.m_Raw.isShowAsImage() || bl;
        }

        private boolean requiresImage() {
            MimeType mimeType = this.m_Context.getMimeType();
            if (MimeTypes.GLINT().equals((Object)mimeType)) {
                return false;
            }
            return !MimeTypes.PDF().equals((Object)mimeType);
        }

        @Override
        public Dimension getSize() {
            return new Dimension(this.m_Rectangle.width, this.m_Rectangle.height);
        }

        @Override
        public java.awt.Rectangle getRect() {
            return new java.awt.Rectangle(this.m_Rectangle.x, this.m_Rectangle.y, this.m_Rectangle.width, this.m_Rectangle.height);
        }

        @Override
        public void setHeight(int n) {
            this.m_Rectangle.height = n;
        }

        @Override
        public boolean isPreview() {
            return false;
        }

        @Override
        public String substitute(String string, String string2, String string3) {
            return ContextSubstitution.substitute(this.m_Context, string, string2, string3);
        }

        @Override
        public IFontMeasurer getFontMeasurer(Font font) {
            return this.m_Context.getFontMeasurer(font);
        }

        @Override
        public Object evaluate(String string, String string2) {
            ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
            return scriptEngine.evaluate(string, "callback script", string2);
        }

        @Override
        public String getParameter(String string) {
            Parameter parameter = this.m_Raw.getParameter(string);
            if (parameter != null) {
                return parameter.getValue();
            }
            return null;
        }

        @Override
        public Data getData() {
            return this.m_Context.getData();
        }

        @Override
        public DataTable getDataTable(String string, Properties properties) {
            return this.m_Context.getDataTable(string, properties);
        }

        public DataTable getDataTable(String string, Object[] objectArray) {
            return null;
        }

        @Override
        public Object getDataValue() {
            return CallbackRenderer.evaluateControlSource(this.m_Context, this.m_Raw.getControlSource().toString());
        }

        @Override
        public IGlint getGlint() {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GlintOutput glintOutput = new GlintOutput(byteArrayOutputStream){

                @Override
                public void flush() {
                    super.flush();
                    Glint glint = new Glint();
                    glint.setLeft(MyCallbackContext.this.m_Rectangle.x);
                    glint.setTop(MyCallbackContext.this.m_Rectangle.y);
                    glint.setWidth(MyCallbackContext.this.m_Rectangle.width);
                    glint.setHeight(MyCallbackContext.this.m_Rectangle.height);
                    glint.setRaw(MyCallbackContext.this.m_Raw);
                    ByteArray byteArray = new ByteArray();
                    byteArray.setBytes(byteArrayOutputStream.toByteArray());
                    glint.setByteArray(byteArray);
                    MyCallbackContext.this.addOutput(glint);
                }
            };
            glintOutput.init(this.m_Rectangle.width, this.m_Rectangle.height, 1);
            return glintOutput;
        }

        @Override
        public void setImage(BufferedImage bufferedImage) {
            Image image = new Image();
            image.setLeft(this.m_Rectangle.x);
            image.setTop(this.m_Rectangle.y);
            image.setWidth(this.m_Rectangle.width);
            image.setHeight(this.m_Rectangle.height);
            image.setRaw(this.m_Raw);
            image.setPicture("CallbackImage" + m_ImageId);
            image.setSizeMode("Zoom");
            image.setHorizontalAlign(Alignment.CENTER.NAME);
            image.setVerticalAlign(Alignment.CENTER.NAME);
            ++m_ImageId;
            image.setImage(bufferedImage);
            this.addOutput(image);
        }

        @Override
        public void addOutput(LogicalElement logicalElement) {
            this.m_Parent.addLogicalElement(logicalElement);
            if (((Rectangle)this.m_Parent).getLogicalElementCount() > 1) {
                ((Rectangle)this.m_Parent).setKeepTogether(false);
            }
        }

        @Override
        public RMLFileObject getFile(String string) throws FileNotFoundException {
            RenderStack renderStack = RenderStack.current();
            return renderStack.getFile(string);
        }
    }
}

