/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.data2.olap.CubeGrouping;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.data2.olap.Hierarchy;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.RootTreeNode;
import com.elixirtech.ensemble.cube.ITableStyle;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.CubeTableRenderer;
import com.elixirtech.report2.logical.renderer.FixedRowWidthEqualizer;
import com.elixirtech.report2.logical.renderer.Label;
import com.elixirtech.report2.logical.renderer.MinMaxRowWidthEqualizer;
import com.elixirtech.report2.logical.renderer.RowWidthEqualizer;
import com.elixirtech.report2.logical.renderer.TextTable;
import com.elixirtech.report2.logical.renderer.TextTree;
import com.elixirtech.report2.raw.model.CubeColumn;
import com.elixirtech.report2.raw.model.CubeHeader;
import com.elixirtech.report2.raw.model.CubeHierarchy;
import com.elixirtech.report2.raw.model.CubeLevel;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.CubeRow;
import com.elixirtech.report2.raw.model.CubeTable;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.util.ContextSubstitution;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CubeTableRenderInstance {
    private LogicalRenderContext m_Context;
    private CubeTable m_CubeTable;
    private Cube m_Cube;
    private Map<String, IDimension> m_HierarchyMap;
    private TextTree m_ColumnTree;
    private TextTree m_RowTree;
    private static Set<MimeType> m_ForcedNonPagedMIMETypes = new HashSet<MimeType>();
    private static Set<MimeType> m_NonPagedMIMETypes;
    private static final ElxLoggerJ m_Log;

    public CubeTableRenderInstance(LogicalRenderContext logicalRenderContext, CubeTable cubeTable) {
        block18: {
            this.m_HierarchyMap = new HashMap<String, IDimension>();
            this.m_Context = logicalRenderContext;
            this.m_CubeTable = cubeTable;
            try {
                Object[] objectArray;
                IDataSource iDataSource;
                Object object;
                if (!this.m_CubeTable.isVisible()) break block18;
                Section section = cubeTable.getChunk().getSection();
                String string = section.getDataSource();
                IDataCacheManager iDataCacheManager = this.m_Context.getDataCacheManager();
                String string2 = cubeTable.getCache();
                DataTable dataTable = null;
                String string3 = cubeTable.getDataRange();
                if (StringUtil.isEmpty(string2) || string2.equals(string)) {
                    object = this.m_Context.getData();
                    if ("All".equals(string3)) {
                        dataTable = object.getDataTable();
                    } else if ("Group".equals(string3)) {
                        iDataSource = object.getDataTable();
                        objectArray = object.getGroup();
                        int n = objectArray.getStart();
                        int n2 = objectArray.getStop();
                        dataTable = ((DataTable)iDataSource).subTable(n, n2 - n + 1);
                    } else {
                        iDataSource = object.getDataTable();
                        int n = object.getRecordIndex();
                        dataTable = ((DataTable)iDataSource).subTable(n, 1);
                    }
                } else {
                    object = iDataCacheManager.getCacheName(string2);
                    iDataSource = null;
                    if (iDataCacheManager.hasCache(object)) {
                        iDataSource = iDataCacheManager.getCache(object);
                    }
                    if (iDataSource == null) {
                        objectArray = new DataHolder((String)object);
                        iDataSource = iDataCacheManager.loadCache((String)object, objectArray.getProperties());
                    }
                    if ("All".equals(string3) || "Group".equals(string3)) {
                        dataTable = iDataSource;
                    } else {
                        objectArray = new DataRecord[]{iDataSource.getRecord()};
                        dataTable = new DataTable(string2, iDataSource.getSchema(), (DataRecord[])objectArray);
                    }
                }
                try {
                    if (dataTable != null) {
                        object = new Rectangle();
                        ((LogicalModelElement)object).setRaw(cubeTable);
                        CubeTableRenderer.copyAttrs(cubeTable, (Rectangle)object);
                        this.m_Cube = new Cube((IDataSource)dataTable);
                        this.buildHierarchies();
                        iDataSource = this.buildRows();
                        objectArray = this.buildColumns();
                        Measure[] measureArray = this.buildMeasures();
                        CubeDataSource cubeDataSource = new CubeDataSource("Cube", this.m_Cube, (IDimension[])iDataSource, (IDimension[])objectArray, measureArray);
                        cubeDataSource.setCollapseRows(cubeTable.isCollapseRows());
                        cubeDataSource.setCollapseColumns(cubeTable.isCollapseColumns());
                        cubeDataSource.setKeepRowTotals(cubeTable.isKeepRowTotals());
                        cubeDataSource.setKeepColumnTotals(cubeTable.isKeepColumnTotals());
                        cubeDataSource.setRowTitle(cubeTable.getRow().getTitle());
                        cubeDataSource.setColumnTitle(cubeTable.getColumn().getTitle());
                        cubeDataSource.setRowTotalsAfter(cubeTable.isShowRowTotalsAfterDetails());
                        cubeDataSource.setColumnTotalsAfter(cubeTable.isShowColumnTotalsAfterDetails());
                        DefaultPushContext defaultPushContext = new DefaultPushContext();
                        DataTable dataTable2 = DataTable.build(defaultPushContext, (IDataSource)cubeDataSource);
                        CubeGrouping cubeGrouping = cubeDataSource.getRowGrouping(defaultPushContext);
                        CubeGrouping cubeGrouping2 = cubeDataSource.getColumnGrouping(defaultPushContext);
                        int n = cubeGrouping.getLevelCount();
                        int n3 = cubeGrouping2.getLevelCount();
                        int n4 = this.getLineHeight(this.m_Context);
                        Rectangle rectangle = this.buildRows(this.m_Context, cubeGrouping, n4);
                        Rectangle rectangle2 = this.buildColumns(this.m_Context, cubeGrouping2, measureArray, n4);
                        CubeTableRenderInstance.resize(rectangle);
                        int n5 = ((LogicalElement)object).getLeft() + RenderUtil.getBorderLeft((IBean)object) + ((Rectangle)object).getPaddingLeft();
                        int n6 = ((LogicalElement)object).getTop() + RenderUtil.getBorderTop((IBean)object) + ((Rectangle)object).getPaddingTop();
                        Rectangle rectangle3 = this.buildData(cubeGrouping, cubeGrouping2, this.m_Context, dataTable2, n, n3, n4, n5 + rectangle.getWidth());
                        CubeTableRenderInstance.resize(rectangle3);
                        CubeTableRenderInstance.resize(rectangle2);
                        CubeTableRenderer.shiftTo(rectangle, n5, n6 + rectangle2.getHeight() - (this.hasRowLabels() ? n4 : 0));
                        CubeTableRenderer.shiftTo(rectangle2, n5 + rectangle.getWidth(), n6);
                        CubeTableRenderer.shiftTo(rectangle3, n5 + rectangle.getWidth(), n6 + rectangle2.getHeight());
                        if (this.m_CubeTable.isMergeHeaderBorders()) {
                            this.m_ColumnTree.mergeBorders();
                            if (this.m_RowTree != null) {
                                this.m_RowTree.mergeBorders();
                            }
                            if (this.m_RowTree != null) {
                                // empty if block
                            }
                        }
                        ((Rectangle)object).addLogicalElement(rectangle);
                        ((Rectangle)object).addLogicalElement(rectangle2);
                        ((Rectangle)object).addLogicalElement(rectangle3);
                        RenderUtil.growShrinkRectangle((Rectangle)object);
                        this.fixWidth(this.m_Context, (Rectangle)object);
                        this.m_Context.addElement((LogicalElement)object);
                    }
                }
                catch (DataException dataException) {
                    m_Log.error((Object)("Can't access data cache: " + string2 + " : " + String.valueOf(dataException)));
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't render cube: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }

    private boolean bordersMatch(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.getBorderStyle().equals(rectangle2.getBorderStyle()) && rectangle.getBorderWidth() == rectangle2.getBorderWidth()) {
            return rectangle.getBorderColor().equals(rectangle2.getBorderColor());
        }
        return false;
    }

    private static void resize(Rectangle rectangle) {
        rectangle.setHeight(CubeTableRenderInstance.calcBottom(rectangle));
        rectangle.setWidth(CubeTableRenderInstance.calcRight(rectangle) - rectangle.getLeft());
    }

    private static int calcBottom(Rectangle rectangle) {
        int n = rectangle.getTop() + rectangle.getTopMargin();
        Iterator<LogicalElement> iterator = rectangle.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            int n2 = logicalElement.getTop() + logicalElement.getHeight();
            n = Math.max(n, n2);
        }
        int n3 = n + rectangle.getBottomMargin();
        return n3 % 20 == 0 ? n3 : n3 + (20 - n3 % 20);
    }

    public static int calcRight(Rectangle rectangle) {
        int n = rectangle.getLeft() + rectangle.getLeftMargin();
        Iterator<LogicalElement> iterator = rectangle.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            int n2 = logicalElement.getLeft() + logicalElement.getWidth();
            n = Math.max(n, n2);
        }
        return n + rectangle.getRightMargin();
    }

    private void fixWidth(LogicalRenderContext logicalRenderContext, Rectangle rectangle) {
        boolean bl = this.m_CubeTable.isWidthGrowable();
        boolean bl2 = this.m_CubeTable.isWidthShrinkable();
        if (bl || bl2) {
            int n = rectangle.getWidth();
            int n2 = Math.max(0, CubeTableRenderInstance.calcRight(rectangle) - rectangle.getLeft());
            if (bl && n < n2) {
                rectangle.setWidth(n2);
                if (this.m_CubeTable.isGrowHPageCount()) {
                    int n3 = rectangle.getLeft() + rectangle.getWidth();
                    PageSetup pageSetup = logicalRenderContext.getPageSetup();
                    int n4 = pageSetup.getUsablePageWidth();
                    int n5 = n3 / n4 + 1;
                    if (pageSetup.getHorizontalPageCount() < n5) {
                        pageSetup.setHorizontalPageCount(n5);
                    }
                }
            } else if (bl2 && n > n2) {
                rectangle.setWidth(n2);
            }
        }
    }

    private int getLineHeight(LogicalRenderContext logicalRenderContext) {
        CubeRow cubeRow = this.m_CubeTable.getRow();
        Font font = new Font(cubeRow.getFontName(), cubeRow.isFontBold(), cubeRow.isFontItalic(), cubeRow.getFontSize());
        IFontMeasurer iFontMeasurer = logicalRenderContext.getFontMeasurer(font);
        float f = iFontMeasurer.getHeight() + (float)cubeRow.getTopMargin() + (float)cubeRow.getBottomMargin();
        Iterator<CubeMeasure> iterator = this.m_CubeTable.getMeasureIterator();
        while (iterator.hasNext()) {
            CubeMeasure cubeMeasure = iterator.next();
            Font font2 = new Font(cubeMeasure.getFontName(), cubeMeasure.isFontBold(), cubeMeasure.isFontItalic(), cubeMeasure.getFontSize());
            IFontMeasurer iFontMeasurer2 = logicalRenderContext.getFontMeasurer(font2);
            float f2 = iFontMeasurer2.getHeight() + (float)cubeMeasure.getTopMargin() + (float)cubeMeasure.getBottomMargin();
            f = Math.max(f, f2);
        }
        int n = (int)Math.ceil(f);
        int n2 = n % 20 == 0 ? n : n + (20 - n) % 20;
        return n2;
    }

    private void buildHierarchies() {
        Iterator<CubeHierarchy> iterator = this.m_CubeTable.getHierarchyIterator();
        while (iterator.hasNext()) {
            CubeHierarchy cubeHierarchy = iterator.next();
            String string = cubeHierarchy.getName();
            Level[] levelArray = new Level[cubeHierarchy.getLevelCount()];
            for (int i = 0; i < levelArray.length; ++i) {
                CubeLevel cubeLevel = cubeHierarchy.getLevel(i);
                levelArray[i] = this.m_Cube.createLevel(cubeLevel.getName(), cubeLevel.getSort(), cubeLevel.getGroupOn(), cubeLevel.getGroupData(), cubeLevel.getDerivedField(), cubeLevel.getTotalTitle(), !cubeLevel.isHideTotals());
            }
            IDimension iDimension = this.m_Cube.createHierarchy(string, levelArray);
            this.m_HierarchyMap.put(string, iDimension);
        }
    }

    private String[] buildRowLevelTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        if (this.m_CubeTable.isKeepRowTotals()) {
            string = CubeTableRenderInstance.substitute(this.m_Context, this.m_CubeTable.getRowTotalsTitle());
        }
        arrayList.add(string);
        CubeRow cubeRow = this.m_CubeTable.getRow();
        if (cubeRow != null) {
            int n = cubeRow.getItemCount();
            for (int i = 0; i < n; ++i) {
                CubeLevel cubeLevel = cubeRow.getItem(i);
                String string2 = cubeLevel.getName();
                if (this.m_HierarchyMap.containsKey(string2)) {
                    Hierarchy hierarchy = (Hierarchy)this.m_HierarchyMap.get(string2);
                    this.buildHierachyTitle(hierarchy, arrayList);
                    continue;
                }
                arrayList.add(CubeTableRenderInstance.substitute(this.m_Context, cubeLevel.getTotalTitle()));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void buildHierachyTitle(Hierarchy hierarchy, ArrayList<String> arrayList) {
        int n = hierarchy.getLevelCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(CubeTableRenderInstance.substitute(this.m_Context, hierarchy.getLevel(i).getTotalTitle()));
        }
    }

    private IDimension[] buildRows() {
        IDimension[] iDimensionArray;
        CubeRow cubeRow = this.m_CubeTable.getRow();
        if (cubeRow != null) {
            iDimensionArray = new IDimension[cubeRow.getItemCount()];
            for (int i = 0; i < iDimensionArray.length; ++i) {
                CubeLevel cubeLevel = cubeRow.getItem(i);
                String string = cubeLevel.getName();
                if (this.m_HierarchyMap.containsKey(string)) {
                    iDimensionArray[i] = this.m_HierarchyMap.get(string);
                    continue;
                }
                Level level = this.m_Cube.createLevel(string, cubeLevel.getSort(), cubeLevel.getGroupOn(), cubeLevel.getGroupData(), cubeLevel.getDerivedField(), cubeLevel.getTotalTitle(), !cubeLevel.isHideTotals());
                iDimensionArray[i] = this.m_Cube.createDimension(level);
            }
        } else {
            iDimensionArray = new IDimension[]{};
        }
        return iDimensionArray;
    }

    private String[] buildColLevelTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        if (this.m_CubeTable.isKeepColumnTotals()) {
            string = CubeTableRenderInstance.substitute(this.m_Context, this.m_CubeTable.getColumnTotalsTitle());
        }
        arrayList.add(string);
        CubeColumn cubeColumn = this.m_CubeTable.getColumn();
        if (cubeColumn != null) {
            int n = cubeColumn.getItemCount();
            for (int i = 0; i < n; ++i) {
                CubeLevel cubeLevel = cubeColumn.getItem(i);
                String string2 = cubeLevel.getName();
                if (this.m_HierarchyMap.containsKey(string2)) {
                    Hierarchy hierarchy = (Hierarchy)this.m_HierarchyMap.get(string2);
                    this.buildHierachyTitle(hierarchy, arrayList);
                    continue;
                }
                arrayList.add(CubeTableRenderInstance.substitute(this.m_Context, cubeLevel.getTotalTitle()));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private IDimension[] buildColumns() {
        IDimension[] iDimensionArray;
        CubeColumn cubeColumn = this.m_CubeTable.getColumn();
        if (cubeColumn != null) {
            iDimensionArray = new IDimension[cubeColumn.getItemCount()];
            for (int i = 0; i < iDimensionArray.length; ++i) {
                CubeLevel cubeLevel = cubeColumn.getItem(i);
                String string = cubeLevel.getName();
                if (this.m_HierarchyMap.containsKey(string)) {
                    iDimensionArray[i] = this.m_HierarchyMap.get(string);
                    continue;
                }
                Level level = this.m_Cube.createLevel(string, cubeLevel.getSort(), cubeLevel.getGroupOn(), cubeLevel.getGroupData(), cubeLevel.getDerivedField(), cubeLevel.getTotalTitle(), !cubeLevel.isHideTotals());
                iDimensionArray[i] = this.m_Cube.createDimension(level);
            }
        } else {
            iDimensionArray = new IDimension[]{};
        }
        return iDimensionArray;
    }

    private Measure[] buildMeasures() throws DataException {
        CubeHelper.MeasureInfoSet measureInfoSet = new CubeHelper.MeasureInfoSet(){

            @Override
            public int getCount() {
                return CubeTableRenderInstance.this.m_CubeTable.getMeasureCount();
            }

            @Override
            public String[] getFunctionInfo(int n) {
                CubeMeasure cubeMeasure = CubeTableRenderInstance.this.m_CubeTable.getMeasure(n);
                return new String[]{cubeMeasure.getName(), cubeMeasure.getFunction(), cubeMeasure.getPattern()};
            }

            @Override
            public Cube getCube() {
                return CubeTableRenderInstance.this.m_Cube;
            }
        };
        return CubeHelper.buildMeasures(measureInfoSet);
    }

    protected boolean hasRowLabels() {
        return this.m_CubeTable.isShowRowHeaderLabels();
    }

    protected Rectangle buildRows(LogicalRenderContext logicalRenderContext, CubeGrouping cubeGrouping, int n) {
        Rectangle rectangle = new Rectangle();
        if (this.m_CubeTable.isShowRowHeaders()) {
            Object object;
            int n2;
            Object object2;
            TextTree.TextEx[] textExArray;
            int[] nArray;
            CubeRow cubeRow = this.m_CubeTable.getRow();
            rectangle.setRaw(cubeRow);
            Font font = new Font(cubeRow.getFontName(), cubeRow.isFontBold(), cubeRow.isFontItalic(), cubeRow.getFontSize());
            IFontMeasurer iFontMeasurer = logicalRenderContext.getFontMeasurer(font);
            RootTreeNode rootTreeNode = cubeGrouping.getRoot();
            String string = CubeTableRenderInstance.substitute(logicalRenderContext, cubeRow.getTitle());
            boolean bl = this.m_CubeTable.isShowRowTotalsAfterDetails();
            String string2 = "";
            if (this.m_CubeTable.isKeepRowTotals()) {
                string2 = CubeTableRenderInstance.substitute(logicalRenderContext, this.m_CubeTable.getRowTotalsTitle());
            }
            String[] stringArray = this.buildRowLevelTitles();
            this.m_RowTree = new TextTree((CubeHeader)cubeRow, string, rootTreeNode, iFontMeasurer, string2, stringArray, bl);
            String string3 = cubeRow.getWidthOverrideType();
            int n3 = cubeRow.getWidthOverride();
            if (this.hasRowLabels()) {
                stringArray[0] = string;
                nArray = new int[stringArray.length];
                textExArray = new TextTree.TextEx[stringArray.length];
                object2 = this.m_RowTree.getTableStyle();
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    textExArray[n2] = this.m_RowTree.createText(stringArray[n2]);
                    nArray[n2] = textExArray[n2].getWidth();
                    textExArray[n2].setRaw(this.m_CubeTable);
                    textExArray[n2].applyStyles(cubeRow, (ITableStyle)object2, 0);
                    rectangle.addLogicalElement(textExArray[n2]);
                }
            } else {
                nArray = new int[]{};
                textExArray = new TextTree.TextEx[]{};
            }
            object2 = "Fixed".equals(string3) ? new FixedRowWidthEqualizer(this.m_RowTree, n3) : ("Maximum".equals(string3) ? new MinMaxRowWidthEqualizer(this.m_RowTree, nArray, MinMaxRowWidthEqualizer.Type.MAX, n3) : ("Minimum".equals(string3) ? new MinMaxRowWidthEqualizer(this.m_RowTree, nArray, MinMaxRowWidthEqualizer.Type.MIN, n3) : new RowWidthEqualizer(this.m_RowTree, nArray)));
            n2 = this.hasRowLabels() ? n : 0;
            this.m_RowTree.layoutVertical(0, n2, n);
            if (this.hasRowLabels()) {
                object = object2.getWidths();
                assert (((Object)object).length == textExArray.length);
                int n4 = 0;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    textExArray[i].setLeft(n4);
                    textExArray[i].setTop(0);
                    textExArray[i].setWidth((int)object[i]);
                    textExArray[i].setHeight(n);
                    textExArray[i].constrainText();
                    n4 += object[i];
                }
            }
            object = this.m_RowTree.getTextIterator();
            while (object.hasNext()) {
                TextTree.TextEx textEx = (TextTree.TextEx)object.next();
                textEx.setRaw(this.m_CubeTable);
                rectangle.addLogicalElement(textEx);
            }
        }
        return rectangle;
    }

    protected Rectangle buildColumns(LogicalRenderContext logicalRenderContext, CubeGrouping cubeGrouping, Measure[] measureArray, int n) {
        Rectangle rectangle = new Rectangle();
        CubeColumn cubeColumn = this.m_CubeTable.getColumn();
        rectangle.setRaw(cubeColumn);
        Font font = new Font(cubeColumn.getFontName(), cubeColumn.isFontBold(), cubeColumn.isFontItalic(), cubeColumn.getFontSize());
        IFontMeasurer iFontMeasurer = logicalRenderContext.getFontMeasurer(font);
        RootTreeNode rootTreeNode = cubeGrouping.getRoot();
        String string = CubeTableRenderInstance.substitute(logicalRenderContext, cubeColumn.getTitle());
        boolean bl = this.m_CubeTable.isShowColumnTotalsAfterDetails();
        String[] stringArray = this.buildColLevelTitles();
        this.m_ColumnTree = new TextTree((CubeHeader)cubeColumn, string, rootTreeNode, iFontMeasurer, stringArray, bl, measureArray);
        this.m_ColumnTree.showHeaders(this.m_CubeTable.isShowColumnHeaders());
        this.m_ColumnTree.layoutHorizontal(n);
        Iterator<TextTree.TextEx> iterator = this.m_ColumnTree.getTextIterator();
        while (iterator.hasNext()) {
            TextTree.TextEx textEx = iterator.next();
            textEx.setRaw(this.m_CubeTable);
            rectangle.addLogicalElement(textEx);
        }
        return rectangle;
    }

    protected Rectangle buildData(CubeGrouping cubeGrouping, CubeGrouping cubeGrouping2, LogicalRenderContext logicalRenderContext, DataTable dataTable, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Rectangle rectangle = new Rectangle();
        rectangle.setRaw(this.m_CubeTable);
        int n7 = this.m_CubeTable.getMeasureCount();
        CubeMeasure[] cubeMeasureArray = new CubeMeasure[n7];
        IFontMeasurer[] iFontMeasurerArray = new IFontMeasurer[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            cubeMeasureArray[n6] = this.m_CubeTable.getMeasure(n6);
            Font font = new Font(cubeMeasureArray[n6].getFontName(), cubeMeasureArray[n6].isFontBold(), cubeMeasureArray[n6].isFontItalic(), cubeMeasureArray[n6].getFontSize());
            iFontMeasurerArray[n6] = logicalRenderContext.getFontMeasurer(font);
        }
        n6 = this.m_CubeTable.isShowRowTotalsAfterDetails() ? 1 : 0;
        boolean bl = this.m_CubeTable.isShowColumnTotalsAfterDetails();
        TextTable textTable = new TextTable(cubeGrouping, cubeGrouping2, n6 != 0, bl, dataTable, iFontMeasurerArray, cubeMeasureArray, n, n2, n3);
        Object object = this.m_ColumnTree.getLeafIterator();
        for (int i = 0; object.hasNext() && i < textTable.getColumnCount(); ++i) {
            LogicalElement logicalElement = object.next();
            n5 = logicalElement.getWidth();
            int n8 = textTable.getColumnWidth(i);
            int n9 = Math.max(n5, n8);
            CubeMeasure cubeMeasure = this.m_CubeTable.getMeasure(i % n7);
            String string = cubeMeasure.getWidthOverrideType();
            if ("Fixed".equals(string)) {
                n9 = cubeMeasure.getWidthOverride();
            } else if ("Maximum".equals(string)) {
                n9 = Math.min(n9, cubeMeasure.getWidthOverride());
            } else if ("Minimum".equals(string)) {
                n9 = Math.max(n9, cubeMeasure.getWidthOverride());
            }
            if (n9 != n8) {
                textTable.setColumnWidth(i, n9);
            }
            if (n9 == n5) continue;
            this.m_ColumnTree.setColumnWidth(i, n9, n3);
        }
        if (CubeTableRenderInstance.isPaged(this.m_Context)) {
            PageSetup pageSetup = logicalRenderContext.getPageSetup();
            int n10 = pageSetup.getUsablePageWidth();
            int n11 = n10 - n4;
            textTable.adjustColumns(n11, n10);
            n5 = textTable.getColumnCount();
            int[] nArray = new int[n5];
            int[] nArray2 = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = textTable.getColumnLeft(i);
                nArray2[i] = textTable.getColumnWidth(i);
            }
            this.m_ColumnTree.adjustColumns(nArray, nArray2);
        }
        Iterator<Label> iterator = textTable.getLabelIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            rectangle.addLogicalElement(((Label)object).getLogicalElement(this.m_CubeTable));
        }
        return rectangle;
    }

    public static boolean isPaged(LogicalRenderContext logicalRenderContext) {
        MimeType mimeType = logicalRenderContext.getMimeType();
        if (m_ForcedNonPagedMIMETypes.contains(mimeType)) {
            return false;
        }
        RenderDetails renderDetails = logicalRenderContext.getRenderDetails();
        if (renderDetails == null) {
            return true;
        }
        String string = "Yes";
        if (m_NonPagedMIMETypes.contains(mimeType)) {
            string = "No";
        }
        return "Yes".equals(renderDetails.getParameterValue("Paged", string));
    }

    private static String substitute(LogicalRenderContext logicalRenderContext, String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        return ContextSubstitution.substitute(logicalRenderContext, string);
    }

    static {
        m_ForcedNonPagedMIMETypes.add(MimeTypes.CSV());
        m_ForcedNonPagedMIMETypes.add(MimeTypes.HTML());
        m_ForcedNonPagedMIMETypes.add(MimeTypes.HTML_ZIP());
        m_ForcedNonPagedMIMETypes.add(MimeTypes.XHTML());
        m_ForcedNonPagedMIMETypes.add(MimeTypes.XHTML_ZIP());
        m_ForcedNonPagedMIMETypes.add(MimeTypes.EXCEL());
        m_ForcedNonPagedMIMETypes.add(MimeTypes.XLSX());
        m_NonPagedMIMETypes = new HashSet<MimeType>();
        m_NonPagedMIMETypes.add(MimeTypes.LPT());
        m_NonPagedMIMETypes.add(MimeTypes.RML_LOGICAL());
        m_NonPagedMIMETypes.add(MimeTypes.RML_TREE());
        m_NonPagedMIMETypes.add(MimeTypes.TEXT());
        m_NonPagedMIMETypes.add(MimeTypes.XML());
        m_Log = CubeTableRenderer.m_Log;
    }
}

