/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.logical.renderer.CubeTableRenderInstance;
import com.elixirtech.report2.raw.model.CubeTable;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.util.Iterator;

public class CubeTableRenderer
extends BasicLogicalRenderer {
    public static final int COL_GAP = 100;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CubeTable.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        new CubeTableRenderInstance(logicalRenderContext, (CubeTable)rawModelElement);
    }

    protected static void copyAttrs(CubeTable cubeTable, Rectangle rectangle) {
        CubeTableRenderer.copyRectAttrs(cubeTable, rectangle);
        CubeTableRenderer.copyBackgroundAttrs(cubeTable, rectangle);
        CubeTableRenderer.copyBorderAttrs(cubeTable, rectangle);
        CubeTableRenderer.copyPaddingAttrs(cubeTable, rectangle);
        rectangle.setKeepTogether(cubeTable.isKeepTogether());
        rectangle.setId(cubeTable.getName());
        rectangle.setRaw(cubeTable);
    }

    protected static void shiftTo(Rectangle rectangle, int n, int n2) {
        int n3 = n - rectangle.getLeft();
        int n4 = n2 - rectangle.getTop();
        CubeTableRenderer.shift(rectangle, n3, n4);
    }

    protected static void shift(LogicalElement logicalElement, int n, int n2) {
        logicalElement.setLeft(logicalElement.getLeft() + n);
        logicalElement.setTop(logicalElement.getTop() + n2);
        if (logicalElement instanceof ILogicalElementHolder) {
            ILogicalElementHolder iLogicalElementHolder = (ILogicalElementHolder)((Object)logicalElement);
            Iterator<LogicalElement> iterator = iLogicalElementHolder.getLogicalElementIterator();
            while (iterator.hasNext()) {
                LogicalElement logicalElement2 = iterator.next();
                CubeTableRenderer.shift(logicalElement2, n, n2);
            }
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

