/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Detail;
import com.elixirtech.report2.logical.renderer.IChunkRenderer;
import com.elixirtech.report2.logical.renderer.TOCElementRenderer;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Section;

public class DetailRenderer
implements IChunkRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DetailRenderer.class);

    @Override
    public BodyPart render(LogicalRenderContext logicalRenderContext, Chunk chunk) {
        com.elixirtech.report2.raw.model.Detail detail = (com.elixirtech.report2.raw.model.Detail)chunk;
        if (detail.isVisible()) {
            Section section = detail.getSection();
            PageSetup pageSetup = section.getRawReport().getPageSetup(section.getPageSetup());
            Detail detail2 = new Detail();
            detail2.setRaw(detail);
            detail2.setWidth(logicalRenderContext.getColumnWidth());
            detail2.setHeight(detail.getHeight());
            detail2.setBackgroundColor(detail.getBackgroundColor());
            detail2.setKeepTogether(detail.isKeepTogether());
            detail2.setKeepWithNext(detail.isKeepWithNext());
            detail2.setTableOfContents(detail.isTableOfContents());
            ReportSubstitution reportSubstitution = new ReportSubstitution();
            String string = ArgumentMap.substitute(detail.getURL(), reportSubstitution);
            String string2 = ArgumentMap.substitute(detail.getURLDescription(), reportSubstitution);
            String string3 = ArgumentMap.substitute(detail.getURLTarget(), reportSubstitution);
            detail2.setURL(string);
            detail2.setURLDescription(string2);
            detail2.setURLTarget(string3);
            if (detail.isTableOfContents()) {
                detail2.setTOCTitle(TOCElementRenderer.processControlSource(logicalRenderContext, detail));
                detail2.setTOCLevel(logicalRenderContext.getTOCLevel());
            }
            detail2.setCaption(detail.getCaption());
            detail2.setSpaceAfter(pageSetup.getRowSpacing());
            detail2.setVerticalAlign(detail.getVerticalAlign());
            logicalRenderContext.renderChildren(detail, detail2);
            return detail2;
        }
        return null;
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

