/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.DuplicateDetector;
import com.elixirtech.report2.logical.ITextWrapper;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Empty;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.logical.renderer.FieldCache;
import com.elixirtech.report2.logical.renderer.IModelViewRenderer;
import com.elixirtech.report2.logical.renderer.TextWrapper2;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.FormatUtil;
import com.elixirtech.report2.raw.model.ModelView;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.script.ScriptEngine;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FieldRenderer
extends BasicLogicalRenderer
implements IModelViewRenderer {
    static boolean JUSTIFY_ALL = System.getProperty("elx.justify.all") != null;
    public static final FormattedObject NullObject = new FormattedObject(null, null);
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(FieldRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        Field field = (Field)rawModelElement;
        if (field.isVisible()) {
            FormattedObject formattedObject = this.getValue(logicalRenderContext, field);
            if (!formattedObject.hasDisplay() && field.isShrinkable()) {
                java.awt.Rectangle rectangle = this.getInsetBorder(field);
                Empty empty = new Empty();
                empty.setRaw(field);
                empty.setId(field.getName());
                empty.setLeft(rectangle.x);
                empty.setWidth(rectangle.width);
                empty.setTop(rectangle.y);
                logicalRenderContext.addElement(empty);
                return;
            }
            String string = formattedObject.display;
            if (string == null) {
                string = "";
            }
            boolean bl = field.isHideDuplicates();
            DuplicateDetector duplicateDetector = logicalRenderContext.getDuplicateDetector();
            if (bl) {
                string = duplicateDetector.hideDuplicate(rawModelElement, string);
            } else {
                duplicateDetector.rememberDuplicate(rawModelElement, string);
            }
            Rectangle rectangle = FieldRenderer.buildRect(field);
            rectangle.setNoClip(true);
            rectangle.setRawValue(formattedObject.value);
            FieldCache fieldCache = logicalRenderContext.getFieldCache();
            java.awt.Rectangle rectangle2 = this.getInsetBorder(field);
            List<LogicalElement> list = fieldCache.lookup(field, string);
            if (list == null) {
                FieldRenderer.layoutText(logicalRenderContext, field, rectangle, rectangle2, string);
                if (field.getOrientation() == 0 && field.getFirstLineIndent() == 0) {
                    fieldCache.store(field, string, rectangle.getLogicalElementList());
                }
            } else {
                for (LogicalElement logicalElement : list) {
                    Text text = (Text)logicalElement;
                    text.setRaw(field);
                    rectangle.addLogicalElement(text);
                    text.setLeft(rectangle2.x);
                }
            }
            this.setURLs(field, rectangle.getLogicalElementList());
            RenderUtil.growShrinkRectangle(rectangle);
            logicalRenderContext.addElement(rectangle);
        } else {
            ControlSource controlSource = field.getControlSource();
            if ("Script".equals(controlSource.getType())) {
                ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
                scriptEngine.evaluate(controlSource.getText());
            }
        }
    }

    @Override
    public void renderViews(LogicalRenderContext logicalRenderContext, ModelView modelView) {
        Field field = (Field)modelView.getModel();
        if (modelView.isVisible()) {
            FormattedObject formattedObject = this.getValue(logicalRenderContext, field);
            if (!formattedObject.hasDisplay()) {
                java.awt.Rectangle rectangle = this.getInsetBorder(modelView);
                Empty empty = new Empty();
                empty.setRaw(field);
                empty.setId(field.getName());
                empty.setLeft(rectangle.x);
                empty.setWidth(rectangle.width);
                empty.setTop(rectangle.y);
                if (!field.isShrinkable()) {
                    empty.setHeight(rectangle.height);
                }
                logicalRenderContext.addElement(empty);
                return;
            }
            int n = -1;
            int n2 = modelView.getViewCount();
            RawElement rawElement = modelView;
            String string = formattedObject.display;
            while (true) {
                Rectangle rectangle = FieldRenderer.buildRect(rawElement);
                rectangle.setRawValue(formattedObject.value);
                if (StringUtil.notEmpty(string)) {
                    java.awt.Rectangle rectangle2 = this.getInsetBorder(rawElement);
                    string = FieldRenderer.layoutText(logicalRenderContext, field, rectangle, rectangle2, string);
                    this.setURLs(field, rectangle.getLogicalElementList());
                }
                RenderUtil.growShrinkRectangle(rectangle);
                logicalRenderContext.addElement(rectangle);
                if (!StringUtil.isEmpty(string) && ++n != n2) {
                    rawElement = modelView.getView(n);
                    continue;
                }
                break;
            }
        } else {
            String string = field.getControlSource().getText();
            if (string.startsWith("=")) {
                ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
                scriptEngine.evaluate(string);
            }
        }
    }

    protected static String layoutText(LogicalRenderContext logicalRenderContext, Field field, Rectangle rectangle, java.awt.Rectangle rectangle2, String string) {
        TextWrapper2 textWrapper2 = new TextWrapper2(logicalRenderContext, field, rectangle2, string);
        textWrapper2.doLayout();
        String string2 = field.getFontName();
        boolean bl = field.isFontBold();
        boolean bl2 = field.isFontItalic();
        int n = field.getFontSize();
        boolean bl3 = field.isFontUnderline();
        boolean bl4 = field.isFontStrikethrough();
        String string3 = field.getFontColor();
        int n2 = field.getOrientation() % 360;
        String string4 = field.getTextAlign();
        boolean bl5 = "Justify".equals(string4);
        boolean bl6 = logicalRenderContext.isAutoWrap();
        Iterator<ITextWrapper.Text> iterator = textWrapper2.getLines();
        while (iterator.hasNext()) {
            ITextWrapper.Text text = iterator.next();
            Text text2 = new Text();
            text2.setRaw(field);
            text2.setLeft(text.rc.x);
            text2.setWidth(text.rc.width);
            text2.setTop(text.rc.y);
            text2.setHeight(text.rc.height);
            text2.setAscent((int)text.layout.getAscent() * 20);
            text2.setOrientation(n2);
            if (bl5 && text.lastLineOfParagraph && !JUSTIFY_ALL && bl6) {
                text2.setTextAlign("Left");
            } else {
                text2.setTextAlign(string4);
            }
            text2.setFontName(string2);
            text2.setFontBold(bl);
            text2.setFontItalic(bl2);
            text2.setFontSize(n);
            text2.setFontUnderline(bl3);
            text2.setFontStrikethrough(bl4);
            text2.setFontColor(string3);
            text2.setText(text.line);
            rectangle.addLogicalElement(text2);
        }
        return "";
    }

    protected void setURLs(Field field, List<LogicalElement> list) {
        ReportSubstitution reportSubstitution = new ReportSubstitution();
        String string = ArgumentMap.substitute(field.getURL(), reportSubstitution);
        String string2 = ArgumentMap.substitute(field.getURLDescription(), reportSubstitution);
        String string3 = ArgumentMap.substitute(field.getURLTarget(), reportSubstitution);
        for (LogicalElement logicalElement : list) {
            Text text = (Text)logicalElement;
            text.setURL(string);
            text.setURLDescription(string2);
            text.setURLTarget(string3);
        }
    }

    protected FormattedObject getValue(LogicalRenderContext logicalRenderContext, Field field) {
        Object object = ControlSourceProcessor.getData(field.getControlSource());
        if (object == null) {
            return NullObject;
        }
        if (object instanceof String) {
            return new FormattedObject(object, (String)object);
        }
        Format format = field.getFormat();
        if (format != null && format.getType() != "None") {
            java.text.Format format2 = format.getFormatter();
            if (format2 == null) {
                Locale locale = field.getLocale();
                format2 = FormatUtil.buildFormatter(format, locale);
                format.setFormatter(format2);
            }
            try {
                if (format2 != null) {
                    return new FormattedObject(object, format2.format(object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ControlSource controlSource = field.getControlSource();
                m_Log.error((Object)("Can't format " + String.valueOf(object) + " (" + controlSource.getDisplayNameValue() + ") as " + format.getType()));
                return new FormattedObject(object, "<ERROR>");
            }
        }
        return new FormattedObject(object, String.valueOf(object));
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    static class FormattedObject {
        public final Object value;
        public final String display;

        public FormattedObject(Object object, String string) {
            this.value = object;
            this.display = string;
        }

        public boolean hasDisplay() {
            return StringUtil.notEmpty(this.display);
        }
    }
}

